/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.Drawing.PointF;
import java.util.ArrayList;
import java.util.LinkedList;

public class Primitive2D {
    public static PointF endOfLine(PointF start, double angleInRadians, double length) {
        if (angleInRadians == 0.0) {
            return new PointF((float)((double)start.getX() + length), start.getY());
        }
        if (angleInRadians == Math.PI) {
            return new PointF((float)((double)start.getX() - length), start.getY());
        }
        if (angleInRadians == 1.5707963267948966) {
            return new PointF(start.getX(), (float)((double)start.getY() + length));
        }
        if (angleInRadians == -1.5707963267948966) {
            return new PointF(start.getX(), (float)((double)start.getY() - length));
        }
        float f2 = (float)(length * Math.cos(angleInRadians));
        float f3 = (float)(length * Math.sin(angleInRadians));
        return new PointF(start.getX() + f2, start.getY() + f3);
    }

    public static boolean belongToLine(PointF p1, PointF p2, PointF p3) {
        return Primitive2D.belongToLine(p1, p2, p3, 1.0E-4f);
    }

    public static boolean belongToLine(PointF p1, PointF p2, PointF p3, float precision) {
        double d2 = Primitive2D.a(p1, p2);
        double d3 = Primitive2D.a(p1, p3);
        double d4 = Primitive2D.a(p2, p3);
        if (Primitive2D.linelen(p1, p2) < precision) {
            return true;
        }
        if (Primitive2D.linelen(p1, p3) < precision) {
            return true;
        }
        if (Primitive2D.linelen(p2, p3) < precision) {
            return true;
        }
        float f2 = 1.0E-4f;
        return Math.abs(d2 - d3) < (double)f2 || Math.abs(d2 - d4) < (double)f2 || Math.abs(d3 - d4) < (double)f2;
    }

    public static boolean belongToSection(PointF sectionPoint1, PointF sectionPoint2, PointF testPoint) {
        return Primitive2D.belongToSection(sectionPoint1, sectionPoint2, testPoint, 1.0E-4f);
    }

    public static boolean belongToSection(PointF sectionPoint1, PointF sectionPoint2, PointF testPoint, float precision) {
        double d2;
        double d3 = Primitive2D.linelen(sectionPoint1, sectionPoint2);
        double d4 = Primitive2D.linelen(sectionPoint1, testPoint);
        return Math.abs(d4 + (d2 = (double)Primitive2D.linelen(sectionPoint2, testPoint)) - d3) < (double)precision;
    }

    public static PointF[] arrangePointsByLeft(PointF p1, PointF p2) {
        if (p1.getX() < p2.getX()) {
            return new PointF[]{p1, p2};
        }
        if (p1.getX() > p2.getX()) {
            return new PointF[]{p2, p1};
        }
        if (p1.getY() > p2.getY()) {
            return new PointF[]{p2, p1};
        }
        return new PointF[]{p1, p2};
    }

    public static PointF[] arrangePointsByTop(PointF p1, PointF p2) {
        if (p1.getY() < p2.getY()) {
            return new PointF[]{p1, p2};
        }
        if (p1.getY() > p2.getY()) {
            return new PointF[]{p2, p1};
        }
        if (p1.getX() < p2.getX()) {
            return new PointF[]{p2, p1};
        }
        return new PointF[]{p1, p2};
    }

    public static float linelen(float x1, float y1, float x2, float y2) {
        float f2 = x2 - x1;
        float f3 = y2 - y1;
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    public static float linelen(PointF p1, PointF p2) {
        return Primitive2D.linelen(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static float polyLineLength(float[] poly, int off, int nCoords) {
        assert (nCoords % 2 == 0 && poly.length >= off + nCoords) : "";
        float f2 = 0.0f;
        for (int i2 = off + 2; i2 < off + nCoords; i2 += 2) {
            f2 += Primitive2D.linelen(poly[i2], poly[i2 + 1], poly[i2 - 2], poly[i2 - 1]);
        }
        return f2;
    }

    public static float polyLineLength(PointF[] poly, int off, int cnt) {
        float[] fArray = new float[poly.length * 2];
        for (int i2 = 0; i2 < poly.length; ++i2) {
            fArray[i2 * 2] = poly[i2].getX();
            fArray[i2 * 2 + 1] = poly[i2].getY();
        }
        return Primitive2D.polyLineLength(fArray, off * 2, cnt * 2);
    }

    public static double lineAngle(PointF p1, PointF p2) {
        float f2 = p1.getX();
        float f3 = p1.getY();
        float f4 = p2.getX();
        float f5 = p2.getY();
        double d2 = f4 - f2;
        double d3 = f5 - f3;
        if (d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d2 == 0.0 && d3 != 0.0) {
            return f3 > f5 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d2 != 0.0 && d3 == 0.0) {
            return f2 > f4 ? Math.PI : 0.0;
        }
        double d4 = Math.atan(d3 / d2);
        if (d2 < 0.0 && d3 < 0.0) {
            d4 -= Math.PI;
        }
        if (d2 < 0.0 && d3 >= 0.0) {
            d4 += Math.PI;
        }
        return d4;
    }

    private static double a(PointF pointF, PointF pointF2) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(pointF, pointF2);
        float f2 = pointFArray[0].getX();
        float f3 = pointFArray[0].getY();
        float f4 = pointFArray[1].getX();
        float f5 = pointFArray[1].getY();
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        if ((double)f6 == 0.0 && (double)f7 == 0.0) {
            return 0.0;
        }
        if ((double)f6 == 0.0 && (double)f7 != 0.0) {
            return f3 > f5 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if ((double)f6 != 0.0 && (double)f7 == 0.0) {
            return 0.0;
        }
        return Math.atan(f7 / f6);
    }

    public static PointF[] formParallelogramByRandomPoints(PointF p1, PointF p2, PointF p3) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(p1, p2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(pointFArray[0], p3);
        PointF[] pointFArray3 = new PointF[]{pointFArray2[0], null, null, null};
        PointF[] pointFArray4 = Primitive2D.arrangePointsByTop(pointFArray[1], pointFArray2[1]);
        pointFArray3[1] = pointFArray4[0];
        pointFArray3[2] = pointFArray4[1];
        float f2 = pointFArray3[2].getX() - pointFArray3[1].getX();
        float f3 = pointFArray3[2].getY() - pointFArray3[1].getY();
        pointFArray3[3] = new PointF(pointFArray3[0].getX() + f2, pointFArray3[0].getY() + f3);
        return pointFArray3;
    }

    public static PointF[] formParallelogramByArrangedPoints(PointF p1, PointF p2, PointF p3) {
        PointF[] pointFArray = new PointF[]{p1, p2, p3, null};
        float f2 = pointFArray[2].getX() - pointFArray[1].getX();
        float f3 = pointFArray[2].getY() - pointFArray[1].getY();
        pointFArray[3] = new PointF(pointFArray[0].getX() + f2, pointFArray[0].getY() + f3);
        return pointFArray;
    }

    public static PointF[] formParallelogramByNetPoints(PointF p1, PointF p2, PointF p4) {
        PointF[] pointFArray = new PointF[]{p4, p1, p2, null};
        float f2 = pointFArray[2].getX() - pointFArray[1].getX();
        float f3 = pointFArray[2].getY() - pointFArray[1].getY();
        PointF pointF = new PointF(pointFArray[0].getX() + f2, pointFArray[0].getY() + f3);
        return new PointF[]{p1, p2, pointF, p4};
    }

    public static PointF[] formParallelogram(PointF p1, PointF p2, PointF p3, boolean arrangePoints) {
        return arrangePoints ? Primitive2D.formParallelogramByRandomPoints(p1, p2, p3) : Primitive2D.formParallelogramByArrangedPoints(p1, p2, p3);
    }

    public static PointF[] normalizeParallelogramGuess(PointF p1, PointF p2, PointF p3, PointF p4) {
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(p1, p2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(p3, p4);
        PointF[] pointFArray3 = Primitive2D.arrangePointsByLeft(pointFArray[0], pointFArray2[0]);
        PointF[] pointFArray4 = new PointF[]{pointFArray3[0], null, null, null};
        if (pointFArray[0] != pointFArray3[0]) {
            pointFArray = Primitive2D.arrangePointsByTop(pointFArray[0], pointFArray[1]);
            pointFArray2 = Primitive2D.arrangePointsByTop(pointFArray[0], pointFArray2[1]);
            pointFArray4[1] = pointFArray2[0];
            pointFArray = Primitive2D.arrangePointsByLeft(pointFArray[1], pointFArray2[1]);
            pointFArray4[2] = pointFArray[1];
            pointFArray4[3] = pointFArray[0];
        } else {
            pointFArray2 = Primitive2D.arrangePointsByTop(pointFArray2[0], pointFArray2[1]);
            pointFArray = Primitive2D.arrangePointsByTop(pointFArray2[0], pointFArray[1]);
            pointFArray4[1] = pointFArray[0];
            pointFArray = Primitive2D.arrangePointsByLeft(pointFArray[1], pointFArray2[1]);
            pointFArray4[2] = pointFArray[1];
            pointFArray4[3] = pointFArray[0];
        }
        return pointFArray4;
    }

    public static PointF[] normalizeParallelogram(PointF p1, PointF p2, PointF p3, PointF p4) {
        LinkedList<PointF> linkedList = new LinkedList<PointF>();
        linkedList.add(p1);
        linkedList.add(p2);
        linkedList.add(p3);
        linkedList.add(p4);
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        arrayList.add(p1);
        arrayList.add(p2);
        arrayList.add(p3);
        arrayList.add(p4);
        PointF[] pointFArray = Primitive2D.arrangePointsByLeft(p1, p2);
        PointF[] pointFArray2 = Primitive2D.arrangePointsByLeft(p3, p4);
        PointF[] pointFArray3 = Primitive2D.arrangePointsByLeft(pointFArray[0], pointFArray2[0]);
        PointF[] pointFArray4 = new PointF[]{pointFArray3[0], null, null, null};
        int n2 = linkedList.indexOf(pointFArray4[0]);
        pointFArray4[1] = Primitive2D.arrangePointsByTop((PointF)arrayList.get(n2 == 0 ? 3 : n2 - 1), (PointF)linkedList.get(n2 == 3 ? 0 : n2 + 1))[0];
        linkedList.remove(pointFArray4[0]);
        linkedList.remove(pointFArray4[1]);
        n2 = arrayList.indexOf(pointFArray4[1]);
        if (pointFArray4[0] != arrayList.get(n2 == 0 ? 3 : n2 - 1)) {
            pointFArray4[2] = (PointF)arrayList.get(n2 == 0 ? 3 : n2 - 1);
        } else if (pointFArray4[0] != arrayList.get(n2 == 3 ? 0 : n2 + 1)) {
            pointFArray4[2] = (PointF)arrayList.get(n2 == 3 ? 0 : n2 + 1);
        }
        linkedList.remove(pointFArray4[2]);
        pointFArray4[3] = (PointF)linkedList.get(0);
        return pointFArray4;
    }

    public static PointF calcIntersectPoint(PointF start1, PointF end1, PointF start2, PointF end2) {
        float f2 = start1.getX();
        float f3 = start1.getY();
        float f4 = end1.getX() - f2;
        float f5 = end1.getY() - f3;
        float f6 = start2.getX() - f2;
        float f7 = start2.getY() - f3;
        float f8 = end2.getX();
        float f9 = end2.getY();
        float f10 = f5;
        float f11 = f4;
        float f12 = f10 / f11;
        float f13 = (f9 -= f3) - f7;
        float f14 = (f8 -= f2) - f6;
        float f15 = f13 / f14;
        if (f12 == f15) {
            return null;
        }
        float f16 = f8;
        float f17 = f9;
        if (f14 == 0.0f && f11 != 0.0f) {
            f16 = f8;
            f17 = f12 * f8;
        } else if (f14 == 0.0f && f11 == 0.0f) {
            f16 = f6;
            f17 = f7;
        }
        float f18 = f9 - f15 * f8;
        if (f14 != 0.0f) {
            if (f12 != 0.0f) {
                f17 = f18 / (1.0f - f15 / f12);
                f16 = f17 / f12;
            } else if (f15 != 0.0f) {
                f17 = -1.0f * f18 * f12 / f15 / (1.0f - f12 / f15);
                f16 = (f17 - f18) / f15;
            }
        }
        return new PointF(f16 + f2, f17 + f3);
    }
}

