/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.m;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.q;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class MatrixUtil {
    public static float[] getOriginalScalingCoeff(Matrix t2) {
        float[] fArray = t2.getElements();
        float[] fArray2 = MatrixUtil.getOriginalScalingCoeffNew(new float[]{fArray[0], fArray[1], fArray[2], fArray[3]});
        if (fArray2.length == 2) {
            return fArray2;
        }
        return MatrixUtil.getOriginalScalingCoeffNew(new float[]{fArray[0], fArray[2], fArray[1], fArray[3]});
    }

    public static float[] getOriginalScalingCoeffNew(float[] m2) {
        if (m2[1] == 0.0f && m2[2] == 0.0f) {
            return new float[]{m2[0], m2[3]};
        }
        float f2 = (float)Math.sqrt(m2[2] * m2[2] + m2[3] * m2[3]);
        float f3 = (float)Math.sqrt(m2[0] * m2[0] + m2[1] * m2[1]);
        float f4 = Math.signum(m2[0]);
        float f5 = Math.signum(m2[3]);
        if (f4 != 0.0f && f5 != 0.0f && MatrixUtil.a(f3 * f4, f2 * f5, m2)) {
            return new float[]{f3 * f4, f2 * f5};
        }
        if (!MatrixUtil.a(f3, f2, m2)) {
            if (MatrixUtil.a(-f3, f2, m2)) {
                f3 = -f3;
            } else if (MatrixUtil.a(f3, -f2, m2)) {
                f2 = -f2;
            } else if (MatrixUtil.a(-f3, -f2, m2)) {
                f3 = -f3;
                f2 = -f2;
            } else {
                f3 = m2[0];
                f2 = m2[3];
                return new float[]{f3, f2, 0.0f};
            }
        }
        return new float[]{f3, f2};
    }

    private static boolean a(float f2, float f3, float[] fArray) {
        float f4 = (fArray[3] == 0.0f ? 0.0f : fArray[3]) / f3;
        float f5 = (fArray[2] == 0.0f ? 0.0f : fArray[2]) / f3;
        float f6 = (fArray[0] == 0.0f ? 0.0f : fArray[0]) / f2;
        float f7 = (fArray[1] == 0.0f ? 0.0f : fArray[1]) / f2;
        float f8 = 1.0E-4f;
        if (!MatrixUtil.a(f4, f6, f8)) {
            return false;
        }
        return MatrixUtil.a(f5, -f7, f8) && Math.signum(f5) - Math.signum(f7) != 0.0f;
    }

    private static boolean a(float f2, float f3, float f4) {
        return f2 >= f3 - f4 && f2 <= f3 + f4;
    }

    public static Matrix getSvdS(Matrix m2) {
        m m3 = new m(MatrixUtil.toJmMatrix(m2));
        return MatrixUtil.fromJmMatrix(m3.d());
    }

    public static float getSvdZ(Matrix m2) {
        float[] fArray = m2.getElements();
        m m3 = new m(MatrixUtil.toJmMatrix(new Matrix(fArray[0], fArray[1], fArray[2], fArray[3], 0.0f, 0.0f)));
        return (float)m3.c()[2];
    }

    public static Matrix fromJmMatrix(q m2) {
        double[][] dArray = m2.b();
        return new Matrix((float)dArray[0][0], (float)dArray[0][1], (float)dArray[1][0], (float)dArray[1][1], (float)dArray[2][0], (float)dArray[2][1]);
    }

    public static q toJmMatrix(Matrix m2) {
        float[] fArray = m2.getElements();
        return new q(new double[][]{{fArray[0], fArray[1], 0.0}, {fArray[2], fArray[3], 0.0}, {fArray[4], fArray[5], 1.0}});
    }

    public static boolean nearZero(double value) {
        return value >= (double)-1.0E-4f && value <= (double)1.0E-4f;
    }

    public static boolean nearOne(double value) {
        return value >= (double)0.9999f && value <= (double)1.0001f;
    }

    public static boolean isMatrixEmpty(Matrix matrix) {
        if (matrix == null) {
            return true;
        }
        float[] fArray = matrix.getElements();
        return MatrixUtil.nearOne(fArray[0]) && MatrixUtil.nearZero(fArray[1]) && MatrixUtil.nearZero(fArray[2]) && MatrixUtil.nearOne(fArray[3]) && MatrixUtil.nearZero(fArray[4]) && MatrixUtil.nearZero(fArray[5]);
    }

    public static void transformPoints(AffineTransform t2, Point2D[] pts) {
        if (pts == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pts.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Double double_ = new Point2D.Double();
        for (Point2D point2D : pts) {
            double_.setLocation(point2D.getX(), point2D.getY());
            t2.transform(double_, double_);
            point2D.setLocation(double_.getX(), double_.getY());
        }
    }
}

