/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Activator;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.IO.TextWriter;
import com.aspose.html.internal.ms.System.Security.Policy.Evidence;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.System.Xml.CompiledStylesheet;
import com.aspose.html.internal.ms.System.Xml.Compiler;
import com.aspose.html.internal.ms.System.Xml.GenericOutputter;
import com.aspose.html.internal.ms.System.Xml.IXPathNavigable;
import com.aspose.html.internal.ms.System.Xml.Outputter;
import com.aspose.html.internal.ms.System.Xml.SimpleXsltDebugger;
import com.aspose.html.internal.ms.System.Xml.TodoAttribute;
import com.aspose.html.internal.ms.System.Xml.XPathDocument;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XmlReader;
import com.aspose.html.internal.ms.System.Xml.XmlResolver;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlTextWriter;
import com.aspose.html.internal.ms.System.Xml.XmlUrlResolver;
import com.aspose.html.internal.ms.System.Xml.XmlValidatingReader;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;
import com.aspose.html.internal.ms.System.Xml.XslOutput;
import com.aspose.html.internal.ms.System.Xml.XslTransformProcessor;
import com.aspose.html.internal.ms.System.Xml.XsltArgumentList;
import com.aspose.html.internal.ms.System.Xml.XsltException;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class XslTransform {
    static boolean TemplateStackFrameError;
    private Object a;
    private CompiledStylesheet b;
    private XmlResolver c = new XmlUrlResolver();
    private static final StringSwitchMap d;

    static Object getDefaultDebugger() {
        String string = Environment.getEnvironmentVariable("MONO_XSLT_DEBUGGER");
        if (string == null) {
            return null;
        }
        if ("simple".equals(string)) {
            return new SimpleXsltDebugger();
        }
        Object object = Activator.createInstance(Type.getType(string), new Object[0]);
        return object;
    }

    public XslTransform() {
        this(XslTransform.getDefaultDebugger());
    }

    XslTransform(Object debugger) {
        this.a = debugger;
    }

    @TodoAttribute
    public void setXmlResolver(XmlResolver value) {
        this.c = value;
    }

    public XmlReader transform(IXPathNavigable input, XsltArgumentList args) {
        return this.transform(input.createNavigator(), args, this.c);
    }

    public XmlReader transform(IXPathNavigable input, XsltArgumentList args, XmlResolver resolver) {
        return this.transform(input.createNavigator(), args, resolver);
    }

    public XmlReader transform(XPathNavigator input, XsltArgumentList args) {
        return this.transform(input, args, this.c);
    }

    public XmlReader transform(XPathNavigator input, XsltArgumentList args, XmlResolver resolver) {
        MemoryStream memoryStream = new MemoryStream();
        this.transform(input, args, (XmlWriter)new XmlTextWriter(memoryStream, null), resolver);
        memoryStream.setPosition(0L);
        return new XmlTextReader(memoryStream, 1, null);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, TextWriter output) {
        this.transform(input.createNavigator(), args, output, this.c);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, TextWriter output, XmlResolver resolver) {
        this.transform(input.createNavigator(), args, output, resolver);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, Stream output) {
        this.transform(input.createNavigator(), args, output, this.c);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, Stream output, XmlResolver resolver) {
        this.transform(input.createNavigator(), args, output, resolver);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, XmlWriter output) {
        this.transform(input.createNavigator(), args, output, this.c);
    }

    public void transform(IXPathNavigable input, XsltArgumentList args, XmlWriter output, XmlResolver resolver) {
        this.transform(input.createNavigator(), args, output, resolver);
    }

    public void transform(XPathNavigator input, XsltArgumentList args, XmlWriter output) {
        this.transform(input, args, output, this.c);
    }

    public void transform(XPathNavigator input, XsltArgumentList args, XmlWriter output, XmlResolver resolver) {
        if (this.b == null) {
            throw new XsltException("No stylesheet was loaded.", null);
        }
        GenericOutputter genericOutputter = new GenericOutputter(output, this.b.getOutputs(), null);
        new XslTransformProcessor(this.b, this.a).process(input, genericOutputter, args, resolver);
        output.flush();
    }

    public void transform(XPathNavigator input, XsltArgumentList args, Stream output) {
        this.transform(input, args, output, this.c);
    }

    public void transform(XPathNavigator input, XsltArgumentList args, Stream output, XmlResolver resolver) {
        XslOutput xslOutput = (XslOutput)this.b.getOutputs().get_Item(StringExtensions.Empty);
        this.transform(input, args, (TextWriter)new StreamWriter(output, xslOutput.getEncoding()), resolver);
    }

    public void transform(XPathNavigator input, XsltArgumentList args, TextWriter output) {
        this.transform(input, args, output, this.c);
    }

    public void transform(XPathNavigator input, XsltArgumentList args, TextWriter output, XmlResolver resolver) {
        if (this.b == null) {
            throw new XsltException("No stylesheet was loaded.", null);
        }
        GenericOutputter genericOutputter = new GenericOutputter(output, this.b.getOutputs(), output.getEncoding());
        new XslTransformProcessor(this.b, this.a).process(input, genericOutputter, args, resolver);
        ((Outputter)genericOutputter).done();
        output.flush();
    }

    public void transform(String inputfile, String outputfile) {
        this.transform(inputfile, outputfile, this.c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inputfile, String outputfile, XmlResolver resolver) {
        FileStream fileStream = new FileStream(outputfile, 2, 3);
        try {
            this.transform(new XPathDocument(inputfile).createNavigator(), null, (Stream)fileStream, resolver);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public void load(String url) {
        this.load(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String url, XmlResolver resolver) {
        Uri uri;
        Object object;
        XmlResolver xmlResolver = resolver;
        if (xmlResolver == null) {
            xmlResolver = new XmlUrlResolver();
        }
        Stream stream = (object = xmlResolver.getEntity(uri = xmlResolver.resolveUri(null, url), null, Operators.typeOf(Stream.class))) instanceof Stream ? (Stream)object : null;
        try {
            XmlTextReader xmlTextReader = new XmlTextReader(uri.toString(), stream);
            xmlTextReader.setXmlResolver(xmlResolver);
            XmlValidatingReader xmlValidatingReader = new XmlValidatingReader(xmlTextReader);
            xmlValidatingReader.setXmlResolver(xmlResolver);
            xmlValidatingReader.setValidationType(0);
            this.load(new XPathDocument(xmlValidatingReader, 2).createNavigator(), resolver, null);
        }
        finally {
            if (stream != null) {
                stream.dispose();
            }
        }
    }

    public void load(XmlReader stylesheet) {
        this.load(stylesheet, null, null);
    }

    public void load(XmlReader stylesheet, XmlResolver resolver) {
        this.load(stylesheet, resolver, null);
    }

    public void load(XPathNavigator stylesheet) {
        this.load(stylesheet, null, null);
    }

    public void load(XPathNavigator stylesheet, XmlResolver resolver) {
        this.load(stylesheet, resolver, null);
    }

    public void load(IXPathNavigable stylesheet) {
        this.load(stylesheet.createNavigator(), null);
    }

    public void load(IXPathNavigable stylesheet, XmlResolver resolver) {
        this.load(stylesheet.createNavigator(), resolver);
    }

    public void load(IXPathNavigable stylesheet, XmlResolver resolver, Evidence evidence) {
        this.load(stylesheet.createNavigator(), resolver, evidence);
    }

    public void load(XPathNavigator stylesheet, XmlResolver resolver, Evidence evidence) {
        this.b = new Compiler(this.a).compile(stylesheet, resolver, evidence);
    }

    public void load(XmlReader stylesheet, XmlResolver resolver, Evidence evidence) {
        this.load(new XPathDocument(stylesheet, 2).createNavigator(), resolver, evidence);
    }

    static {
        d = new StringSwitchMap("stdout", "stderr", "error");
    }
}

