/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.IStaticXsltContext;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;

class XslNameUtil {
    XslNameUtil() {
    }

    public static XmlQualifiedName[] fromListString(String names, XPathNavigator current) {
        String[] stringArray = StringExtensions.split(names, XmlChar.WhitespaceChars);
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (StringExtensions.equals(stringArray[i2], StringExtensions.Empty)) continue;
            ++n2;
        }
        XmlQualifiedName[] xmlQualifiedNameArray = new XmlQualifiedName[n2];
        n2 = 0;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (StringExtensions.equals(stringArray[i3], StringExtensions.Empty)) continue;
            xmlQualifiedNameArray[n2++] = XslNameUtil.fromString(stringArray[i3], current, true);
        }
        return xmlQualifiedNameArray;
    }

    public static XmlQualifiedName fromString(String name, XPathNavigator current) {
        return XslNameUtil.fromString(name, current, false);
    }

    public static XmlQualifiedName fromString(String name, XPathNavigator current, boolean useDefaultXmlns) {
        int n2;
        if (current.getNodeType() == 2) {
            current = current.deepClone();
            current.moveToParent();
        }
        if ((n2 = StringExtensions.indexOf(name, ':')) > 0) {
            return new XmlQualifiedName(StringExtensions.substring(name, n2 + 1), current.getNamespace(StringExtensions.substring(name, 0, n2)));
        }
        if (n2 < 0) {
            return new XmlQualifiedName(name, useDefaultXmlns ? current.getNamespace(StringExtensions.Empty) : "");
        }
        throw new ArgumentException(StringExtensions.concat("Invalid name: ", name));
    }

    public static XmlQualifiedName fromString(String name, Hashtable nsDecls) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 > 0) {
            Object object = nsDecls.get_Item(StringExtensions.substring(name, 0, n2));
            return new XmlQualifiedName(StringExtensions.substring(name, n2 + 1), object instanceof String ? (String)object : null);
        }
        if (n2 < 0) {
            return new XmlQualifiedName(name, nsDecls.containsKey(StringExtensions.Empty) ? (String)nsDecls.get_Item(StringExtensions.Empty) : StringExtensions.Empty);
        }
        throw new ArgumentException(StringExtensions.concat("Invalid name: ", name));
    }

    public static XmlQualifiedName fromString(String name, IStaticXsltContext ctx) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 > 0) {
            return new XmlQualifiedName(StringExtensions.substring(name, n2 + 1), ctx.lookupNamespace(StringExtensions.substring(name, 0, n2)));
        }
        if (n2 < 0) {
            return new XmlQualifiedName(name, "");
        }
        throw new ArgumentException(StringExtensions.concat("Invalid name: ", name));
    }

    public static XmlQualifiedName fromString(String name, XmlNamespaceManager ctx) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 > 0) {
            return new XmlQualifiedName(StringExtensions.substring(name, n2 + 1), ctx.lookupNamespace(StringExtensions.substring(name, 0, n2), false));
        }
        if (n2 < 0) {
            return new XmlQualifiedName(name, "");
        }
        throw new ArgumentException(StringExtensions.concat("Invalid name: ", name));
    }

    public static String localNameOf(String name) {
        int n2 = StringExtensions.indexOf(name, ':');
        if (n2 > 0) {
            return StringExtensions.substring(name, n2 + 1);
        }
        if (n2 < 0) {
            return name;
        }
        throw new ArgumentException(StringExtensions.concat("Invalid name: ", name));
    }
}

