/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.Specialized.StringCollection;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAny;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

class XsdWildcard {
    private XmlSchemaObject a;
    public int ResolvedProcessing;
    public String TargetNamespace;
    public boolean SkipCompile;
    public boolean HasValueAny;
    public boolean HasValueLocal;
    public boolean HasValueOther;
    public boolean HasValueTargetNamespace;
    public StringCollection ResolvedNamespaces;
    private static final StringSwitchMap b = new StringSwitchMap("##any", "##other", "##targetNamespace", "##local");

    public XsdWildcard(XmlSchemaObject wildcard) {
        this.a = wildcard;
    }

    private void a() {
        this.HasValueAny = false;
        this.HasValueLocal = false;
        this.HasValueOther = false;
        this.HasValueTargetNamespace = false;
        this.ResolvedNamespaces = new StringCollection();
    }

    public void compile(String nss, ValidationEventHandler h2, XmlSchema schema) {
        if (this.SkipCompile) {
            return;
        }
        this.a();
        int n2 = 0;
        String string = nss == null ? "##any" : nss;
        String[] stringArray = XmlSchemaUtil.splitList(string);
        block6: for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            switch (b.of(string2)) {
                case 0: {
                    if (this.HasValueAny) {
                        this.a.error(h2, "Multiple specification of ##any was found.");
                    }
                    n2 |= 1;
                    this.HasValueAny = true;
                    continue block6;
                }
                case 1: {
                    if (this.HasValueOther) {
                        this.a.error(h2, "Multiple specification of ##other was found.");
                    }
                    n2 |= 2;
                    this.HasValueOther = true;
                    continue block6;
                }
                case 2: {
                    if (this.HasValueTargetNamespace) {
                        this.a.error(h2, "Multiple specification of ##targetNamespace was found.");
                    }
                    n2 |= 4;
                    this.HasValueTargetNamespace = true;
                    continue block6;
                }
                case 3: {
                    if (this.HasValueLocal) {
                        this.a.error(h2, "Multiple specification of ##local was found.");
                    }
                    n2 |= 8;
                    this.HasValueLocal = true;
                    continue block6;
                }
                default: {
                    if (!XmlSchemaUtil.checkAnyUri(string2)) {
                        this.a.error(h2, "the namespace is not a valid anyURI");
                        continue block6;
                    }
                    if (this.ResolvedNamespaces.contains(string2)) {
                        this.a.error(h2, StringExtensions.concat("Multiple specification of '", string2, "' was found."));
                        continue block6;
                    }
                    n2 |= 0x10;
                    this.ResolvedNamespaces.addItem(string2);
                }
            }
        }
        if (n2 & true && n2 != 1) {
            this.a.error(h2, "##any if present must be the only namespace attribute");
        }
        if ((n2 & 2) == 2 && n2 != 2) {
            this.a.error(h2, "##other if present must be the only namespace attribute");
        }
    }

    public boolean examineAttributeWildcardIntersection(XmlSchemaAny other, ValidationEventHandler h2, XmlSchema schema) {
        int n2;
        if (this.HasValueAny == other.hasValueAny() && this.HasValueLocal == other.hasValueLocal() && this.HasValueOther == other.hasValueOther() && this.HasValueTargetNamespace == other.hasValueTargetNamespace() && this.ResolvedProcessing == other.getResolvedProcessContents()) {
            n2 = 0;
            for (int i2 = 0; i2 < this.ResolvedNamespaces.size(); ++i2) {
                if (other.getResolvedNamespaces().contains(this.ResolvedNamespaces.get_Item(i2))) continue;
                n2 = 1;
            }
            if (n2 == 0) {
                return false;
            }
        }
        if (this.HasValueAny) {
            return !other.hasValueAny() && !other.hasValueLocal() && !other.hasValueOther() && !other.hasValueTargetNamespace() && other.getResolvedNamespaces().size() == 0;
        }
        if (other.hasValueAny()) {
            return !this.HasValueAny && !this.HasValueLocal && !this.HasValueOther && !this.HasValueTargetNamespace && this.ResolvedNamespaces.size() == 0;
        }
        if (this.HasValueOther && other.hasValueOther() && !StringExtensions.equals(this.TargetNamespace, other.getTargetNamespace())) {
            return false;
        }
        if (this.HasValueOther) {
            if (other.hasValueLocal() && !StringExtensions.equals(this.TargetNamespace, StringExtensions.Empty)) {
                return false;
            }
            if (other.hasValueTargetNamespace() && !StringExtensions.equals(this.TargetNamespace, other.getTargetNamespace())) {
                return false;
            }
            return other.validateWildcardAllowsNamespaceName(this.TargetNamespace, h2, schema, false);
        }
        if (other.hasValueOther()) {
            if (this.HasValueLocal && !StringExtensions.equals(other.getTargetNamespace(), StringExtensions.Empty)) {
                return false;
            }
            if (this.HasValueTargetNamespace && !StringExtensions.equals(other.getTargetNamespace(), this.TargetNamespace)) {
                return false;
            }
            return this.validateWildcardAllowsNamespaceName(other.getTargetNamespace(), h2, schema, false);
        }
        if (this.ResolvedNamespaces.size() > 0) {
            for (n2 = 0; n2 < this.ResolvedNamespaces.size(); ++n2) {
                if (!other.getResolvedNamespaces().contains(this.ResolvedNamespaces.get_Item(n2))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateWildcardAllowsNamespaceName(String ns, ValidationEventHandler h2, XmlSchema schema, boolean raiseError) {
        if (this.HasValueAny) {
            return true;
        }
        if (this.HasValueOther && !StringExtensions.equals(ns, this.TargetNamespace)) {
            return true;
        }
        if (this.HasValueTargetNamespace && StringExtensions.equals(ns, this.TargetNamespace)) {
            return true;
        }
        if (this.HasValueLocal && "".equals(ns)) {
            return true;
        }
        for (int i2 = 0; i2 < this.ResolvedNamespaces.size(); ++i2) {
            if (!StringExtensions.equals(ns, this.ResolvedNamespaces.get_Item(i2))) continue;
            return true;
        }
        if (raiseError) {
            this.a.error(h2, StringExtensions.concat("This wildcard does not allow the namespace: ", ns));
        }
        return false;
    }

    void validateWildcardSubset(XsdWildcard other, ValidationEventHandler h2, XmlSchema schema) {
        this.validateWildcardSubset(other, h2, schema, true);
    }

    boolean validateWildcardSubset(XsdWildcard other, ValidationEventHandler h2, XmlSchema schema, boolean raiseError) {
        if (other.HasValueAny) {
            return true;
        }
        if (this.HasValueOther && other.HasValueOther && (StringExtensions.equals(this.TargetNamespace, other.TargetNamespace) || other.TargetNamespace == null || "".equals(other.TargetNamespace))) {
            return true;
        }
        if (this.HasValueAny) {
            if (raiseError) {
                this.a.error(h2, "Invalid wildcard subset was found.");
            }
            return false;
        }
        if (other.HasValueOther) {
            if (this.HasValueTargetNamespace && StringExtensions.equals(other.TargetNamespace, this.TargetNamespace) || this.HasValueLocal && (other.TargetNamespace == null || other.TargetNamespace.length() == 0)) {
                if (raiseError) {
                    this.a.error(h2, "Invalid wildcard subset was found.");
                }
                return false;
            }
            for (int i2 = 0; i2 < this.ResolvedNamespaces.size(); ++i2) {
                if (!StringExtensions.equals(this.ResolvedNamespaces.get_Item(i2), other.TargetNamespace)) continue;
                if (raiseError) {
                    this.a.error(h2, "Invalid wildcard subset was found.");
                }
                return false;
            }
        } else {
            if (this.HasValueLocal && !other.HasValueLocal || this.HasValueTargetNamespace && !other.HasValueTargetNamespace) {
                if (raiseError) {
                    this.a.error(h2, "Invalid wildcard subset was found.");
                }
                return false;
            }
            if (this.HasValueOther) {
                if (raiseError) {
                    this.a.error(h2, "Invalid wildcard subset was found.");
                }
                return false;
            }
            for (int i3 = 0; i3 < this.ResolvedNamespaces.size(); ++i3) {
                if (other.ResolvedNamespaces.contains(this.ResolvedNamespaces.get_Item(i3))) continue;
                if (raiseError) {
                    this.a.error(h2, "Invalid wildcard subset was found.");
                }
                return false;
            }
        }
        return true;
    }
}

