/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Activator;
import com.aspose.html.internal.ms.System.Attribute;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Reflection.MethodInfo;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.IXmlSerializable;
import com.aspose.html.internal.ms.System.Xml.TypeData;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlRootAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaProviderAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSet;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaType;
import com.aspose.html.internal.ms.System.Xml.XmlTypeMapping;
import com.aspose.html.internal.ms.lang.Operators;

class XmlSerializableMapping
extends XmlTypeMapping {
    private XmlSchema a;
    private XmlSchemaComplexType b;
    private XmlQualifiedName c;

    XmlSerializableMapping(XmlRootAttribute root, String elementName, String ns, TypeData typeData, String xmlType, String xmlTypeNamespace) {
        super(elementName, ns, typeData, xmlType, xmlTypeNamespace);
        XmlSchemaProviderAttribute xmlSchemaProviderAttribute = (XmlSchemaProviderAttribute)Attribute.getCustomAttribute(typeData.getType(), Operators.typeOf(XmlSchemaProviderAttribute.class));
        if (xmlSchemaProviderAttribute != null) {
            String string = xmlSchemaProviderAttribute.methodName();
            MethodInfo methodInfo = typeData.getType().getMethod(string, 88);
            if (methodInfo == null) {
                throw new InvalidOperationException(StringExtensions.format("Type '{0}' must implement public static method '{1}'", typeData.getType(), string));
            }
            if (!Operators.typeOf(XmlQualifiedName.class).isAssignableFrom(methodInfo.getReturnType()) && !Operators.typeOf(XmlSchemaComplexType.class).isAssignableFrom(methodInfo.getReturnType())) {
                throw new InvalidOperationException(StringExtensions.format("Method '{0}' indicated by XmlSchemaProviderAttribute must have its return type as XmlQualifiedName", string));
            }
            XmlSchemaSet xmlSchemaSet = new XmlSchemaSet();
            Object object = methodInfo.invoke(null, new Object[]{xmlSchemaSet});
            this.c = XmlQualifiedName.Empty;
            if (object == null) {
                return;
            }
            if (object instanceof XmlSchemaComplexType) {
                this.b = (XmlSchemaComplexType)object;
                this.c = !this.b.getQualifiedName().isEmpty() ? this.b.getQualifiedName() : new XmlQualifiedName(xmlType, xmlTypeNamespace);
            } else if (object instanceof XmlQualifiedName) {
                this.c = (XmlQualifiedName)object;
            } else {
                throw new InvalidOperationException(StringExtensions.format("Method {0}.{1}() specified by XmlSchemaProviderAttribute has invalid signature: return type must be compatible with System.Xml.XmlQualifiedName.", typeData.getType().getName(), string));
            }
            this.updateRoot(new XmlQualifiedName(root != null ? root.elementName() : this.c.getName(), root != null ? root.namespace() : (this.getNamespace() != null ? this.getNamespace() : this.c.getNamespace())));
            this.setXmlTypeNamespace(this.c.getNamespace());
            this.setXmlType(this.c.getName());
            if (!this.c.isEmpty() && xmlSchemaSet.getCount() > 0) {
                XmlSchema[] xmlSchemaArray = new XmlSchema[xmlSchemaSet.getCount()];
                xmlSchemaSet.copyTo(xmlSchemaArray, 0);
                this.a = xmlSchemaArray[0];
            }
            return;
        }
        IXmlSerializable iXmlSerializable = (IXmlSerializable)Activator.createInstance(typeData.getType(), true);
        try {
            this.a = iXmlSerializable.getSchema();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.a != null && (this.a.getId() == null || this.a.getId().length() == 0)) {
            throw new InvalidOperationException(StringExtensions.concat("Schema Id is missing. The schema returned from ", typeData.getType().getFullName(), ".GetSchema() must have an Id."));
        }
    }

    XmlSchema getSchema() {
        return this.a;
    }

    XmlSchemaType getSchemaType() {
        return this.b;
    }

    XmlQualifiedName getSchemaTypeName() {
        return this.c;
    }
}

