/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.DTDAttListDeclaration;
import com.aspose.html.internal.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.internal.ms.System.Xml.DefaultXmlWriter;
import com.aspose.html.internal.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.XmlAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlAttributeCollection;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlConvert;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.internal.ms.System.Xml.XmlNameEntry;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlNode;
import com.aspose.html.internal.ms.System.Xml.XmlNodeArrayList;
import com.aspose.html.internal.ms.System.Xml.XmlNodeList;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;

public class XmlElement
extends XmlLinkedNode
implements IHasXmlChildNode {
    private XmlAttributeCollection a;
    private XmlNameEntry b;
    private XmlLinkedNode c;
    private boolean d;
    private IXmlSchemaInfo e;

    protected XmlElement(String prefix, String localName, String namespaceURI, XmlDocument doc) {
        this(prefix, localName, namespaceURI, doc, false);
    }

    XmlElement(String prefix, String localName, String namespaceURI, XmlDocument doc, boolean atomizedNames) {
        super(doc);
        DTDAttListDeclaration dTDAttListDeclaration;
        if (!atomizedNames) {
            if (prefix == null) {
                prefix = StringExtensions.Empty;
            }
            if (namespaceURI == null) {
                namespaceURI = StringExtensions.Empty;
            }
            XmlConvert.verifyName(localName);
            prefix = doc.getNameTable().add(prefix);
            localName = doc.getNameTable().add(localName);
            namespaceURI = doc.getNameTable().add(namespaceURI);
        }
        this.b = doc.getNameCache().add(prefix, localName, namespaceURI, true);
        if (doc.getDocumentType() != null && (dTDAttListDeclaration = doc.getDocumentType().getDTD().getAttListDecls().get_Item(localName)) != null) {
            for (int i2 = 0; i2 < dTDAttListDeclaration.getDefinitions().size(); ++i2) {
                DTDAttributeDefinition dTDAttributeDefinition = dTDAttListDeclaration.get_Item(i2);
                if (dTDAttributeDefinition.getDefaultValue() == null) continue;
                this.setAttribute(dTDAttributeDefinition.getName(), dTDAttributeDefinition.getDefaultValue());
                this.getAttributes().get_ItemOf(dTDAttributeDefinition.getName()).setDefault();
            }
        }
    }

    @Override
    public XmlLinkedNode getLastLinkedChild() {
        return this.c;
    }

    @Override
    public void setLastLinkedChild(XmlLinkedNode value) {
        this.c = value;
    }

    @Override
    public XmlAttributeCollection getAttributes() {
        if (this.a == null) {
            this.a = new XmlAttributeCollection(this);
        }
        return this.a;
    }

    public boolean hasAttributes() {
        return this.a != null && this.a.size() > 0;
    }

    @Override
    public String getInnerText() {
        return super.getInnerText();
    }

    @Override
    public void setInnerText(String value) {
        if (this.getFirstChild() != null && this.getFirstChild().getNextSibling() == null && this.getFirstChild().getNodeType() == 3) {
            this.getFirstChild().setValue(value);
        } else {
            while (this.getFirstChild() != null) {
                this.removeChild(this.getFirstChild());
            }
            this.appendChild(this.getOwnerDocument().createTextNode(value), false);
        }
    }

    @Override
    public String getInnerXml() {
        return super.getInnerXml();
    }

    @Override
    public void setInnerXml(String value) {
        XmlNode xmlNode;
        while (this.getFirstChild() != null) {
            this.removeChild(this.getFirstChild());
        }
        XmlNamespaceManager xmlNamespaceManager = this.constructNamespaceManager();
        XmlParserContext xmlParserContext = new XmlParserContext(this.getOwnerDocument().getNameTable(), xmlNamespaceManager, this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD() : null, this.getBaseURI(), this.getXmlLang(), this.getXmlSpace(), null);
        XmlTextReader xmlTextReader = new XmlTextReader(value, 1, xmlParserContext);
        xmlTextReader.setXmlResolver(this.getOwnerDocument().getResolver());
        while ((xmlNode = this.getOwnerDocument().readNode(xmlTextReader)) != null) {
            this.appendChild(xmlNode);
        }
    }

    public boolean isEmpty() {
        return !this.d && this.getFirstChild() == null;
    }

    public void isEmpty(boolean value) {
        boolean bl2 = this.d = !value;
        if (value) {
            while (this.getFirstChild() != null) {
                this.removeChild(this.getFirstChild());
            }
        }
    }

    @Override
    public String getLocalName() {
        return this.b.LocalName;
    }

    @Override
    public String getName() {
        return this.b.getPrefixedName(this.getOwnerDocument().getNameCache());
    }

    @Override
    public String getNamespaceURI() {
        return this.b.NS;
    }

    @Override
    public XmlNode getNextSibling() {
        return this.getParentNode() == null || ((IHasXmlChildNode)((Object)this.getParentNode())).getLastLinkedChild() == this ? null : this.getNextLinkedSibling();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    int getXPathNodeType() {
        return 1;
    }

    @Override
    public XmlDocument getOwnerDocument() {
        return super.getOwnerDocument();
    }

    @Override
    public String getPrefix() {
        return this.b.Prefix;
    }

    @Override
    public void setPrefix(String value) {
        if (this.isReadOnly()) {
            throw new ArgumentException("This node is readonly.");
        }
        if (value == null) {
            value = StringExtensions.Empty;
        }
        if (!StringExtensions.equals(StringExtensions.Empty, value) && !XmlChar.isNCName(value)) {
            throw new ArgumentException(StringExtensions.concat("Specified name is not a valid NCName: ", value));
        }
        value = this.getOwnerDocument().getNameTable().add(value);
        this.b = this.getOwnerDocument().getNameCache().add(value, this.b.LocalName, this.b.NS, true);
    }

    @Override
    public XmlNode getParentNode() {
        return super.getParentNode();
    }

    @Override
    public IXmlSchemaInfo getSchemaInfo() {
        return this.e;
    }

    @Override
    void setSchemaInfo(IXmlSchemaInfo value) {
        this.e = value;
    }

    @Override
    public XmlNode cloneNode(boolean deep) {
        int n2;
        XmlElement xmlElement = this.getOwnerDocument().createElement(this.b.Prefix, this.b.LocalName, this.b.NS, true);
        for (n2 = 0; n2 < this.getAttributes().size(); ++n2) {
            xmlElement.setAttributeNode((XmlAttribute)this.getAttributes().get_ItemOf(n2).cloneNode(true));
        }
        if (deep) {
            for (n2 = 0; n2 < this.getChildNodes().getCount(); ++n2) {
                xmlElement.appendChild(this.getChildNodes().get_ItemOf(n2).cloneNode(true), false);
            }
        }
        return xmlElement;
    }

    public String getAttribute(String name) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(name);
        return xmlNode != null ? xmlNode.getValue() : StringExtensions.Empty;
    }

    public String getAttribute(String localName, String namespaceURI) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(localName, namespaceURI);
        return xmlNode != null ? xmlNode.getValue() : StringExtensions.Empty;
    }

    public XmlAttribute getAttributeNode(String name) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(name);
        return xmlNode != null && xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
    }

    public XmlAttribute getAttributeNode(String localName, String namespaceURI) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(localName, namespaceURI);
        return xmlNode != null && xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
    }

    public XmlNodeList getElementsByTagName(String name) {
        ArrayList arrayList = new ArrayList();
        this.searchDescendantElements(name, "*".equals(name), arrayList);
        return new XmlNodeArrayList(arrayList);
    }

    public XmlNodeList getElementsByTagName(String localName, String namespaceURI) {
        ArrayList arrayList = new ArrayList();
        this.searchDescendantElements(localName, "*".equals(localName), namespaceURI, "*".equals(namespaceURI), arrayList);
        return new XmlNodeArrayList(arrayList);
    }

    public boolean hasAttribute(String name) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(name);
        return xmlNode != null;
    }

    public boolean hasAttribute(String localName, String namespaceURI) {
        XmlNode xmlNode = this.getAttributes().getNamedItem(localName, namespaceURI);
        return xmlNode != null;
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    public void removeAllAttributes() {
        if (this.a != null) {
            this.a.removeAll();
        }
    }

    public void removeAttribute(String name) {
        XmlAttribute xmlAttribute;
        if (this.a == null) {
            return;
        }
        XmlNode xmlNode = this.getAttributes().getNamedItem(name);
        XmlAttribute xmlAttribute2 = xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        if (xmlAttribute != null) {
            this.getAttributes().remove(xmlAttribute);
        }
    }

    public void removeAttribute(String localName, String namespaceURI) {
        XmlAttribute xmlAttribute;
        if (this.a == null) {
            return;
        }
        XmlNode xmlNode = this.a.getNamedItem(localName, namespaceURI);
        XmlAttribute xmlAttribute2 = xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        if (xmlAttribute != null) {
            this.getAttributes().remove(xmlAttribute);
        }
    }

    public XmlNode removeAttributeAt(int i2) {
        if (this.a == null || this.a.size() <= i2) {
            return null;
        }
        return this.getAttributes().removeAt(i2);
    }

    public XmlAttribute removeAttributeNode(XmlAttribute oldAttr) {
        if (this.a == null) {
            return null;
        }
        return this.getAttributes().remove(oldAttr);
    }

    public XmlAttribute removeAttributeNode(String localName, String namespaceURI) {
        if (this.a == null) {
            return null;
        }
        return this.getAttributes().remove(this.a.get_ItemOf(localName, namespaceURI));
    }

    public void setAttribute(String name, String value) {
        XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(name);
        if (xmlAttribute == null) {
            xmlAttribute = this.getOwnerDocument().createAttribute(name);
            xmlAttribute.setValue(value);
            this.getAttributes().setNamedItem(xmlAttribute);
        } else {
            xmlAttribute.setValue(value);
        }
    }

    public String setAttribute(String localName, String namespaceURI, String value) {
        XmlAttribute xmlAttribute = this.getAttributes().get_ItemOf(localName, namespaceURI);
        if (xmlAttribute == null) {
            xmlAttribute = this.getOwnerDocument().createAttribute(localName, namespaceURI);
            xmlAttribute.setValue(value);
            this.getAttributes().setNamedItem(xmlAttribute);
        } else {
            xmlAttribute.setValue(value);
        }
        return xmlAttribute.getValue();
    }

    public XmlAttribute setAttributeNode(XmlAttribute newAttr) {
        if (newAttr.getOwnerElement() != null) {
            throw new InvalidOperationException("Specified attribute is already an attribute of another element.");
        }
        XmlNode xmlNode = this.getAttributes().setNamedItem(newAttr);
        XmlAttribute xmlAttribute = xmlNode instanceof XmlAttribute ? (XmlAttribute)xmlNode : null;
        return xmlAttribute == newAttr ? null : xmlAttribute;
    }

    public XmlAttribute setAttributeNode(String localName, String namespaceURI) {
        XmlConvert.verifyNCName(localName);
        return this.getAttributes().append(this.getOwnerDocument().createAttribute(StringExtensions.Empty, localName, namespaceURI, false, true));
    }

    @Override
    public void writeContentTo(XmlWriter w2) {
        int n2 = 0;
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            xmlNode.writeTo(w2);
            ++n2;
        }
        if (n2 == 0 && this.d && w2 instanceof DefaultXmlWriter) {
            ((DefaultXmlWriter)w2).setEmptyNode();
        }
    }

    @Override
    public void writeTo(XmlWriter w2) {
        w2.writeStartElement(this.b.NS == null || this.b.NS.length() == 0 ? StringExtensions.Empty : this.b.Prefix, this.b.LocalName, this.b.NS);
        if (this.hasAttributes()) {
            for (int i2 = 0; i2 < this.getAttributes().size(); ++i2) {
                this.getAttributes().get_ItemOf(i2).writeTo(w2);
            }
        }
        this.writeContentTo(w2);
        if (this.isEmpty()) {
            w2.writeEndElement();
        } else {
            w2.writeFullEndElement();
        }
    }
}

