/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.DTDAttListDeclaration;
import com.aspose.html.internal.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.internal.ms.System.Xml.DTDElementDeclaration;
import com.aspose.html.internal.ms.System.Xml.XmlAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlDocumentType;
import com.aspose.html.internal.ms.System.Xml.XmlElement;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlNamedNodeMap;
import com.aspose.html.internal.ms.System.Xml.XmlNode;

public final class XmlAttributeCollection
extends XmlNamedNodeMap
implements ICollection {
    private XmlElement a;
    private XmlDocument b;

    XmlAttributeCollection(XmlNode parent) {
        super(parent);
        this.a = parent instanceof XmlElement ? (XmlElement)parent : null;
        this.b = parent.getOwnerDocument();
        if (this.a == null) {
            throw new XmlException("invalid construction for XmlAttributeCollection.");
        }
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    private boolean a() {
        return this.a.isReadOnly();
    }

    public XmlAttribute get_ItemOf(String name) {
        return (XmlAttribute)this.getNamedItem(name);
    }

    public XmlAttribute get_ItemOf(int i2) {
        return (XmlAttribute)this.getNodes().get_Item(i2);
    }

    public XmlAttribute get_ItemOf(String localName, String namespaceURI) {
        return (XmlAttribute)this.getNamedItem(localName, namespaceURI);
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public XmlAttribute append(XmlAttribute node) {
        this.setNamedItem(node);
        return node;
    }

    public void copyTo(XmlAttribute[] array, int index) {
        int n2 = 0;
        int n3 = this.size();
        while (n2 < n3) {
            array[index] = (XmlAttribute)((XmlNode)this.getNodes().get_Item(n2)).cloneNode(true);
            ++n2;
            ++index;
        }
    }

    @Override
    public void copyTo(Array array, int index) {
        int n2 = 0;
        int n3 = this.getNodes().size();
        while (n2 < n3) {
            array.setValue(this.getNodes().get_Item(n2), index);
            ++n2;
            ++index;
        }
    }

    public XmlAttribute insertAfter(XmlAttribute newNode, XmlAttribute refNode) {
        if (refNode == null) {
            if (this.size() == 0) {
                return this.insertBefore(newNode, null);
            }
            return this.insertBefore(newNode, this.get_ItemOf(0));
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (refNode != this.getNodes().get_Item(i2)) continue;
            return this.insertBefore(newNode, this.size() == i2 + 1 ? null : this.get_ItemOf(i2 + 1));
        }
        throw new ArgumentException("refNode not found in this collection.");
    }

    public XmlAttribute insertBefore(XmlAttribute newNode, XmlAttribute refNode) {
        if (newNode.getOwnerDocument() != this.b) {
            throw new ArgumentException("different document created this newNode.");
        }
        this.b.onNodeInserting(newNode, null);
        int n2 = this.size();
        if (refNode != null) {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                XmlNode xmlNode;
                Object object = this.getNodes().get_Item(i2);
                XmlNode xmlNode2 = xmlNode = object instanceof XmlNode ? (XmlNode)object : null;
                if (xmlNode != refNode) continue;
                n2 = i2;
                break;
            }
            if (n2 == this.size()) {
                throw new ArgumentException("refNode not found in this collection.");
            }
        }
        this.setNamedItem(newNode, n2, false);
        this.b.onNodeInserted(newNode, null);
        return newNode;
    }

    public XmlAttribute prepend(XmlAttribute node) {
        return this.insertAfter(node, null);
    }

    public XmlAttribute remove(XmlAttribute node) {
        DTDAttributeDefinition dTDAttributeDefinition;
        XmlAttribute xmlAttribute;
        if (this.a()) {
            throw new ArgumentException("This attribute collection is read-only.");
        }
        if (node == null) {
            throw new ArgumentException("Specified node is null.");
        }
        if (node.getOwnerDocument() != this.b) {
            throw new ArgumentException("Specified node is in a different document.");
        }
        if (node.getOwnerElement() != this.a) {
            throw new ArgumentException("The specified attribute is not contained in the element.");
        }
        XmlAttribute xmlAttribute2 = null;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            xmlAttribute = (XmlAttribute)this.getNodes().get_Item(i2);
            if (xmlAttribute != node) continue;
            xmlAttribute2 = xmlAttribute;
            break;
        }
        if (xmlAttribute2 != null) {
            this.b.onNodeRemoving(node, this.a);
            super.removeNamedItem(xmlAttribute2.getLocalName(), xmlAttribute2.getNamespaceURI());
            this.a(xmlAttribute2);
            this.b.onNodeRemoved(node, this.a);
        }
        if ((dTDAttributeDefinition = xmlAttribute2.getAttributeDefinition()) != null && dTDAttributeDefinition.getDefaultValue() != null) {
            xmlAttribute = this.b.createAttribute(xmlAttribute2.getPrefix(), xmlAttribute2.getLocalName(), xmlAttribute2.getNamespaceURI(), true, false);
            xmlAttribute.setValue(dTDAttributeDefinition.getDefaultValue());
            xmlAttribute.setDefault();
            this.setNamedItem(xmlAttribute);
        }
        xmlAttribute2.setAttributeOwnerElement(null);
        return xmlAttribute2;
    }

    public void removeAll() {
        int n2 = 0;
        while (n2 < this.size()) {
            XmlAttribute xmlAttribute = this.get_ItemOf(n2);
            if (!xmlAttribute.getSpecified()) {
                ++n2;
            }
            this.remove(xmlAttribute);
        }
    }

    public XmlAttribute removeAt(int i2) {
        if (this.size() <= i2) {
            return null;
        }
        return this.remove((XmlAttribute)this.getNodes().get_Item(i2));
    }

    @Override
    public XmlNode setNamedItem(XmlNode node) {
        XmlAttribute xmlAttribute;
        if (this.a()) {
            throw new ArgumentException("this AttributeCollection is read only.");
        }
        XmlAttribute xmlAttribute2 = xmlAttribute = node instanceof XmlAttribute ? (XmlAttribute)node : null;
        if (xmlAttribute.getOwnerElement() == this.a) {
            return node;
        }
        if (xmlAttribute.getOwnerElement() != null) {
            throw new ArgumentException("This attribute is already set to another element.");
        }
        this.a.getOwnerDocument().onNodeInserting(node, this.a);
        xmlAttribute.setAttributeOwnerElement(this.a);
        XmlNode xmlNode = super.setNamedItem(node, -1, false);
        this.a(node instanceof XmlAttribute ? (XmlAttribute)node : null, xmlNode == node ? null : xmlNode);
        this.a.getOwnerDocument().onNodeInserted(node, this.a);
        return xmlNode instanceof XmlAttribute ? xmlNode : null;
    }

    void addIdenticalAttribute() {
        this.a(false);
    }

    void removeIdenticalAttribute() {
        this.a(true);
    }

    private void a(boolean bl2) {
        if (this.a == null) {
            return;
        }
        XmlDocumentType xmlDocumentType = this.b.getDocumentType();
        if (xmlDocumentType == null || xmlDocumentType.getDTD() == null) {
            return;
        }
        DTDElementDeclaration dTDElementDeclaration = xmlDocumentType.getDTD().getElementDecls().get_Item(this.a.getName());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            DTDAttributeDefinition dTDAttributeDefinition;
            XmlAttribute xmlAttribute = (XmlAttribute)this.getNodes().get_Item(i2);
            DTDAttributeDefinition dTDAttributeDefinition2 = dTDAttributeDefinition = dTDElementDeclaration == null ? null : dTDElementDeclaration.getAttributes().get_Item(xmlAttribute.getName());
            if (dTDAttributeDefinition == null || dTDAttributeDefinition.getDatatype().getTokenizedType() != 1) continue;
            if (bl2) {
                if (this.b.getIdenticalAttribute(xmlAttribute.getValue()) == null) continue;
                this.b.removeIdenticalAttribute(xmlAttribute.getValue());
                return;
            }
            if (this.b.getIdenticalAttribute(xmlAttribute.getValue()) != null) {
                throw new XmlException(StringExtensions.format("ID value {0} already exists in this document.", xmlAttribute.getValue()));
            }
            this.b.addIdenticalAttribute(xmlAttribute);
            return;
        }
    }

    private void a(XmlAttribute xmlAttribute, XmlNode xmlNode) {
        DTDAttributeDefinition dTDAttributeDefinition;
        XmlDocumentType xmlDocumentType;
        if (this.a == null) {
            return;
        }
        if (xmlNode != null) {
            this.a(xmlNode);
        }
        if ((xmlDocumentType = xmlAttribute.getOwnerDocument().getDocumentType()) == null || xmlDocumentType.getDTD() == null) {
            return;
        }
        DTDAttListDeclaration dTDAttListDeclaration = xmlDocumentType.getDTD().getAttListDecls().get_Item(this.a.getName());
        DTDAttributeDefinition dTDAttributeDefinition2 = dTDAttributeDefinition = dTDAttListDeclaration == null ? null : dTDAttListDeclaration.get(xmlAttribute.getName());
        if (dTDAttributeDefinition == null || dTDAttributeDefinition.getDatatype().getTokenizedType() != 1) {
            return;
        }
        this.b.addIdenticalAttribute(xmlAttribute);
    }

    private XmlNode a(XmlNode xmlNode) {
        if (this.a == null) {
            return xmlNode;
        }
        if (xmlNode != null && this.b.getIdenticalAttribute(xmlNode.getValue()) != null) {
            this.b.removeIdenticalAttribute(xmlNode.getValue());
        }
        return xmlNode;
    }
}

