/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.Xml.ObjectMap;
import com.aspose.html.internal.ms.System.Xml.XmlCustomFormatter;
import com.aspose.html.internal.ms.lang.Operators;

class EnumMap
extends ObjectMap {
    EnumMapMember[] _members;
    boolean _isFlags;
    String[] _enumNames = null;
    String[] _xmlNames = null;
    long[] _values = null;

    public EnumMap(EnumMapMember[] members, boolean isFlags) {
        this._members = members;
        this._isFlags = isFlags;
        this._enumNames = new String[this._members.length];
        this._xmlNames = new String[this._members.length];
        this._values = new long[this._members.length];
        for (int i2 = 0; i2 < this._members.length; ++i2) {
            EnumMapMember enumMapMember = this._members[i2];
            this._enumNames[i2] = enumMapMember.getEnumName();
            this._xmlNames[i2] = enumMapMember.getXmlName();
            this._values[i2] = enumMapMember.getValue();
        }
    }

    public boolean isFlags() {
        return this._isFlags;
    }

    public EnumMapMember[] getMembers() {
        return this._members;
    }

    public String[] getEnumNames() {
        return this._enumNames;
    }

    public String[] getXmlNames() {
        return this._xmlNames;
    }

    public long[] getValues() {
        return this._values;
    }

    public String getXmlName(String typeName, Object enumValue) {
        if (enumValue instanceof String) {
            throw new InvalidCastException();
        }
        long l2 = 0L;
        try {
            Type type = Operators.typeOf(enumValue.getClass());
            l2 = type.isEnum() ? ((Enum)enumValue).get_Value() : Convert.toInt64(enumValue);
        }
        catch (FormatException formatException) {
            throw new InvalidCastException();
        }
        catch (NotImplementedException notImplementedException) {
            throw new InvalidOperationException();
        }
        for (int i2 = 0; i2 < this.getValues().length; ++i2) {
            if (this.getValues()[i2] != l2) continue;
            return this.getXmlNames()[i2];
        }
        if (this.isFlags() && l2 == 0L) {
            return StringExtensions.Empty;
        }
        String string = StringExtensions.Empty;
        if (this.isFlags()) {
            string = XmlCustomFormatter.fromEnum(l2, this.getXmlNames(), this.getValues(), typeName);
        }
        if (string.length() == 0) {
            throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", l2, typeName));
        }
        return string;
    }

    public String getEnumName(String typeName, String xmlName) {
        if (this._isFlags) {
            String[] stringArray;
            if ((xmlName = StringExtensions.trim(xmlName)).length() == 0) {
                return "0";
            }
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (String string : stringArray = StringExtensions.split(xmlName, null)) {
                if (StringExtensions.equals(string, StringExtensions.Empty)) continue;
                String string2 = null;
                for (int i2 = 0; i2 < this.getXmlNames().length; ++i2) {
                    if (!StringExtensions.equals(this.getXmlNames()[i2], string)) continue;
                    string2 = this.getEnumNames()[i2];
                    break;
                }
                if (string2 != null) {
                    if (msStringBuilder2.getLength() > 0) {
                        msStringBuilder2.append(',');
                    }
                    msStringBuilder2.append(string2);
                    continue;
                }
                throw new InvalidOperationException(StringExtensions.format(CultureInfo.getCurrentCulture(), "'{0}' is not a valid value for {1}.", string, typeName));
            }
            return msStringBuilder2.toString();
        }
        for (EnumMapMember enumMapMember : this._members) {
            if (!StringExtensions.equals(enumMapMember.getXmlName(), xmlName)) continue;
            return enumMapMember.getEnumName();
        }
        return null;
    }

    public static class EnumMapMember {
        String _xmlName;
        String _enumName;
        long _value;
        private String a;

        public EnumMapMember(String xmlName, String enumName) {
            this(xmlName, enumName, 0L);
        }

        public EnumMapMember(String xmlName, String enumName, long value) {
            this._xmlName = xmlName;
            this._enumName = enumName;
            this._value = value;
        }

        public String getXmlName() {
            return this._xmlName;
        }

        public String getEnumName() {
            return this._enumName;
        }

        public long getValue() {
            return this._value;
        }

        public String getDocumentation() {
            return this.a;
        }

        public void setDocumentation(String value) {
            this.a = value;
        }
    }
}

