/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;

public final class Version
implements ICloneable,
Comparable<Version> {
    private int a;
    private int b;
    private int c;
    private int d;

    public Version() {
        this.a = -1;
        this.d = -1;
        this.b = 0;
        this.c = 0;
    }

    public Version(int major, int minor) {
        this.a = -1;
        this.d = -1;
        if (major < 0) {
            throw new ArgumentOutOfRangeException("major");
        }
        if (minor < 0) {
            throw new ArgumentOutOfRangeException("minor");
        }
        this.b = major;
        this.c = minor;
    }

    public Version(int major, int minor, int build) {
        this.a = -1;
        this.d = -1;
        if (major < 0) {
            throw new ArgumentOutOfRangeException("major");
        }
        if (minor < 0) {
            throw new ArgumentOutOfRangeException("minor");
        }
        if (build < 0) {
            throw new ArgumentOutOfRangeException("build");
        }
        this.b = major;
        this.c = minor;
        this.a = build;
    }

    public Version(int major, int minor, int build, int revision) {
        this.a = -1;
        this.d = -1;
        if (major < 0) {
            throw new ArgumentOutOfRangeException("major");
        }
        if (minor < 0) {
            throw new ArgumentOutOfRangeException("minor");
        }
        if (build < 0) {
            throw new ArgumentOutOfRangeException("build");
        }
        if (revision < 0) {
            throw new ArgumentOutOfRangeException("revision");
        }
        this.b = major;
        this.c = minor;
        this.a = build;
        this.d = revision;
    }

    public Version(String version) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        if (version == null) {
            throw new ArgumentNullException("version");
        }
        String[] stringArray = StringExtensions.split(version, new char[]{'.'});
        int n6 = stringArray.length;
        if (n6 < 2 || n6 > 4) {
            throw new ArgumentException("There must be 2, 3 or 4 components in the version string.");
        }
        if (n6 > 0) {
            n2 = Int32Extensions.parse(stringArray[0]);
        }
        if (n6 > 1) {
            n3 = Int32Extensions.parse(stringArray[1]);
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("major");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("minor");
        }
        if (n6 > 2 && (n4 = Int32Extensions.parse(stringArray[2])) < 0) {
            throw new ArgumentOutOfRangeException("build");
        }
        if (n6 > 3 && (n5 = Int32Extensions.parse(stringArray[3])) < 0) {
            throw new ArgumentOutOfRangeException("revision");
        }
        this.b = n2;
        this.c = n3;
        this.a = n4;
        this.d = n5;
    }

    @Override
    public int compareTo(Version value) {
        if (value == null) {
            return 1;
        }
        if (this.b != value.b) {
            if (this.b > value.b) {
                return 1;
            }
            return -1;
        }
        if (this.c != value.c) {
            if (this.c > value.c) {
                return 1;
            }
            return -1;
        }
        if (this.a != value.a) {
            if (this.a > value.a) {
                return 1;
            }
            return -1;
        }
        if (this.d == value.d) {
            return 0;
        }
        if (this.d > value.d) {
            return 1;
        }
        return -1;
    }

    @Override
    public Object deepClone() {
        Version version = new Version();
        version.b = this.b;
        version.c = this.c;
        version.a = this.a;
        version.d = this.d;
        return version;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Version version = (Version)o2;
        return this.b == version.b && this.c == version.c && this.a == version.a && this.d == version.d;
    }

    public int hashCode() {
        int n2 = 0;
        n2 |= (this.b & 0xF) << 28;
        n2 |= (this.c & 0xFF) << 20;
        return (n2 |= (this.a & 0xFF) << 12) | this.d & 0xFFF;
    }

    public int getBuild() {
        return this.a;
    }

    public int getMajor() {
        return this.b;
    }

    public short getMajorRevision() {
        return (short)(this.d >> 16);
    }

    public int getMinor() {
        return this.c;
    }

    public short getMinorRevision() {
        return (short)(this.d & 0xFFFF);
    }

    public int getRevision() {
        return this.d;
    }

    public String toString(int fieldCount) {
        switch (fieldCount) {
            case 0: {
                return StringExtensions.Empty;
            }
            case 1: {
                return Integer.toString(this.b);
            }
            case 2: {
                return this.b + "." + this.c;
            }
        }
        if (this.a == -1) {
            throw new ArgumentException();
        }
        if (fieldCount == 3) {
            return StringExtensions.concat(this.b, ".", this.c, ".", this.a);
        }
        if (this.d == -1) {
            throw new ArgumentException();
        }
        if (fieldCount != 4) {
            throw new ArgumentException();
        }
        return StringExtensions.concat(this.b, ".", this.c, ".", this.a, ".", this.d);
    }

    public String toString() {
        if (this.a == -1) {
            return this.toString(2);
        }
        if (this.d == -1) {
            return this.toString(3);
        }
        return this.toString(4);
    }

    public static boolean op_Equality(Version v1, Version v2) {
        if (ObjectExtensions.referenceEquals(v1, null)) {
            return ObjectExtensions.referenceEquals(v2, null);
        }
        return v1.equals(v2);
    }

    public static boolean op_GreaterThan(Version v1, Version v2) {
        return Version.op_LessThan(v2, v1);
    }

    public static boolean op_GreaterThanOrEqual(Version v1, Version v2) {
        return Version.op_LessThanOrEqual(v2, v1);
    }

    public static boolean op_Inequality(Version v1, Version v2) {
        return !Version.op_Equality(v1, v2);
    }

    public static boolean op_LessThan(Version v1, Version v2) {
        if (v1 == null) {
            throw new ArgumentNullException("v1");
        }
        return v1.compareTo(v2) < 0;
    }

    public static boolean op_LessThanOrEqual(Version v1, Version v2) {
        if (v1 == null) {
            throw new ArgumentNullException("v1");
        }
        return v1.compareTo(v2) <= 0;
    }
}

