/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Threading;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Threading.EventWaitHandle;
import com.aspose.html.internal.ms.System.Threading.SynchronizationLockException;
import com.aspose.html.internal.ms.System.Threading.ThreadInterruptedException;
import com.aspose.time.TimeSpan;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class Monitor {
    private static final Hashtable<Object, MonitorInfo> a = new Hashtable(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enter(Object obj) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    ReentrantLock reentrantLock = a.get(obj).a();
                    reentrantLock.lock();
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    reentrantLock.lock();
                    a.put(obj, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Monitor.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Object obj) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    ReentrantLock reentrantLock = a.get(obj).a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        reentrantLock.unlock();
                        if (!reentrantLock.hasQueuedThreads() && !reentrantLock.isLocked()) {
                            a.remove(obj);
                        }
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            Monitor.a();
        }
    }

    private static void a() {
        throw new SynchronizationLockException("Object synchronization method was called from an unsynchronized block of code.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulse(Object obj) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    MonitorInfo monitorInfo = a.get(obj);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        monitorInfo.b().set();
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulseAll(Object obj) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    MonitorInfo monitorInfo = a.get(obj);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        monitorInfo.b().a();
                    } else {
                        Monitor.a();
                    }
                } else {
                    Monitor.a();
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
    }

    public static boolean wait(Object obj) {
        return Monitor.wait(obj, -1, false);
    }

    public static boolean wait(Object obj, int millisecondsTimeout) {
        return Monitor.wait(obj, millisecondsTimeout, false);
    }

    public static boolean wait(Object obj, TimeSpan timeout) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.wait(obj, (int)l2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object obj, int timeout, boolean exitContext) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        boolean bl2 = true;
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    MonitorInfo monitorInfo = a.get(obj);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    if (reentrantLock.isHeldByCurrentThread()) {
                        reentrantLock.unlock();
                        bl2 = monitorInfo.b().waitOne(timeout);
                        reentrantLock.lock();
                    } else {
                        Monitor.a();
                    }
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    reentrantLock.lock();
                    a.put(obj, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
        return bl2;
    }

    public static boolean wait(Object obj, TimeSpan timeout, boolean exitContext) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.wait(obj, (int)l2, exitContext);
    }

    public static boolean tryEnter(Object obj) {
        return Monitor.tryEnter(obj, 0);
    }

    public static boolean tryEnter(Object obj, TimeSpan timeout) {
        long l2 = (long)timeout.getTotalMilliseconds();
        if (l2 < -1L || l2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        return Monitor.tryEnter(obj, (int)l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryEnter(Object obj, int timeout) {
        if (obj == null) {
            throw new ArgumentNullException("obj");
        }
        if (timeout < -1) {
            throw new ArgumentOutOfRangeException("timeout");
        }
        boolean bl2 = true;
        try {
            Hashtable<Object, MonitorInfo> hashtable = a;
            synchronized (hashtable) {
                if (a.containsKey(obj)) {
                    MonitorInfo monitorInfo = a.get(obj);
                    ReentrantLock reentrantLock = monitorInfo.a();
                    bl2 = reentrantLock.tryLock(timeout, TimeUnit.MILLISECONDS);
                } else {
                    ReentrantLock reentrantLock = new ReentrantLock();
                    bl2 = reentrantLock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    a.put(obj, new MonitorInfo(reentrantLock));
                }
            }
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            throw new SynchronizationLockException(illegalMonitorStateException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new ThreadInterruptedException(interruptedException.getMessage());
        }
        return bl2;
    }

    private static class MonitorInfo {
        private ReentrantLock a;
        private LockEventHandler b;

        private MonitorInfo(ReentrantLock lock) {
            this.a = lock;
            this.b = new LockEventHandler(false);
        }

        public ReentrantLock a() {
            return this.a;
        }

        public LockEventHandler b() {
            return this.b;
        }

        private class LockEventHandler
        extends EventWaitHandle {
            LockEventHandler(boolean initialState) {
                super(initialState, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean set() {
                Object object = this.syncObj;
                synchronized (object) {
                    this.isReady = true;
                    this.syncObj.notify();
                    this.b().countDown();
                    return true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean a() {
                Object object = this.syncObj;
                synchronized (object) {
                    this.isReady = true;
                    this.syncObj.notifyAll();
                    this.b().countDown();
                    return true;
                }
            }
        }
    }
}

