/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.core.System.m;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class SingleExtensions {
    public static final float MinValue = -3.4028235E38f;
    public static final float Epsilon = Float.MIN_VALUE;
    public static final float MaxValue = Float.MAX_VALUE;
    public static final float PositiveInfinity = Float.POSITIVE_INFINITY;
    public static final float NegativeInfinity = Float.NEGATIVE_INFINITY;
    public static final float NaN = Float.NaN;

    public static int compareTo(float a2, float b2) {
        if (SingleExtensions.isPositiveInfinity(a2) && SingleExtensions.isPositiveInfinity(b2)) {
            return 0;
        }
        if (SingleExtensions.isNegativeInfinity(a2) && SingleExtensions.isNegativeInfinity(b2)) {
            return 0;
        }
        if (SingleExtensions.isNaN(b2)) {
            if (SingleExtensions.isNaN(a2)) {
                return 0;
            }
            return 1;
        }
        if (SingleExtensions.isNaN(a2) && !SingleExtensions.isNaN(b2)) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        if (a2 < b2) {
            return -1;
        }
        return 0;
    }

    public static int compareTo(float a2, Object b2) {
        if (b2 == null) {
            return 1;
        }
        if (b2.getClass() != Float.class) {
            throw new ArgumentException("Value is not a System.Single");
        }
        float f2 = Convert.toSingle(b2);
        if (SingleExtensions.isPositiveInfinity(a2) && SingleExtensions.isPositiveInfinity(f2)) {
            return 0;
        }
        if (SingleExtensions.isNegativeInfinity(a2) && SingleExtensions.isNegativeInfinity(f2)) {
            return 0;
        }
        if (SingleExtensions.isNaN(f2)) {
            return SingleExtensions.isNaN(a2) ? 0 : 1;
        }
        if (SingleExtensions.isNaN(a2) && !SingleExtensions.isNaN(f2)) {
            return -1;
        }
        if (a2 > f2) {
            return 1;
        }
        if (a2 < f2) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(float a2, float b2) {
        return b2 == a2 || SingleExtensions.isNaN(b2) && SingleExtensions.isNaN(a2);
    }

    public static boolean equals(float a2, Object b2) {
        if (b2.getClass() != Float.class) {
            return false;
        }
        float f2 = Convert.toSingle(b2);
        return SingleExtensions.equals(a2, f2);
    }

    public static int getHashCode(float a2) {
        return new Float(a2).hashCode();
    }

    public static int getTypeCode() {
        return 13;
    }

    public static boolean isInfinity(float d2) {
        return d2 == Float.POSITIVE_INFINITY || d2 == Float.NEGATIVE_INFINITY;
    }

    public static boolean isNaN(float d2) {
        return Double.isNaN(d2);
    }

    public static boolean isNegativeInfinity(float value) {
        return value == Float.NEGATIVE_INFINITY;
    }

    public static boolean isPositiveInfinity(float value) {
        return value == Float.POSITIVE_INFINITY;
    }

    public static float parse(String s2) {
        return m.a(s2);
    }

    public static float parse(String s2, int numberStyles) {
        return m.a(s2, numberStyles);
    }

    public static float parse(String s2, IFormatProvider provider) {
        return m.a(s2, provider);
    }

    public static float parse(String s2, int numberStyles, IFormatProvider provider) {
        return m.a(s2, numberStyles, provider);
    }

    public static String toString(float value) {
        return k.a("G", value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(float value, IFormatProvider provider) {
        return k.a(null, value, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    public static String toString(float value, String pattern) {
        return k.a(pattern, value, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(float value, String pattern, IFormatProvider provider) {
        return k.a(pattern, value, (IFormatProvider)NumberFormatInfo.getInstance(provider));
    }

    public static boolean tryParse(String source, int numberStyles, IFormatProvider provider, float[] referenceToValue) {
        try {
            referenceToValue[0] = SingleExtensions.parse(source, numberStyles, provider);
            return true;
        }
        catch (Exception exception) {
            referenceToValue[0] = 0.0f;
            return false;
        }
    }

    public static boolean tryParse(String source, float[] referenceToValue) {
        return SingleExtensions.tryParse(source, 231, NumberFormatInfo.getCurrentInfo(), referenceToValue);
    }
}

