/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Principal;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Security.Principal.IIdentity;
import com.aspose.html.internal.ms.System.Security.Principal.IPrincipal;
import com.aspose.html.internal.ms.System.Security.Principal.SecurityIdentifier;
import com.aspose.html.internal.ms.System.Security.Principal.WindowsIdentity;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class WindowsPrincipal
implements IPrincipal {
    private WindowsIdentity a;
    private String[] b;

    public WindowsPrincipal(WindowsIdentity ntIdentity) {
        if (ntIdentity == null) {
            throw new ArgumentNullException("ntIdentity");
        }
        this.a = ntIdentity;
    }

    @Override
    public IIdentity getIdentity() {
        return this.a;
    }

    public boolean isInRoleByRID(int rid) {
        if (!Environment.IsRunningOnWindows) {
            throw new NotImplementedException();
        }
        String string = null;
        switch (rid) {
            case 544: {
                string = "BUILTIN\\Administrators";
                break;
            }
            case 545: {
                string = "BUILTIN\\Users";
                break;
            }
            case 546: {
                string = "BUILTIN\\Guests";
                break;
            }
            case 547: {
                string = "BUILTIN\\Power Users";
                break;
            }
            case 548: {
                string = "BUILTIN\\Account Operators";
                break;
            }
            case 549: {
                string = "BUILTIN\\System Operators";
                break;
            }
            case 550: {
                string = "BUILTIN\\Print Operators";
                break;
            }
            case 551: {
                string = "BUILTIN\\Backup Operators";
                break;
            }
            case 552: {
                string = "BUILTIN\\Replicator";
                break;
            }
            default: {
                return false;
            }
        }
        return this.isInRole(string);
    }

    @Override
    public boolean isInRole(String role) {
        if (role == null) {
            return false;
        }
        if (!Environment.IsRunningOnWindows) {
            return WindowsPrincipal.a(this.a(), role);
        }
        if (this.b == null) {
            this.b = WindowsIdentity.a(this.a());
        }
        role = StringExtensions.toUpperInvariant(role);
        for (String string : this.b) {
            if (string == null || !StringExtensions.equals(role, StringExtensions.toUpperInvariant(string))) continue;
            return true;
        }
        return false;
    }

    public boolean isInRoleByWindowsBuiltInRID(int role) {
        if (!Environment.IsRunningOnWindows) {
            String string = null;
            switch (role) {
                case 544: {
                    string = "root";
                    break;
                }
                default: {
                    return false;
                }
            }
            return this.isInRole(string);
        }
        return this.isInRoleByRID(role);
    }

    public boolean isInRole(SecurityIdentifier sid) {
        throw new NotImplementedException();
    }

    private IntPtr a() {
        return Operators.as(this.a, WindowsIdentity.class).getToken();
    }

    private static boolean a(IntPtr intPtr, IntPtr intPtr2) {
        throw new NotImplementedException();
    }

    private static boolean a(IntPtr intPtr, String string) {
        throw new NotImplementedException();
    }
}

