/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.CollectionBase;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

@SerializableAttribute
public class X509CertificateCollection
extends CollectionBase {
    public X509CertificateCollection() {
    }

    public X509CertificateCollection(X509Certificate[] value) {
        this.addRange(value);
    }

    public X509CertificateCollection(X509CertificateCollection value) {
        this.addRange(value);
    }

    @Override
    public X509Certificate get_Item(int index) {
        return (X509Certificate)this.getInnerList().get_Item(index);
    }

    public void set_Item(int index, X509Certificate value) {
        this.getInnerList().set_Item(index, value);
    }

    public int add(X509Certificate value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        return this.getInnerList().addItem(value);
    }

    public void addRange(X509Certificate[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        for (int i2 = 0; i2 < value.length; ++i2) {
            this.getInnerList().addItem(value[i2]);
        }
    }

    public void addRange(X509CertificateCollection value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        for (int i2 = 0; i2 < value.getInnerList().size(); ++i2) {
            this.getInnerList().addItem(value.get_Item(i2));
        }
    }

    public boolean contains(X509Certificate value) {
        if (value == null) {
            return false;
        }
        byte[] byArray = value.getCertHash();
        for (int i2 = 0; i2 < this.getInnerList().size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)this.getInnerList().get_Item(i2);
            if (!this.a(x509Certificate.getCertHash(), byArray)) continue;
            return true;
        }
        return false;
    }

    public void copyTo(X509Certificate[] array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        this.getInnerList().copyTo(Array.boxing(array), index);
    }

    @Override
    public IEnumerator iterator() {
        return new X509CertificateEnumerator(this);
    }

    public int hashCode() {
        return this.getInnerList().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getInnerList().equals(obj);
    }

    public int indexOf(X509Certificate value) {
        return this.getInnerList().indexOf(value);
    }

    public void insert(int index, X509Certificate value) {
        this.getInnerList().insertItem(index, value);
    }

    public void remove(X509Certificate value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (this.indexOf(value) == -1) {
            throw new ArgumentException("value", StringExtensions.format("Not part of the collection.", new Object[0]));
        }
        this.getInnerList().removeItem(value);
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (Operators.castToInt32(byArray[i2], 6) == Operators.castToInt32(byArray2[i2], 6)) continue;
            return false;
        }
        return true;
    }

    protected ArrayList get_InnerList() {
        return this.getInnerList();
    }

    public static class X509CertificateEnumerator
    implements IEnumerator {
        private IEnumerator a;

        public X509CertificateEnumerator(X509CertificateCollection mappings) {
            this.a = mappings.iterator();
        }

        @Override
        public X509Certificate next() {
            return (X509Certificate)this.a.next();
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public void reset() {
            this.a.reset();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

