/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Base64Constants;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class ToBase64Transform
implements ICryptoTransform {
    private static final int a = 3;
    private static final int b = 4;
    private boolean c;

    @Override
    public boolean canTransformMultipleBlocks() {
        return false;
    }

    @Override
    public boolean canReuseTransform() {
        return true;
    }

    @Override
    public int getInputBlockSize() {
        return 3;
    }

    @Override
    public int getOutputBlockSize() {
        return 4;
    }

    public void clear() {
        this.dispose(true);
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean disposing) {
        if (!this.c) {
            if (disposing) {
                // empty if block
            }
            this.c = true;
        }
    }

    @Override
    public int transformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset) {
        if (this.c) {
            throw new ObjectDisposedException("TransformBlock");
        }
        if (inputBuffer == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (outputBuffer == null) {
            throw new ArgumentNullException("outputBuffer");
        }
        if (inputCount < 0) {
            throw new ArgumentException("inputCount", "< 0");
        }
        if (inputCount > inputBuffer.length) {
            throw new ArgumentException("inputCount", n.a("Overflow"));
        }
        if (inputOffset < 0) {
            throw new ArgumentOutOfRangeException("inputOffset", "< 0");
        }
        if (inputOffset > inputBuffer.length - inputCount) {
            throw new ArgumentException("inputOffset\r\nParameter name: " + n.a("Overflow"));
        }
        if (outputOffset < 0) {
            throw new ArgumentOutOfRangeException("outputOffset", "< 0");
        }
        if (outputOffset > outputBuffer.length - inputCount) {
            throw new ArgumentException("outputOffset\r\nParameter name: " + n.a("Overflow"));
        }
        ToBase64Transform.a(inputBuffer, inputOffset, inputCount, outputBuffer, outputOffset);
        return this.getOutputBlockSize();
    }

    static void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = Base64Constants.a;
        int n5 = byArray[n2] & 0xFF;
        int n6 = byArray[n2 + 1] & 0xFF;
        int n7 = byArray[n2 + 2] & 0xFF;
        byArray2[n4] = byArray3[n5 >> 2];
        byArray2[n4 + 1] = byArray3[n5 << 4 & 0x30 | n6 >> 4];
        byArray2[n4 + 2] = byArray3[n6 << 2 & 0x3C | n7 >> 6];
        byArray2[n4 + 3] = byArray3[n7 & 0x3F];
    }

    @Override
    public byte[] transformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount) {
        if (this.c) {
            throw new ObjectDisposedException("TransformFinalBlock");
        }
        if (inputBuffer == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (inputCount < 0) {
            throw new ArgumentOutOfRangeException("inputCount", "< 0");
        }
        if (inputOffset > inputBuffer.length - inputCount) {
            throw new ArgumentException("inputCount\r\nParameter name: " + n.a("Overflow"));
        }
        if (inputCount > this.getInputBlockSize()) {
            throw new ArgumentException("Parameter name: " + n.a("Invalid input length"));
        }
        return ToBase64Transform.internalTransformFinalBlock(inputBuffer, inputOffset, inputCount);
    }

    public static byte[] internalTransformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount) {
        int n2 = 3;
        int n3 = 4;
        int n4 = inputCount / n2;
        int n5 = inputCount % n2;
        byte[] byArray = new byte[inputCount != 0 ? (inputCount + 2) / n2 * n3 : 0];
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            ToBase64Transform.a(inputBuffer, inputOffset, n2, byArray, n6);
            inputOffset += n2;
            n6 += n3;
        }
        byte[] byArray2 = Base64Constants.a;
        switch (n5) {
            case 0: {
                break;
            }
            case 1: {
                int n7 = inputBuffer[inputOffset] & 0xFF;
                byArray[n6] = byArray2[n7 >> 2];
                byArray[n6 + 1] = byArray2[n7 << 4 & 0x30];
                byArray[n6 + 2] = 61;
                byArray[n6 + 3] = 61;
                break;
            }
            case 2: {
                int n8 = inputBuffer[inputOffset] & 0xFF;
                int n9 = inputBuffer[inputOffset + 1] & 0xFF;
                byArray[n6] = byArray2[n8 >> 2];
                byArray[n6 + 1] = byArray2[n8 << 4 & 0x30 | n9 >> 4];
                byArray[n6 + 2] = byArray2[n9 << 2 & 0x3C];
                byArray[n6 + 3] = 61;
            }
        }
        return byArray;
    }
}

