/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.CmsSigner;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.ContentInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SignerInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SignerInfoCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.SubjectIdentifier;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Collection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Store;
import com.aspose.html.internal.ms.System.Security.Cryptography.Xml.X509IssuerSerial;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateConverter;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedDataGenerator;
import com.aspose.html.internal.ms.core.bc.cms.DefaultSignedAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerId;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGeneratorBuilder;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformation;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationStore;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationVerifier;
import com.aspose.html.internal.ms.core.bc.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.aspose.html.internal.ms.core.bc.operator.ContentSigner;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JcaContentSignerBuilder;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import com.aspose.html.internal.ms.core.bc.security.a;
import com.aspose.html.internal.ms.core.bc.util.CollectionStore;
import com.aspose.html.internal.ms.core.bc.util.Store;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import com.aspose.html.internal.ms.lang.Operators;
import java.security.cert.CertificateException;
import java.util.Collection;

public final class SignedCms {
    private ContentInfo a;
    private boolean b;
    private SignerInfoCollection c;
    private X509Certificate2Collection d = new X509Certificate2Collection();
    private int e;
    private int f;
    private CMSSignedDataGenerator g;
    private CMSSignedData h;

    public SignedCms() {
        this.c = new SignerInfoCollection();
        this.g = new CMSSignedDataGenerator();
    }

    public SignedCms(ContentInfo content) {
        this(content, false);
    }

    public SignedCms(ContentInfo content, boolean detached) {
        this();
        if (content == null) {
            throw new ArgumentNullException("content");
        }
        this.a = content;
        this.b = detached;
    }

    public SignedCms(int signerIdentifierType) {
        this();
        this.e = signerIdentifierType;
    }

    public SignedCms(int signerIdentifierType, ContentInfo content) {
        this(content, false);
        this.e = signerIdentifierType;
    }

    public SignedCms(int signerIdentifierType, ContentInfo content, boolean detached) {
        this(content, detached);
        this.e = signerIdentifierType;
    }

    public X509Certificate2Collection getCertificates() {
        return this.d;
    }

    public ContentInfo getContentInfo() {
        if (this.a == null) {
            Oid oid = new Oid("1.2.840.113549.1.7.1");
            this.a = new ContentInfo(oid, new byte[0]);
        }
        return this.a;
    }

    public boolean getDetached() {
        return this.b;
    }

    public SignerInfoCollection getSignerInfos() {
        return this.c;
    }

    public int getVersion() {
        return this.f;
    }

    public void checkSignature(boolean verifySignatureOnly) {
        this.checkSignature(null, verifySignatureOnly);
    }

    public void checkSignature(X509Certificate2Collection extraStore, boolean verifySignatureOnly) {
        this.a(extraStore);
    }

    private void a(X509Certificate2Collection x509Certificate2Collection) {
        try {
            Iterable<SignerInformation> iterable;
            Store<X509CertificateHolder> store = this.h.getCertificates();
            if (x509Certificate2Collection != null && x509Certificate2Collection.size() > 0) {
                iterable = new java.util.ArrayList();
                for (X509Certificate2 object : x509Certificate2Collection) {
                    iterable.add(com.aspose.html.internal.ms.core.bc.security.a.a(object));
                }
                for (X509CertificateHolder x509CertificateHolder : store.getMatches(null)) {
                    iterable.add((X509CertificateHolder)x509CertificateHolder);
                }
                store = new CollectionStore<SignerInformation>((Collection<SignerInformation>)iterable);
            }
            iterable = this.h.getSignerInfos();
            for (SignerInformation signerInformation : ((SignerInformationStore)iterable).getSigners()) {
                Object object;
                Object object2;
                ArrayList arrayList = null;
                if (signerInformation.getSID().getSubjectKeyIdentifier() != null) {
                    object2 = com.aspose.html.internal.ms.core.bc.security.a.a(signerInformation.getSID());
                    object = new java.util.ArrayList();
                    for (X509CertificateHolder x509CertificateHolder : store.getMatches(null)) {
                        if (!StringExtensions.equals(SignedCms.toString(SignedCms.a(new X509Certificate(x509CertificateHolder.getEncoded())), false), (String)((SubjectIdentifier)object2).getValue())) continue;
                        object.add(x509CertificateHolder);
                    }
                    arrayList = ArrayList.fromJava(object);
                } else {
                    arrayList = store.getMatches(signerInformation.getSID());
                }
                object2 = arrayList.iterator();
                object2.hasNext();
                object = new JcaSimpleSignerInfoVerifierBuilder().build((X509CertificateHolder)object2.next());
                if (signerInformation.verify((SignerInformationVerifier)object)) continue;
                throw new CryptographicException("Invalid signature");
            }
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    public void checkHash() {
        throw new NotImplementedException();
    }

    public void computeSignature() {
        if (this.a == null) {
            throw new CryptographicException("content is empty");
        }
        throw new NotSupportedException("This requires that the current process is running in user interactive mode. Try to use ComputeSignature(CmsSigner) method.");
    }

    public void computeSignature(CmsSigner signer) {
        if (this.a == null) {
            throw new CryptographicException("content is empty");
        }
        if (signer.getCertificate() == null) {
            throw new CryptographicException("Certificate == null");
        }
        try {
            Collection<X509CertificateHolder> collection;
            Object object222;
            if (this.h != null) {
                this.g = new CMSSignedDataGenerator();
                this.g.addSigners(this.h.getSignerInfos());
                this.g.addCertificates(this.h.getCertificates());
            }
            X509Certificate2 x509Certificate2 = signer.getCertificate();
            AsymmetricAlgorithm asymmetricAlgorithm = x509Certificate2.getPrivateKey();
            ContentSigner contentSigner = this.a(x509Certificate2, asymmetricAlgorithm);
            X509CertificateHolder x509CertificateHolder = com.aspose.html.internal.ms.core.bc.security.a.a(x509Certificate2);
            SignerInfoGenerator signerInfoGenerator = this.a(signer).build(contentSigner, x509CertificateHolder);
            this.g.addSignerInfoGenerator(signerInfoGenerator);
            if (!this.getCertificates().contains(x509Certificate2)) {
                this.getCertificates().add(x509Certificate2);
            }
            java.util.ArrayList<X509CertificateHolder> arrayList = new java.util.ArrayList<X509CertificateHolder>();
            arrayList.add(x509CertificateHolder);
            if (signer.getCertificates() != null) {
                for (Object object222 : signer.getCertificates()) {
                    arrayList.add(com.aspose.html.internal.ms.core.bc.security.a.a((com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate)object222));
                }
            }
            if (this.h != null) {
                collection = this.h.getCertificates().getMatches(null);
                for (X509CertificateHolder object3 : collection) {
                    if (!arrayList.contains(object3)) continue;
                    arrayList.remove(object3);
                }
            }
            collection = new CollectionStore(arrayList);
            this.g.addCertificates((Store)((Object)collection));
            this.h = this.g.generate(new CMSProcessableByteArray(this.a.getContent()), !this.b);
            object222 = null;
            X509Certificate2 x509Certificate22 = signer.getCertificate();
            SignerInformation signerInformation = null;
            for (SignerInformation signerInformation2 : this.h.getSignerInfos().getSigners()) {
                Object object;
                SignerInformation signerInformation3 = signerInformation2;
                SignerId signerId = signerInformation3.getSID();
                if (signerId.getIssuer() != null && x509Certificate22.getIssuer() != null && X500Name.getInstance(signerId.getIssuer()).equals(X500Name.getInstance(x509Certificate22.getInternalCertificate().getIssuerName().getBytes())) && signerId.getSerialNumber() != null && x509Certificate22.get_SerialNumber() != null && Hex.toHexString(signerId.getSerialNumber().toByteArray()).toUpperCase().equals(x509Certificate22.get_SerialNumber().toUpperCase())) {
                    signerInformation = signerInformation3;
                    object = new X509IssuerSerial(x509Certificate22.getIssuer(), x509Certificate22.get_SerialNumber());
                    object222 = new SubjectIdentifier(1, object);
                    break;
                }
                if (signerId.getSerialNumber() == null) continue;
                object = SignedCms.a(x509Certificate22.getInternalCertificate());
                object222 = new SubjectIdentifier(2, Hex.toHexString(object).toUpperCase());
                if (!Hex.toHexString(signerId.getSerialNumber().toByteArray()).toUpperCase().equals(Hex.toHexString(object).toUpperCase())) continue;
                signerInformation = signerInformation3;
                object222 = new SubjectIdentifier(2, Hex.toHexString(object).toUpperCase());
                break;
            }
            if (signerInformation == null) {
                throw new CryptographicException("invalid state");
            }
            SignerInfo signerInfo = new SignerInfo((SubjectIdentifier)object222, x509Certificate22, signer.getDigestAlgorithm(), new SignerInfoCollection(), signer.getSignedAttributes(), signer.getUnsignedAttributes(), signerInformation.getVersion(), signerInformation);
            this.c.add(signerInfo);
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    private SignerInfoGeneratorBuilder a(CmsSigner cmsSigner) throws OperatorCreationException {
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
        signerInfoGeneratorBuilder.setSignedAttributeGenerator(com.aspose.html.internal.ms.core.bc.security.a.a(cmsSigner.getSignedAttributes()));
        DefaultSignedAttributeTableGenerator defaultSignedAttributeTableGenerator = com.aspose.html.internal.ms.core.bc.security.a.a(cmsSigner.getUnsignedAttributes());
        if (defaultSignedAttributeTableGenerator != null) {
            signerInfoGeneratorBuilder.setUnsignedAttributeGenerator(defaultSignedAttributeTableGenerator);
        }
        return signerInfoGeneratorBuilder;
    }

    private ContentSigner a(com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate x509Certificate, AsymmetricAlgorithm asymmetricAlgorithm) throws OperatorCreationException {
        X509CertificateHolder x509CertificateHolder = com.aspose.html.internal.ms.core.bc.security.a.a(x509Certificate);
        try {
            java.security.cert.X509Certificate x509Certificate2 = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
            return new JcaContentSignerBuilder(x509Certificate2.getSigAlgName().toUpperCase()).build(com.aspose.html.internal.ms.core.bc.security.a.a(asymmetricAlgorithm).getPrivate());
        }
        catch (CertificateException certificateException) {
            throw new CryptographicException(certificateException.getMessage());
        }
    }

    public void computeSignature(CmsSigner signer, boolean silent) {
        if (!silent && signer.getCertificate() == null) {
            throw new NotSupportedException("This requires that the current process is running in user interactive mode. Try to use ComputeSignature(CmsSigner) method.");
        }
        this.computeSignature(signer);
    }

    private static byte[] a(X509Certificate x509Certificate) {
        X509Extension x509Extension = x509Certificate.getExtensions().get_Item("2.5.29.14");
        if (x509Extension != null) {
            ASN1 aSN1 = new ASN1(x509Extension.getValue().getValue());
            return aSN1.getValue();
        }
        ASN1 aSN1 = new ASN1(48);
        ASN1 aSN12 = aSN1.add(new ASN1(48));
        aSN12.add(new ASN1(CryptoConfig.encodeOID(x509Certificate.getKeyAlgorithm())));
        aSN12.add(new ASN1(x509Certificate.getKeyAlgorithmParameters()));
        byte[] byArray = x509Certificate.getPublicKey();
        byte[] byArray2 = new byte[byArray.length + 1];
        Array.copy(Array.boxing(byArray), 0, Array.boxing(byArray2), 1, byArray.length);
        aSN1.add(new ASN1(3, byArray2));
        SHA1 sHA1 = SHA1.create();
        return sHA1.computeHash(aSN1.getBytes());
    }

    public void decode(byte[] encodedMessage) {
        if (encodedMessage == null) {
            throw new ArgumentNullException("encodedMessage");
        }
        try {
            this.h = new CMSSignedData(encodedMessage);
            Hashtable hashtable = new Hashtable();
            this.b = this.h.getSignedContent() == null;
            this.a = this.b ? new ContentInfo(new Oid(this.h.getSignedContent().getContentType().getId()), new byte[0]) : new ContentInfo(new Oid(this.h.getSignedContentTypeOID()), (byte[])this.h.getSignedContent().getContent());
            this.f = this.h.getVersion();
            Store<X509CertificateHolder> store = this.h.getCertificates();
            Collection<X509CertificateHolder> collection = store.getMatches(null);
            X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
            for (X509CertificateHolder object : collection) {
                X509Certificate2 x509Certificate2 = new X509Certificate2(object.getEncoded());
                hashtable.addItem(x509Certificate2, new X509Certificate(object.getEncoded()));
                x509Certificate2Collection.add(x509Certificate2);
            }
            this.d = x509Certificate2Collection;
            this.c = new SignerInfoCollection();
            Object object = x509Certificate2Collection.get_Item(0);
            for (SignerInformation signerInformation : this.h.getSignerInfos().getSigners()) {
                SubjectIdentifier subjectIdentifier = com.aspose.html.internal.ms.core.bc.security.a.a(signerInformation.getSID());
                object = this.a(hashtable, x509Certificate2Collection, subjectIdentifier, (X509Certificate2)object);
                if (object == null) {
                    throw new CryptographicException("Certificate was not found");
                }
                SignerInfoCollection signerInfoCollection = new SignerInfoCollection();
                SignerInfo signerInfo = new SignerInfo(subjectIdentifier, (X509Certificate2)object, new Oid(signerInformation.getDigestAlgOID()), signerInfoCollection, com.aspose.html.internal.ms.core.bc.security.a.a(signerInformation.getSignedAttributes()), com.aspose.html.internal.ms.core.bc.security.a.a(signerInformation.getUnsignedAttributes()), signerInformation.getVersion(), signerInformation);
                this.c.add(signerInfo);
            }
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    private X509Certificate2 a(Iterable<DictionaryEntry> iterable, Iterable<X509Certificate2> iterable2, SubjectIdentifier subjectIdentifier, X509Certificate2 x509Certificate2) {
        block3: {
            block2: {
                X509Certificate2 x509Certificate22 = x509Certificate2;
                if (subjectIdentifier.getType() != 1) break block2;
                for (X509Certificate2 x509Certificate23 : iterable2) {
                    if (!StringExtensions.equals(x509Certificate23.get_IssuerName().getName(), Operators.unboxing(subjectIdentifier.getValue(), X509IssuerSerial.class).getIssuerName()) || !StringExtensions.equals(x509Certificate23.get_SerialNumber(), Operators.unboxing(subjectIdentifier.getValue(), X509IssuerSerial.class).getSerialNumber())) continue;
                    return x509Certificate23;
                }
                break block3;
            }
            if (subjectIdentifier.getType() != 2) break block3;
            for (DictionaryEntry dictionaryEntry : iterable) {
                if (!StringExtensions.equals(SignedCms.toString(SignedCms.a((X509Certificate)dictionaryEntry.getValue()), false), (String)subjectIdentifier.getValue())) continue;
                return (X509Certificate2)dictionaryEntry.getKey();
            }
        }
        return x509Certificate2;
    }

    public static String toString(byte[] array, boolean reverse) {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (reverse) {
            for (int i2 = array.length - 1; i2 >= 0; --i2) {
                msStringBuilder2.append(ByteExtensions.toString(array[i2], "X2"));
            }
        } else {
            for (int i3 = 0; i3 < array.length; ++i3) {
                msStringBuilder2.append(ByteExtensions.toString(array[i3], "X2"));
            }
        }
        return msStringBuilder2.toString();
    }

    public byte[] encode() {
        if (this.h == null) {
            throw new NullReferenceException();
        }
        try {
            return this.h.getEncoded();
        }
        catch (Exception exception) {
            throw new CryptographicException(exception.getMessage());
        }
    }

    public void removeSignature(SignerInfo signerInfo) {
        if (signerInfo == null) {
            throw new ArgumentNullException("signerInfo");
        }
        SignerInfoCollection signerInfoCollection = new SignerInfoCollection();
        for (Object object5 : this.c) {
            if (object5.equals(signerInfo)) continue;
            signerInfoCollection.add((SignerInfo)object5);
        }
        this.c = signerInfoCollection;
        this.g = new CMSSignedDataGenerator();
        java.util.ArrayList arrayList = new java.util.ArrayList();
        for (Object object : signerInfoCollection) {
            Object object2;
            CmsSigner object3 = new CmsSigner(((SignerInfo)object).getSignerIdentifier().getType(), ((SignerInfo)object).getCertificate());
            X509Certificate2 x509Certificate2 = object3.getCertificate();
            if (x509Certificate2.getPrivateKey() == null) {
                object2 = new X509Store();
                ((X509Store)object2).open(0);
                for (Object object4 : ((X509Store)object2).getCertificates()) {
                    X509Certificate2 x509Certificate22;
                    if (!(object4 instanceof X509Certificate2) || !x509Certificate2.equals(x509Certificate22 = (X509Certificate2)object4) || x509Certificate22.getPrivateKey() == null) continue;
                    x509Certificate2 = x509Certificate22;
                    break;
                }
                ((X509Store)object2).close();
            }
            object2 = com.aspose.html.internal.ms.core.bc.security.a.a(x509Certificate2);
            try {
                Object object4;
                ContentSigner contentSigner = this.a(x509Certificate2, x509Certificate2.getPrivateKey());
                object4 = this.a(object3).build(contentSigner, (X509CertificateHolder)object2);
                this.g.addSignerInfoGenerator((SignerInfoGenerator)object4);
            }
            catch (Exception exception) {
                throw new CryptographicException(exception.getMessage());
            }
            arrayList.add(object2);
        }
        if (this.h != null) {
            Object object;
            Object object5;
            object5 = this.h.getCertificates();
            for (X509CertificateHolder x509CertificateHolder : object5.getMatches(null)) {
                if (arrayList.contains(x509CertificateHolder)) continue;
                arrayList.add(x509CertificateHolder);
            }
            object = new CollectionStore(arrayList);
            try {
                this.g.addCertificates((Store)object);
            }
            catch (CMSException cMSException) {
                throw new CryptographicException(cMSException.getMessage());
            }
        }
        try {
            this.h = this.g.generate(new CMSProcessableByteArray(this.a.getContent()), !this.b);
        }
        catch (CMSException cMSException) {
            throw new CryptographicException(cMSException.getMessage());
        }
    }

    public void removeSignature(int index) {
        if (index < 0 || index >= this.c.size()) {
            throw new ArgumentException("index was out of range");
        }
        this.removeSignature(this.c.get_Item(index));
    }
}

