/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class HashAlgorithm
implements ICryptoTransform {
    byte[] b;
    protected int HashSizeValue;
    protected int State;
    private boolean a = false;

    protected HashAlgorithm() {
    }

    @Override
    public boolean canTransformMultipleBlocks() {
        return true;
    }

    @Override
    public boolean canReuseTransform() {
        return true;
    }

    public void clear() {
        this.dispose(true);
    }

    public byte[] computeHash(byte[] buffer) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        return this.computeHash(buffer, 0, buffer.length);
    }

    public byte[] computeHash(byte[] buffer, int offset, int count) {
        if (this.a) {
            throw new ObjectDisposedException("HashAlgorithm");
        }
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (offset < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (count < 0) {
            throw new ArgumentException("count", "< 0");
        }
        if (offset > buffer.length - count) {
            throw new ArgumentException("offset + count", n.a("Overflow"));
        }
        this.hashCore(buffer, offset, count);
        this.b = this.hashFinal();
        this.initialize();
        return this.b;
    }

    public byte[] computeHash(Stream inputStream) {
        if (this.a) {
            throw new ObjectDisposedException("HashAlgorithm");
        }
        byte[] byArray = new byte[4096];
        int n2 = inputStream.read(byArray, 0, 4096);
        while (n2 > 0) {
            this.hashCore(byArray, 0, n2);
            n2 = inputStream.read(byArray, 0, 4096);
        }
        this.b = this.hashFinal();
        this.initialize();
        return this.b;
    }

    public static HashAlgorithm create() {
        return HashAlgorithm.create("System.Security.Cryptography.HashAlgorithm");
    }

    public static HashAlgorithm create(String hashName) {
        return (HashAlgorithm)CryptoConfig.createFromName(hashName);
    }

    public byte[] getHash() {
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException(n.a("No hash value computed."));
        }
        return this.b;
    }

    protected abstract void hashCore(byte[] var1, int var2, int var3);

    protected abstract byte[] hashFinal();

    public int getHashSize() {
        return this.HashSizeValue;
    }

    public abstract void initialize();

    protected void dispose(boolean disposing) {
        this.a = true;
    }

    @Override
    public int getInputBlockSize() {
        return 1;
    }

    @Override
    public int getOutputBlockSize() {
        return 1;
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    @Override
    public int transformBlock(byte[] inputBuffer, int inputOffset, int inputCount, byte[] outputBuffer, int outputOffset) {
        if (inputBuffer == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (inputOffset < 0) {
            throw new ArgumentOutOfRangeException("inputOffset", "< 0");
        }
        if (inputCount < 0) {
            throw new ArgumentException("inputCount");
        }
        if (inputOffset < 0 || inputOffset > inputBuffer.length - inputCount) {
            throw new ArgumentException("inputBuffer");
        }
        if (outputBuffer != null) {
            if (outputOffset < 0) {
                throw new ArgumentOutOfRangeException("outputOffset", "< 0");
            }
            if (outputOffset > outputBuffer.length - inputCount) {
                throw new ArgumentException("outputOffset + inputCount", n.a("Overflow"));
            }
        }
        this.hashCore(inputBuffer, inputOffset, inputCount);
        if (outputBuffer != null) {
            Buffer.blockCopy(Array.boxing(inputBuffer), inputOffset, Array.boxing(outputBuffer), outputOffset, inputCount);
        }
        return inputCount;
    }

    @Override
    public byte[] transformFinalBlock(byte[] inputBuffer, int inputOffset, int inputCount) {
        if (inputBuffer == null) {
            throw new ArgumentNullException("inputBuffer");
        }
        if (inputCount < 0) {
            throw new ArgumentException("inputCount");
        }
        if (inputOffset > inputBuffer.length - inputCount) {
            throw new ArgumentException("inputOffset + inputCount", n.a("Overflow"));
        }
        byte[] byArray = new byte[inputCount];
        Buffer.blockCopy(Array.boxing(inputBuffer), inputOffset, Array.boxing(byArray), 0, inputCount);
        this.hashCore(inputBuffer, inputOffset, inputCount);
        this.b = this.hashFinal();
        this.initialize();
        return byArray;
    }

    public String toString() {
        String string = ObjectExtensions.getType(this).getName().substring(ObjectExtensions.getType(this).getName().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

