/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.EventArgs;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspKeyContainerInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICspAsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.e;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.f;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.m;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public final class DSACryptoServiceProvider
extends DSA
implements ICspAsymmetricAlgorithm {
    private static final int a = 13;
    private m b;
    private boolean c;
    private boolean d;
    private boolean e = true;
    private boolean f;
    private f g;

    public DSACryptoServiceProvider() {
        this(1024, null);
    }

    public DSACryptoServiceProvider(CspParameters parameters) {
        this(1024, parameters);
    }

    public DSACryptoServiceProvider(int dwKeySize) {
        this(dwKeySize, null);
    }

    public DSACryptoServiceProvider(int dwKeySize, CspParameters parameters) {
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(512, 1024, 64);
        this.setKeySize(dwKeySize);
        this.g = new f(dwKeySize);
        this.g.a.add(new f.a(){

            @Override
            public void a(Object object, EventArgs eventArgs) {
                DSACryptoServiceProvider.this.a(object, eventArgs);
            }
        });
        boolean bl2 = this.c = parameters != null;
        if (parameters == null) {
            parameters = new CspParameters(13);
            this.b = new m(parameters);
        } else {
            this.b = new m(parameters);
            this.b.d();
            if (this.b.b() != null) {
                this.d = true;
                this.fromXmlString(this.b.b());
            }
        }
    }

    @Override
    public String getKeyExchangeAlgorithm() {
        return null;
    }

    @Override
    public int getKeySize() {
        return this.g.getKeySize();
    }

    public boolean getPersistKeyInCsp() {
        return this.c;
    }

    public void setPersistKeyInCsp(boolean value) {
        this.c = value;
    }

    public boolean getPublicOnly() {
        return this.g.a();
    }

    @Override
    public String getSignatureAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    }

    @Override
    public DSAParameters exportParameters(boolean includePrivateParameters) {
        if (includePrivateParameters && !this.e) {
            throw new CryptographicException(n.a("Cannot export private key"));
        }
        return this.g.exportParameters(includePrivateParameters);
    }

    @Override
    public void importParameters(DSAParameters parameters) {
        this.g.importParameters(parameters.Clone());
    }

    @Override
    public byte[] createSignature(byte[] rgbHash) {
        return this.g.createSignature(rgbHash);
    }

    public byte[] signData(byte[] buffer) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray = sHA1.computeHash(buffer);
        return this.g.createSignature(byArray);
    }

    public byte[] signData(byte[] buffer, int offset, int count) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray = sHA1.computeHash(buffer, offset, count);
        return this.g.createSignature(byArray);
    }

    public byte[] signData(Stream inputStream) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray = sHA1.computeHash(inputStream);
        return this.g.createSignature(byArray);
    }

    public byte[] signHash(byte[] rgbHash, String str) {
        if (StringExtensions.compare(str, "SHA1", true, CultureInfo.getInvariantCulture()) != 0) {
            throw new CryptographicException(n.a("Only SHA1 is supported."));
        }
        return this.g.createSignature(rgbHash);
    }

    public boolean verifyData(byte[] rgbData, byte[] rgbSignature) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray = sHA1.computeHash(rgbData);
        return this.g.verifySignature(byArray, rgbSignature);
    }

    public boolean verifyHash(byte[] rgbHash, String str, byte[] rgbSignature) {
        if (str == null) {
            str = "SHA1";
        }
        if (StringExtensions.compare(str, "SHA1", true, CultureInfo.getInvariantCulture()) != 0) {
            throw new CryptographicException(n.a("Only SHA1 is supported."));
        }
        return this.g.verifySignature(rgbHash, rgbSignature);
    }

    @Override
    public boolean verifySignature(byte[] rgbHash, byte[] rgbSignature) {
        return this.g.verifySignature(rgbHash, rgbSignature);
    }

    @Override
    protected void dispose(boolean disposing) {
        if (!this.f) {
            if (this.d && !this.c) {
                this.b.f();
            }
            if (this.g != null) {
                this.g.clear();
            }
            this.f = true;
        }
    }

    private void a(Object object, EventArgs eventArgs) {
        if (this.c && !this.d) {
            this.b.a(this.toXmlString(!this.g.a()));
            this.b.e();
            this.d = true;
        }
    }

    @Override
    public CspKeyContainerInfo getCspKeyContainerInfo() {
        return null;
    }

    @Override
    public byte[] exportCspBlob(boolean includePrivateParameters) {
        byte[] byArray = null;
        byArray = includePrivateParameters ? com.aspose.html.internal.ms.core.System.Security.Cryptography.e.a(this) : com.aspose.html.internal.ms.core.System.Security.Cryptography.e.b(this);
        return byArray;
    }

    @Override
    public void importCspBlob(byte[] keyBlob) {
        if (keyBlob == null) {
            throw new ArgumentNullException("keyBlob");
        }
        DSA dSA = com.aspose.html.internal.ms.core.System.Security.Cryptography.e.f(keyBlob);
        if (dSA instanceof DSACryptoServiceProvider) {
            DSAParameters dSAParameters = dSA.exportParameters(!((DSACryptoServiceProvider)dSA).getPublicOnly()).Clone();
            this.importParameters(dSAParameters.Clone());
        } else {
            try {
                DSAParameters dSAParameters = dSA.exportParameters(true).Clone();
                this.importParameters(dSAParameters.Clone());
            }
            catch (Exception exception) {
                DSAParameters dSAParameters = dSA.exportParameters(false).Clone();
                this.importParameters(dSAParameters.Clone());
            }
        }
    }
}

