/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class AsymmetricAlgorithm
implements IDisposable {
    protected int KeySizeValue;
    protected KeySizes[] LegalKeySizesValue;

    protected AsymmetricAlgorithm() {
    }

    public abstract String getKeyExchangeAlgorithm();

    public int getKeySize() {
        return this.KeySizeValue;
    }

    public void setKeySize(int value) {
        if (!KeySizes.a(this.LegalKeySizesValue, value)) {
            throw new CryptographicException(n.a("Key size not supported by algorithm."));
        }
        this.KeySizeValue = value;
    }

    public KeySizes[] getLegalKeySizes() {
        return this.LegalKeySizesValue;
    }

    public abstract String getSignatureAlgorithm();

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void clear() {
        this.dispose(false);
    }

    protected abstract void dispose(boolean var1);

    public abstract void fromXmlString(String var1);

    public abstract String toXmlString(boolean var1);

    public static AsymmetricAlgorithm create() {
        return AsymmetricAlgorithm.create("System.Security.Cryptography.AsymmetricAlgorithm");
    }

    public static AsymmetricAlgorithm create(String algName) {
        return (AsymmetricAlgorithm)CryptoConfig.createFromName(algName);
    }

    static byte[] a(String string, String string2) {
        String string3 = "<" + string2 + ">";
        int n2 = string.indexOf(string3);
        if (n2 == -1) {
            return null;
        }
        String string4 = "</" + string2 + ">";
        int n3 = string.indexOf(string4);
        if (n3 == -1 || n3 <= n2) {
            return null;
        }
        String string5 = string.substring(n2 += string3.length(), n2 + (n3 - n2));
        return Convert.fromBase64String(string5);
    }

    public String toString() {
        String string = ObjectExtensions.getType(this).getName().substring(ObjectExtensions.getType(this).getName().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

