/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Runtime.Serialization;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.CLSCompliantAttribute;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.Hashtable;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Runtime.Serialization.FormatterConverter;
import com.aspose.html.internal.ms.System.Runtime.Serialization.IFormatterConverter;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationEntry;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationException;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationInfoEnumerator;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;

public final class SerializationInfo {
    private Hashtable a = new Hashtable();
    private ArrayList b = new ArrayList();
    private String c;
    private String d;
    private IFormatterConverter e;

    private SerializationInfo(Type type) {
        this.c = type.getAssembly().getFullName();
        this.d = type.getFullName();
        this.e = new FormatterConverter();
    }

    private SerializationInfo(Type type, SerializationEntry[] data) {
        int n2 = data.length;
        this.c = type.getAssembly().getFullName();
        this.d = type.getFullName();
        this.e = new FormatterConverter();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a.addItem(data[i2].getName(), data[i2].Clone());
            this.b.addItem(data[i2].Clone());
        }
    }

    @CLSCompliantAttribute(isCompliant=false)
    public SerializationInfo(Type type, IFormatterConverter converter) {
        if (type == null) {
            throw new ArgumentNullException("type", "Null argument");
        }
        if (converter == null) {
            throw new ArgumentNullException("converter", "Null argument");
        }
        this.e = converter;
        this.c = type.getAssembly().getFullName();
        this.d = type.getFullName();
    }

    public String getAssemblyName() {
        return this.c;
    }

    public void setAssemblyName(String value) {
        if (value == null) {
            throw new ArgumentNullException("Argument is null.");
        }
        this.c = value;
    }

    public String getFullTypeName() {
        return this.d;
    }

    public void setFullTypeName(String value) {
        if (value == null) {
            throw new ArgumentNullException("Argument is null.");
        }
        this.d = value;
    }

    public int getMemberCount() {
        return this.a.size();
    }

    public void addValue(String name, Object value, Type type) {
        if (name == null) {
            throw new ArgumentNullException("name is null");
        }
        if (type == null) {
            throw new ArgumentNullException("type is null");
        }
        if (this.a.containsKey(name)) {
            throw new SerializationException("Value has been serialized already.");
        }
        SerializationEntry serializationEntry = new SerializationEntry(name, type, value);
        this.a.addItem(name, serializationEntry.Clone());
        this.b.addItem(serializationEntry.Clone());
    }

    public Object getValue(String name, Type type) {
        if (name == null) {
            throw new ArgumentNullException("name is null.");
        }
        if (type == null) {
            throw new ArgumentNullException("type");
        }
        if (!this.a.containsKey(name)) {
            throw new SerializationException(StringExtensions.concat("No element named ", name, " could be found."));
        }
        SerializationEntry serializationEntry = ((SerializationEntry)this.a.get_Item(name)).Clone();
        if (serializationEntry.getValue() != null && !type.isInstanceOfType(serializationEntry.getValue())) {
            return this.e.convert(serializationEntry.getValue(), type);
        }
        return serializationEntry.getValue();
    }

    boolean a(String string) {
        return this.a.get_Item(string) != null;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new ArgumentNullException("type is null.");
        }
        this.d = type.getFullName();
        this.c = type.getAssembly().getFullName();
    }

    public SerializationInfoEnumerator iterator() {
        return new SerializationInfoEnumerator(this.b);
    }

    public void addValue(String name, short value) {
        this.addValue(name, value, Operators.typeOf(Short.TYPE));
    }

    public void addValue(String name, int value) {
        this.addValue(name, value, Operators.typeOf(Integer.TYPE));
    }

    public void addValue(String name, byte value) {
        this.addValue(name, value, Operators.typeOf(Byte.TYPE));
    }

    public void addValue(String name, boolean value) {
        this.addValue(name, value, Operators.typeOf(Boolean.TYPE));
    }

    public void addValue(String name, char value) {
        this.addValue(name, Character.valueOf(value), Operators.typeOf(Character.TYPE));
    }

    public void addValue(String name, double value) {
        this.addValue(name, value, Operators.typeOf(Double.TYPE));
    }

    public void addValue(String name, Decimal value) {
        this.addValue(name, value, Operators.typeOf(Decimal.class));
    }

    public void addValue(String name, DateTime value) {
        this.addValue(name, value.Clone(), Operators.typeOf(DateTime.class));
    }

    public void addValue(String name, float value) {
        this.addValue(name, Float.valueOf(value), Operators.typeOf(Float.TYPE));
    }

    public void addValue(String name, long value) {
        this.addValue(name, value, Operators.typeOf(Long.TYPE));
    }

    public void addValue(String name, Object value) {
        if (value == null) {
            this.addValue(name, value, Operators.typeOf(Object.class));
        } else {
            this.addValue(name, value, ObjectExtensions.getType(value));
        }
    }

    public boolean getBoolean(String name) {
        Object object = this.getValue(name, Operators.typeOf(Boolean.TYPE));
        return this.e.toBoolean(object);
    }

    public byte getByte(String name) {
        Object object = this.getValue(name, Operators.typeOf(Byte.TYPE));
        return this.e.toByte(object);
    }

    public char getChar(String name) {
        Object object = this.getValue(name, Operators.typeOf(Character.TYPE));
        return this.e.toChar(object);
    }

    public DateTime getDateTime(String name) {
        Object object = this.getValue(name, Operators.typeOf(DateTime.class));
        return this.e.toDateTime(object);
    }

    public Decimal getDecimal(String name) {
        Object object = this.getValue(name, Operators.typeOf(Decimal.class));
        return this.e.toDecimal(object);
    }

    public double getDouble(String name) {
        Object object = this.getValue(name, Operators.typeOf(Double.TYPE));
        return this.e.toDouble(object);
    }

    public short getInt16(String name) {
        Object object = this.getValue(name, Operators.typeOf(Short.TYPE));
        return this.e.toInt16(object);
    }

    public int getInt32(String name) {
        Object object = this.getValue(name, Operators.typeOf(Integer.TYPE));
        return this.e.toInt32(object);
    }

    public long getInt64(String name) {
        Object object = this.getValue(name, Operators.typeOf(Long.TYPE));
        return this.e.toInt64(object);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public byte getSByte(String name) {
        Object object = this.getValue(name, Operators.typeOf(Byte.TYPE));
        return this.e.toSByte(object);
    }

    public float getSingle(String name) {
        Object object = this.getValue(name, Operators.typeOf(Float.TYPE));
        return this.e.toSingle(object);
    }

    public String getString(String name) {
        Object object = this.getValue(name, Operators.typeOf(String.class));
        if (object == null) {
            return null;
        }
        return this.e.toString(object);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public int getUInt16(String name) {
        Object object = this.getValue(name, Operators.typeOf(Integer.TYPE));
        return this.e.toUInt16(object);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public long getUInt32(String name) {
        Object object = this.getValue(name, Operators.typeOf(Long.TYPE));
        return this.e.toUInt32(object);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public long getUInt64(String name) {
        Object object = this.getValue(name, Operators.typeOf(Long.TYPE));
        return this.e.toUInt64(object);
    }
}

