/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Sockets;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.Net.Dns;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.Net.IPEndPoint;
import com.aspose.html.internal.ms.System.Net.Sockets.LingerOption;
import com.aspose.html.internal.ms.System.Net.Sockets.NetworkStream;
import com.aspose.html.internal.ms.System.Net.Sockets.Socket;
import com.aspose.html.internal.ms.System.Net.Sockets.SocketException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class TcpClient
implements IDisposable {
    private NetworkStream a;
    private boolean b;
    private Socket c;
    private boolean d;
    private long e;
    private int f;
    private int g;
    private int h;
    private int i;
    private LingerOption j;
    private boolean k;

    private void a(int n2) {
        this.b = false;
        if (this.c != null) {
            this.c.close();
            this.c = null;
        }
        this.c = new Socket(n2, 1, 6);
    }

    public TcpClient() {
        this.a(2);
        this.c.bind(new IPEndPoint(IPAddress.Any, 0));
    }

    TcpClient(Socket s2) {
        this.c = s2;
    }

    public TcpClient(int family) {
        if (family != 2 && family != 23) {
            throw new ArgumentException("Family must be InterNetwork or InterNetworkV6", "family");
        }
        this.a(family);
        IPAddress iPAddress = IPAddress.Any;
        if (family == 23) {
            iPAddress = IPAddress.IPv6Any;
        }
        this.c.bind(new IPEndPoint(iPAddress, 0));
    }

    public TcpClient(IPEndPoint localEP) {
        this.a(localEP.getAddressFamily());
        this.c.bind(localEP);
    }

    public TcpClient(String hostname, int port) {
        this.connect(hostname, port);
    }

    protected boolean getActive() {
        return this.b;
    }

    protected void setActive(boolean value) {
        this.b = value;
    }

    public Socket getClient() {
        return this.c;
    }

    public void setClient(Socket value) {
        this.c = value;
        this.a = null;
    }

    public int getAvailable() {
        return this.c.getAvailable();
    }

    public boolean getConnected() {
        return this.c.getConnected();
    }

    public boolean getExclusiveAddressUse() {
        return this.c.getExclusiveAddressUse();
    }

    public void setExclusiveAddressUse(boolean value) {
        this.c.setExclusiveAddressUse(value);
    }

    public LingerOption getLingerState() {
        if ((this.e & Properties.a) != 0L) {
            return this.j;
        }
        return (LingerOption)this.c.getSocketOption(65535, 128);
    }

    public void setLingerState(LingerOption value) {
        if (!this.c.getConnected()) {
            this.j = value;
            this.e |= Properties.a;
            return;
        }
        this.c.setSocketOption(65535, 128, value);
    }

    public boolean getNoDelay() {
        if ((this.e & Properties.b) != 0L) {
            return this.k;
        }
        return (Boolean)this.c.getSocketOption(6, 1);
    }

    public void setNoDelay(boolean value) {
        if (!this.c.getConnected()) {
            this.k = value;
            this.e |= Properties.b;
            return;
        }
        this.c.setSocketOption(6, 1, value ? 1 : 0);
    }

    public int getReceiveBufferSize() {
        if ((this.e & Properties.c) != 0L) {
            return this.h;
        }
        return (Integer)this.c.getSocketOption(65535, 4098);
    }

    public void setReceiveBufferSize(int value) {
        if (!this.c.getConnected()) {
            this.h = value;
            this.e |= Properties.c;
            return;
        }
        this.c.setSocketOption(65535, 4098, value);
    }

    public int getReceiveTimeout() {
        if ((this.e & Properties.d) != 0L) {
            return this.f;
        }
        return (Integer)this.c.getSocketOption(65535, 4102);
    }

    public void setReceiveTimeout(int value) {
        if (!this.c.getConnected()) {
            this.f = value;
            this.e |= Properties.d;
            return;
        }
        this.c.setSocketOption(65535, 4102, value);
    }

    public int getSendBufferSize() {
        if ((this.e & Properties.e) != 0L) {
            return this.i;
        }
        return (Integer)this.c.getSocketOption(65535, 4097);
    }

    public void setSendBufferSize(int value) {
        if (!this.c.getConnected()) {
            this.i = value;
            this.e |= Properties.e;
            return;
        }
        this.c.setSocketOption(65535, 4097, value);
    }

    public int getSendTimeout() {
        if ((this.e & Properties.f) != 0L) {
            return this.g;
        }
        return (Integer)this.c.getSocketOption(65535, 4101);
    }

    public void setSendTimeout(int value) {
        if (!this.c.getConnected()) {
            this.g = value;
            this.e |= Properties.f;
            return;
        }
        this.c.setSocketOption(65535, 4101, value);
    }

    public void close() {
        this.dispose();
    }

    public void connect(IPEndPoint remoteEP) {
        try {
            this.c.connect(remoteEP);
            this.b = true;
        }
        finally {
            this.b();
        }
    }

    public void connect(IPAddress address, int port) {
        this.connect(new IPEndPoint(address, port));
    }

    private void a() {
        long l2 = this.e;
        this.e = 0L;
        if ((l2 & Properties.a) != 0L) {
            this.setLingerState(this.j);
        }
        if ((l2 & Properties.b) != 0L) {
            this.setNoDelay(this.k);
        }
        if ((l2 & Properties.c) != 0L) {
            this.setReceiveBufferSize(this.h);
        }
        if ((l2 & Properties.d) != 0L) {
            this.setReceiveTimeout(this.f);
        }
        if ((l2 & Properties.e) != 0L) {
            this.setSendBufferSize(this.i);
        }
        if ((l2 & Properties.f) != 0L) {
            this.setSendTimeout(this.g);
        }
    }

    public void connect(String hostname, int port) {
        IPAddress[] iPAddressArray = Dns.getHostAddresses(hostname);
        this.connect(iPAddressArray, port);
    }

    public void connect(IPAddress[] ipAddresses, int port) {
        this.b();
        if (ipAddresses == null) {
            throw new ArgumentNullException("ipAddresses");
        }
        for (int i2 = 0; i2 < Array.boxing(ipAddresses).getLength(); ++i2) {
            try {
                IPAddress iPAddress = ipAddresses[i2];
                if (iPAddress.equals(IPAddress.Any) || iPAddress.equals(IPAddress.IPv6Any)) {
                    throw new SocketException(10049);
                }
                this.a(iPAddress.getAddressFamily());
                if (iPAddress.getAddressFamily() == 2) {
                    this.c.bind(new IPEndPoint(IPAddress.Any, 0));
                } else if (iPAddress.getAddressFamily() == 23) {
                    this.c.bind(new IPEndPoint(IPAddress.IPv6Any, 0));
                } else {
                    throw new NotSupportedException("This method is only valid for sockets in the InterNetwork and InterNetworkV6 families");
                }
                this.connect(new IPEndPoint(iPAddress, port));
                if (this.e == 0L) break;
                this.a();
                break;
            }
            catch (RuntimeException runtimeException) {
                this.a(2);
                if (i2 != Array.boxing(ipAddresses).getLength() - 1) continue;
                throw runtimeException;
            }
        }
    }

    public void endConnect(IAsyncResult asyncResult) {
        this.c.endConnect(asyncResult);
    }

    public IAsyncResult beginConnect(IPAddress address, int port, AsyncCallback requestCallback, Object state) {
        return this.c.beginConnect(address, port, requestCallback, state);
    }

    public IAsyncResult beginConnect(IPAddress[] addresses, int port, AsyncCallback requestCallback, Object state) {
        return this.c.beginConnect(addresses, port, requestCallback, state);
    }

    public IAsyncResult beginConnect(String host, int port, AsyncCallback requestCallback, Object state) {
        return this.c.beginConnect(host, port, requestCallback, state);
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    protected void dispose(boolean disposing) {
        if (this.d) {
            return;
        }
        this.d = true;
        if (disposing) {
            NetworkStream networkStream = this.a;
            this.a = null;
            if (networkStream != null) {
                networkStream.close();
                this.b = false;
                networkStream = null;
            } else if (this.c != null) {
                this.c.close();
                this.c = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
        super.finalize();
    }

    public NetworkStream getStream() {
        try {
            if (this.a == null) {
                this.a = new NetworkStream(this.c, true);
            }
            NetworkStream networkStream = this.a;
            return networkStream;
        }
        finally {
            this.b();
        }
    }

    private void b() {
        if (this.d) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).getFullName());
        }
    }

    private static final class Properties
    extends Enum {
        public static final long a = Operators.castToUInt32(1, 9);
        public static final long b = Operators.castToUInt32(2, 9);
        public static final long c = Operators.castToUInt32(4, 9);
        public static final long d = Operators.castToUInt32(8, 9);
        public static final long e = Operators.castToUInt32(16, 9);
        public static final long f = Operators.castToUInt32(32, 9);

        private Properties() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)Properties.class, Long.class){
                {
                    this.addConstant("LingerState", a);
                    this.addConstant("NoDelay", b);
                    this.addConstant("ReceiveBufferSize", c);
                    this.addConstant("ReceiveTimeout", d);
                    this.addConstant("SendBufferSize", e);
                    this.addConstant("SendTimeout", f);
                }
            });
        }
    }
}

