/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Net.EndPoint;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.Net.SocketAddress;
import com.aspose.html.internal.ms.System.Net.Sockets.AddressFamily;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

@SerializableAttribute
public class IPEndPoint
extends EndPoint {
    private IPAddress a;
    private int b;
    public static final int MaxPort = 65535;
    public static final int MinPort = 0;

    public IPEndPoint(IPAddress address, int port) {
        if (address == null) {
            throw new ArgumentNullException("address");
        }
        this.setAddress(address);
        this.setPort(port);
    }

    public IPEndPoint(long address, int port) {
        this.setAddress(new IPAddress(address));
        this.setPort(port);
    }

    public IPAddress getAddress() {
        return this.a;
    }

    public void setAddress(IPAddress value) {
        this.a = value;
    }

    @Override
    public int getAddressFamily() {
        return this.a.getAddressFamily();
    }

    public int getPort() {
        return this.b;
    }

    public void setPort(int value) {
        if (value < 0 || value > 65535) {
            throw new ArgumentOutOfRangeException("Invalid port");
        }
        this.b = value;
    }

    @Override
    public EndPoint create(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new ArgumentNullException("socketAddress");
        }
        if (socketAddress.getFamily() != this.getAddressFamily()) {
            throw new ArgumentException(StringExtensions.concat("The IPEndPoint was created using ", Enum.getName(AddressFamily.class, this.getAddressFamily()), " AddressFamily but SocketAddress contains ", Enum.getName(AddressFamily.class, socketAddress.getFamily()), " instead, please use the same type."));
        }
        SocketAddress socketAddress2 = socketAddress;
        int n2 = socketAddress2.getSize();
        int n3 = socketAddress2.getFamily();
        IPEndPoint iPEndPoint = null;
        switch (n3) {
            case 2: {
                if (n2 < 8) {
                    return null;
                }
                int n4 = (Operators.castToInt32(socketAddress2.get_Item(2), 6) << 8) + Operators.castToInt32(socketAddress2.get_Item(3), 6);
                long l2 = (Operators.castToInt64(socketAddress2.get_Item(7), 6) << 24) + (Operators.castToInt64(socketAddress2.get_Item(6), 6) << 16) + (Operators.castToInt64(socketAddress2.get_Item(5), 6) << 8) + Operators.castToInt64(socketAddress2.get_Item(4), 6);
                iPEndPoint = new IPEndPoint(l2, n4);
                break;
            }
            case 23: {
                if (n2 < 28) {
                    return null;
                }
                int n5 = (Operators.castToInt32(socketAddress2.get_Item(2), 6) << 8) + Operators.castToInt32(socketAddress2.get_Item(3), 6);
                int n6 = Operators.castToInt32(socketAddress2.get_Item(24), 6) + (Operators.castToInt32(socketAddress2.get_Item(25), 6) << 8) + (Operators.castToInt32(socketAddress2.get_Item(26), 6) << 16) + (Operators.castToInt32(socketAddress2.get_Item(27), 6) << 24);
                int[] nArray = new int[8];
                for (int i2 = 0; i2 < 8; ++i2) {
                    nArray[i2] = Operators.castToUInt16((Operators.castToInt32(socketAddress2.get_Item(8 + i2 * 2), 6) << 8) + Operators.castToInt32(socketAddress2.get_Item(8 + i2 * 2 + 1), 6), 9);
                }
                iPEndPoint = new IPEndPoint(new IPAddress(nArray, Operators.castToInt64(n6, 9)), n5);
                break;
            }
            default: {
                return null;
            }
        }
        return iPEndPoint;
    }

    @Override
    public SocketAddress serialize() {
        SocketAddress socketAddress = null;
        switch (this.a.getAddressFamily()) {
            case 2: {
                socketAddress = new SocketAddress(2, 16);
                socketAddress.set_Item(2, Operators.castToByte(this.b >> 8 & 0xFF, 9));
                socketAddress.set_Item(3, Operators.castToByte(this.b & 0xFF, 9));
                long l2 = this.a.getAddress();
                socketAddress.set_Item(4, Operators.castToByte(l2 & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(5, Operators.castToByte(l2 >> 8 & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(6, Operators.castToByte(l2 >> 16 & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(7, Operators.castToByte(l2 >> 24 & Operators.castToInt64(255, 9), 11));
                break;
            }
            case 23: {
                socketAddress = new SocketAddress(23, 28);
                socketAddress.set_Item(2, Operators.castToByte(this.b >> 8 & 0xFF, 9));
                socketAddress.set_Item(3, Operators.castToByte(this.b & 0xFF, 9));
                byte[] byArray = this.a.getAddressBytes();
                for (int i2 = 0; i2 < 16; ++i2) {
                    socketAddress.set_Item(8 + i2, byArray[i2]);
                }
                socketAddress.set_Item(24, Operators.castToByte(this.a.getScopeId() & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(25, Operators.castToByte(this.a.getScopeId() >> 8 & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(26, Operators.castToByte(this.a.getScopeId() >> 16 & Operators.castToInt64(255, 9), 11));
                socketAddress.set_Item(27, Operators.castToByte(this.a.getScopeId() >> 24 & Operators.castToInt64(255, 9), 11));
            }
        }
        return socketAddress;
    }

    public String toString() {
        return StringExtensions.concat(this.a.toString(), ":", Int32Extensions.toString(this.b));
    }

    public boolean equals(Object comparand) {
        IPEndPoint iPEndPoint = Operators.as(comparand, IPEndPoint.class);
        return iPEndPoint != null && iPEndPoint.b == this.b && iPEndPoint.a.equals(this.a);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b;
    }
}

