/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IFormattable;
import com.aspose.html.internal.ms.System.ParseNumbers;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.ValueType;
import java.util.UUID;

public final class Guid
extends ValueType<Guid>
implements IFormattable,
Comparable<Guid> {
    public static final Guid Empty = new Guid();
    private int a;
    private short b;
    private short c;
    private byte d;
    private byte e;
    private byte f;
    private byte g;
    private byte h;
    private byte i;
    private byte j;
    private byte k;

    public Guid(byte[] b2) {
        if (b2 == null) {
            throw new ArgumentNullException("b");
        }
        if (b2.length != 16) {
            throw new ArgumentException("Guid array ctor: b length should be 16.");
        }
        this.a = b2[3] << 24 | (b2[2] & 0xFF) << 16 | (b2[1] & 0xFF) << 8 | b2[0] & 0xFF;
        this.b = (short)(b2[5] << 8 | b2[4] & 0xFF);
        this.c = (short)(b2[7] << 8 | b2[6] & 0xFF);
        this.d = b2[8];
        this.e = b2[9];
        this.f = b2[10];
        this.g = b2[11];
        this.h = b2[12];
        this.i = b2[13];
        this.j = b2[14];
        this.k = b2[15];
    }

    public Guid(long a2, int b2, int c2, short d2, short e2, short f2, short g2, short h2, short i2, short j2, short k2) {
        this.a = (int)a2;
        this.b = (short)b2;
        this.c = (short)c2;
        this.d = (byte)d2;
        this.e = (byte)e2;
        this.f = (byte)f2;
        this.g = (byte)g2;
        this.h = (byte)h2;
        this.i = (byte)i2;
        this.j = (byte)j2;
        this.k = (byte)k2;
    }

    public Guid(int a2, int b2, int c2, int d2, int e2, int f2, int g2, int h2, int i2, int j2, int k2) {
        this.a = a2;
        this.b = (short)b2;
        this.c = (short)c2;
        this.d = (byte)d2;
        this.e = (byte)e2;
        this.f = (byte)f2;
        this.g = (byte)g2;
        this.h = (byte)h2;
        this.i = (byte)i2;
        this.j = (byte)j2;
        this.k = (byte)k2;
    }

    public Guid() {
        this.a = 0;
        this.b = 0;
        this.c = 0;
        this.d = 0;
        this.e = 0;
        this.f = 0;
        this.g = 0;
        this.h = 0;
        this.i = 0;
        this.j = 0;
        this.k = 0;
    }

    public static Guid fromJava(UUID uuid) {
        if (uuid == null) {
            return new Guid();
        }
        long l2 = uuid.getMostSignificantBits();
        long l3 = uuid.getLeastSignificantBits();
        return new Guid(l2, l3);
    }

    public static UUID toJava(Guid guid) {
        if (guid == null) {
            return null;
        }
        long l2 = (long)guid.a << 32;
        l2 |= ((long)guid.b & 0xFFFFL) << 16;
        l2 |= (long)guid.c & 0xFFFFL;
        long l3 = ((long)guid.d & 0xFFL) << 56;
        l3 |= ((long)guid.e & 0xFFL) << 48;
        l3 |= ((long)guid.f & 0xFFL) << 40;
        l3 |= ((long)guid.g & 0xFFL) << 32;
        l3 |= ((long)guid.h & 0xFFL) << 24;
        l3 |= ((long)guid.i & 0xFFL) << 16;
        l3 |= ((long)guid.j & 0xFFL) << 8;
        return new UUID(l2, l3 |= (long)guid.k & 0xFFL);
    }

    public Guid(long msb, long lsb) {
        this.a = (int)(msb >> 32);
        this.b = (short)(msb >> 16);
        this.c = (short)msb;
        this.d = (byte)(lsb >> 56);
        this.e = (byte)(lsb >> 48);
        this.f = (byte)(lsb >> 40);
        this.g = (byte)(lsb >> 32);
        this.h = (byte)(lsb >> 24);
        this.i = (byte)(lsb >> 16);
        this.j = (byte)(lsb >> 8);
        this.k = (byte)lsb;
    }

    public Guid(String g2) {
        if (g2 == null) {
            throw new NullPointerException("g");
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        try {
            long l2;
            int n3;
            if (g2.indexOf(45, 0) < 0 && g2.length() == 32) {
                g2 = StringExtensions.insert(g2, 20, "-");
                g2 = StringExtensions.insert(g2, 16, "-");
                g2 = StringExtensions.insert(g2, 12, "-");
                g2 = StringExtensions.insert(g2, 8, "-");
            }
            if (g2.indexOf(45, 0) >= 0) {
                String string = g2.trim();
                if (string.charAt(0) == '{') {
                    if (string.length() != 38 || string.charAt(37) != '}') {
                        throw new IllegalStateException("Wrong Guid format sting length: " + g2);
                    }
                    n2 = 1;
                } else if (string.charAt(0) == '(') {
                    if (string.length() != 38 || string.charAt(37) != ')') {
                        throw new IllegalStateException("Wrong Guid format sting length: " + g2);
                    }
                    n2 = 1;
                } else if (string.length() != 36) {
                    throw new IllegalStateException("Wrong Guid format sting length: " + g2);
                }
                if (string.charAt(8 + n2) != '-' || string.charAt(13 + n2) != '-' || string.charAt(18 + n2) != '-' || string.charAt(23 + n2) != '-') {
                    throw new IllegalStateException("Wrong format: missed or misplaced dashes: " + g2);
                }
                nArray[0] = n2;
                this.a = Guid.a(string, nArray, 8);
                nArray[0] = nArray[0] + 1;
                this.b = (short)Guid.a(string, nArray, 4);
                nArray[0] = nArray[0] + 1;
                this.c = (short)Guid.a(string, nArray, 4);
                nArray[0] = nArray[0] + 1;
                n3 = Guid.a(string, nArray, 4);
                nArray[0] = nArray[0] + 1;
                n2 = nArray[0];
                l2 = ParseNumbers.stringToLong(string, 16, 8192, nArray);
                if (nArray[0] - n2 != 12) {
                    throw new IllegalStateException("Wrong Guid format sting length: " + g2);
                }
            } else {
                throw new IllegalStateException("Unsupported Guid Format: " + g2);
            }
            this.d = (byte)(n3 >> 8);
            this.e = (byte)n3;
            n3 = (int)(l2 >> 32);
            this.f = (byte)(n3 >> 8);
            this.g = (byte)n3;
            n3 = (int)l2;
            this.h = (byte)(n3 >> 24);
            this.i = (byte)(n3 >> 16);
            this.j = (byte)(n3 >> 8);
            this.k = (byte)n3;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalStateException("Format_GuidUnrecognized");
        }
    }

    public Guid(int a2, short b2, short c2, byte[] d2) {
        if (d2 == null) {
            throw new NullPointerException("d");
        }
        if (d2.length != 8) {
            throw new ArgumentException("Arg_GuidArrayCtor. d should have length 8.");
        }
        this.a = a2;
        this.b = b2;
        this.c = c2;
        this.d = d2[0];
        this.e = d2[1];
        this.f = d2[2];
        this.g = d2[3];
        this.h = d2[4];
        this.i = d2[5];
        this.j = d2[6];
        this.k = d2[7];
    }

    public Guid(int a2, short b2, short c2, byte d2, byte e2, byte f2, byte g2, byte h2, byte i2, byte j2, byte k2) {
        this.a = a2;
        this.b = b2;
        this.c = c2;
        this.d = d2;
        this.e = e2;
        this.f = f2;
        this.g = g2;
        this.h = h2;
        this.i = i2;
        this.j = j2;
        this.k = k2;
    }

    private static int a(String string, int[] nArray, int n2) {
        int n3 = nArray[0];
        int n4 = (int)ParseNumbers.stringToLong(string, 16, 8192, nArray);
        if (nArray[0] - n3 != n2) {
            throw new IllegalStateException("Wrong Guid Format: Invalid Char: " + string);
        }
        return n4;
    }

    private static String a(String string) {
        int n2 = 0;
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Char.isWhiteSpace(c2)) continue;
            cArray[n2++] = c2;
        }
        return new String(cArray, 0, n2);
    }

    private static boolean a(String string, int n2) {
        return string.charAt(n2) == '0' && (string.charAt(n2 + 1) == 'x' || string.charAt(n2 + 1) == 'X');
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[]{(byte)this.a, (byte)(this.a >> 8), (byte)(this.a >> 16), (byte)(this.a >> 24), (byte)this.b, (byte)(this.b >> 8), (byte)this.c, (byte)(this.c >> 8), this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k};
        return byArray;
    }

    public String toString() {
        return this.toString("D");
    }

    public int hashCode() {
        return this.a ^ ((this.b & 0xFFFF) << 16 | this.c & 0xFFFF) ^ ((this.f & 0xFF) << 24 | this.k & 0xFF);
    }

    public boolean equals(Object obj) {
        return obj instanceof Guid && Guid.op_Equality(this, (Guid)obj);
    }

    public static boolean op_Equality(Guid a2, Guid b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.a != b2.a) {
            return false;
        }
        if (a2.b != b2.b) {
            return false;
        }
        if (a2.c != b2.c) {
            return false;
        }
        if (a2.d != b2.d) {
            return false;
        }
        if (a2.e != b2.e) {
            return false;
        }
        if (a2.f != b2.f) {
            return false;
        }
        if (a2.g != b2.g) {
            return false;
        }
        if (a2.h != b2.h) {
            return false;
        }
        if (a2.i != b2.i) {
            return false;
        }
        if (a2.j != b2.j) {
            return false;
        }
        return a2.k == b2.k;
    }

    public static boolean op_Inequality(Guid a2, Guid b2) {
        return !Guid.op_Equality(a2, b2);
    }

    private int a(long l2, long l3) {
        if (l2 < l3) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Guid value) {
        if (value == null) {
            return 1;
        }
        if (value.a != this.a) {
            return this.a(this.a, value.a);
        }
        if (value.b != this.b) {
            return this.a(this.b, value.b);
        }
        if (value.c != this.c) {
            return this.a(this.c, value.c);
        }
        if (value.d != this.d) {
            return this.a(this.d, value.d);
        }
        if (value.e != this.e) {
            return this.a(this.e, value.e);
        }
        if (value.f != this.f) {
            return this.a(this.f, value.f);
        }
        if (value.g != this.g) {
            return this.a(this.g, value.g);
        }
        if (value.h != this.h) {
            return this.a(this.h, value.h);
        }
        if (value.i != this.i) {
            return this.a(this.i, value.i);
        }
        if (value.j != this.j) {
            return this.a(this.j, value.j);
        }
        if (value.k != this.k) {
            return this.a(this.k, value.k);
        }
        return 0;
    }

    public static Guid newGuid() {
        return Guid.fromJava(UUID.randomUUID());
    }

    private static char a(int n2) {
        return (char)((n2 &= 0xF) > 9 ? n2 - 10 + 97 : n2 + 48);
    }

    private static int a(char[] cArray, int n2, int n3, int n4) {
        cArray[n2++] = Guid.a(n3 >> 4);
        cArray[n2++] = Guid.a(n3);
        cArray[n2++] = Guid.a(n4 >> 4);
        cArray[n2++] = Guid.a(n4);
        return n2;
    }

    @Override
    public String toString(String format, IFormatProvider provider) {
        return this.toString(format);
    }

    public String toString(String format) {
        char[] cArray;
        if (format == null || format.length() == 0) {
            format = "D";
        }
        int n2 = 0;
        int n3 = 38;
        boolean bl2 = true;
        if (format.length() != 1) {
            throw new IllegalStateException("Format_InvalidGuidFormatSpecification");
        }
        char c2 = format.charAt(0);
        if (c2 == 'D' || c2 == 'd') {
            cArray = new char[36];
            n3 = 36;
        } else if (c2 == 'N' || c2 == 'n') {
            cArray = new char[32];
            n3 = 32;
            bl2 = false;
        } else if (c2 == 'B' || c2 == 'b') {
            cArray = new char[38];
            cArray[n2++] = 123;
            cArray[37] = 125;
        } else if (c2 == 'P' || c2 == 'p') {
            cArray = new char[38];
            cArray[n2++] = 40;
            cArray[37] = 41;
        } else {
            throw new IllegalStateException("Format_InvalidGuidFormatSpecification");
        }
        n2 = Guid.a(cArray, n2, this.a >> 24, this.a >> 16);
        n2 = Guid.a(cArray, n2, this.a >> 8, this.a);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.b >> 8, this.b);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.c >> 8, this.c);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.d, this.e);
        if (bl2) {
            cArray[n2++] = 45;
        }
        n2 = Guid.a(cArray, n2, this.f, this.g);
        n2 = Guid.a(cArray, n2, this.h, this.i);
        n2 = Guid.a(cArray, n2, this.j, this.k);
        return new String(cArray, 0, n3);
    }

    public String toString(String format, CultureInfo culture) {
        return this.toString(format);
    }

    @Override
    public void CloneTo(Guid that) {
        that.a = this.a;
        that.b = this.b;
        that.c = this.c;
        that.d = this.d;
        that.e = this.e;
        that.f = this.f;
        that.g = this.g;
        that.h = this.h;
        that.i = this.i;
        that.j = this.j;
        that.k = this.k;
    }

    @Override
    public Guid Clone() {
        Guid guid = new Guid();
        this.CloneTo(guid);
        return guid;
    }

    public Object clone() {
        return this.Clone();
    }
}

