/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Struct;
import java.awt.Dimension;

@SerializableAttribute
public class Size
extends Struct<Size> {
    private Dimension b = new Dimension(0, 0);
    public static Size Empty = new Size();

    public Size() {
    }

    public static Size ceiling(SizeF value) {
        int n2 = (int)Math.ceil(value.getWidth());
        int n3 = (int)Math.ceil(value.getHeight());
        return new Size(n2, n3);
    }

    public static Size round(SizeF value) {
        int n2 = (int)msMath.round(value.getWidth());
        int n3 = (int)msMath.round(value.getHeight());
        return new Size(n2, n3);
    }

    public static Size truncate(SizeF value) {
        int n2 = (int)value.getWidth();
        int n3 = (int)value.getHeight();
        return new Size(n2, n3);
    }

    public static Size op_Addition(Size sz1, Size sz2) {
        return new Size(sz1.getWidth() + sz2.getWidth(), sz1.getHeight() + sz2.getHeight());
    }

    public static boolean op_Equality(Size sz1, Size sz2) {
        return sz1.getWidth() == sz2.getWidth() && sz1.getHeight() == sz2.getHeight();
    }

    public static boolean op_Inequality(Size sz1, Size sz2) {
        return sz1.getWidth() != sz2.getWidth() || sz1.getHeight() != sz2.getHeight();
    }

    public static Size op_Subtraction(Size sz1, Size sz2) {
        return new Size(sz1.getWidth() - sz2.getWidth(), sz1.getHeight() - sz2.getHeight());
    }

    public static Point to_Point(Size size) {
        return new Point(size.getWidth(), size.getHeight());
    }

    public static SizeF to_SizeF(Size p2) {
        return new SizeF(p2.getWidth(), p2.getHeight());
    }

    public Size(Point pt) {
        this.b = new Dimension(pt.getX(), pt.getY());
    }

    private Size(Dimension dim) {
        this.b = dim;
    }

    public Size(int width, int height) {
        this.b = new Dimension(width, height);
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return this.getWidth() == 0 && this.getHeight() == 0;
    }

    public int getWidth() {
        return this.b.width;
    }

    public void setWidth(int value) {
        this.b.width = value;
    }

    public int getHeight() {
        return this.b.height;
    }

    public void setHeight(int value) {
        this.b.height = value;
    }

    public int hashCode() {
        return this.getWidth() ^ this.getHeight();
    }

    public String toString() {
        return StringExtensions.format("{{Width={0}, Height={1}}}", this.getWidth(), this.getHeight());
    }

    public static Size add(Size sz1, Size sz2) {
        return new Size(sz1.getWidth() + sz2.getWidth(), sz1.getHeight() + sz2.getHeight());
    }

    public static Size subtract(Size sz1, Size sz2) {
        return new Size(sz1.getWidth() - sz2.getWidth(), sz1.getHeight() - sz2.getHeight());
    }

    public static Size fromJava(Dimension point) {
        if (point == null) {
            return new Size(0, 0);
        }
        return new Size(point);
    }

    public static Dimension toJava(Size size) {
        if (size == null) {
            return null;
        }
        return size.b;
    }

    @Override
    public void CloneTo(Size that) {
        that.setWidth(this.getWidth());
        that.setHeight(this.getHeight());
    }

    @Override
    public Size Clone() {
        Size size = new Size();
        this.CloneTo(size);
        return size;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Size size) {
        return size.getWidth() == this.getWidth() && size.getHeight() == this.getHeight();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof Size)) {
            return false;
        }
        return this.a((Size)obj);
    }

    public static boolean equals(Size obj1, Size obj2) {
        return obj1.equals(obj2);
    }
}

