/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.lang.Struct;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

@SerializableAttribute
public class RectangleF
extends Struct<RectangleF> {
    private Rectangle2D.Float b = new Rectangle2D.Float();
    public static RectangleF Empty = new RectangleF();

    public RectangleF() {
    }

    Rectangle2D.Float a() {
        return this.b;
    }

    public static RectangleF fromLTRB(float left, float top, float right, float bottom) {
        return new RectangleF(left, top, right - left, bottom - top);
    }

    public static RectangleF inflate(RectangleF rect, float x2, float y2) {
        RectangleF rectangleF = new RectangleF(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        rectangleF.inflate(x2, y2);
        return rectangleF;
    }

    public void inflate(float x2, float y2) {
        this.inflate(new SizeF(x2, y2));
    }

    public void inflate(SizeF size) {
        this.b.x -= size.getWidth();
        this.b.y -= size.getHeight();
        this.b.width += size.getWidth() * 2.0f;
        this.b.height += size.getHeight() * 2.0f;
    }

    public static RectangleF intersect(RectangleF a2, RectangleF b2) {
        if (!a2.intersectsWithInclusive(b2.Clone())) {
            return Empty;
        }
        return RectangleF.fromLTRB(Math.max(a2.getLeft(), b2.getLeft()), Math.max(a2.getTop(), b2.getTop()), Math.min(a2.getRight(), b2.getRight()), Math.min(a2.getBottom(), b2.getBottom()));
    }

    public void intersect(RectangleF rect) {
        RectangleF.intersect(this.Clone(), rect.Clone()).CloneTo(this);
    }

    public static RectangleF union(RectangleF a2, RectangleF b2) {
        return RectangleF.fromLTRB(Math.min(a2.getLeft(), b2.getLeft()), Math.min(a2.getTop(), b2.getTop()), Math.max(a2.getRight(), b2.getRight()), Math.max(a2.getBottom(), b2.getBottom()));
    }

    public static boolean op_Equality(RectangleF left, RectangleF right) {
        return left.getX() == right.getX() && left.getY() == right.getY() && left.getWidth() == right.getWidth() && left.getHeight() == right.getHeight();
    }

    public static boolean op_Inequality(RectangleF left, RectangleF right) {
        return left.getX() != right.getX() || left.getY() != right.getY() || left.getWidth() != right.getWidth() || left.getHeight() != right.getHeight();
    }

    public static RectangleF to_RectangleF(Rectangle r2) {
        return new RectangleF(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public RectangleF(PointF location, SizeF size) {
        this.b = new Rectangle2D.Float(location.getX(), location.getY(), size.getWidth(), size.getHeight());
    }

    public RectangleF(float x2, float y2, float width, float height) {
        this.b = new Rectangle2D.Float(x2, y2, width, height);
    }

    public RectangleF(RectangularShape r2d) {
        this.b = new Rectangle2D.Float((float)r2d.getX(), (float)r2d.getY(), (float)r2d.getWidth(), (float)r2d.getHeight());
    }

    @BrowsableAttribute(browsable=false)
    public float getBottom() {
        return this.getY() + this.getHeight();
    }

    public float getHeight() {
        return this.b.height;
    }

    public void setHeight(float value) {
        this.b.height = value;
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return this.getWidth() <= 0.0f || this.getHeight() <= 0.0f;
    }

    @BrowsableAttribute(browsable=false)
    public float getLeft() {
        return this.getX();
    }

    @BrowsableAttribute(browsable=false)
    public PointF getLocation() {
        return new PointF(this.getX(), this.getY());
    }

    @BrowsableAttribute(browsable=false)
    public void setLocation(PointF value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    @BrowsableAttribute(browsable=false)
    public float getRight() {
        return this.getX() + this.getWidth();
    }

    @BrowsableAttribute(browsable=false)
    public SizeF getSize() {
        return new SizeF(this.getWidth(), this.getHeight());
    }

    @BrowsableAttribute(browsable=false)
    public void setSize(SizeF value) {
        this.setWidth(value.getWidth());
        this.setHeight(value.getHeight());
    }

    @BrowsableAttribute(browsable=false)
    public float getTop() {
        return this.getY();
    }

    public float getWidth() {
        return this.b.width;
    }

    public void setWidth(float value) {
        this.b.width = value;
    }

    public float getX() {
        return this.b.x;
    }

    public void setX(float value) {
        this.b.x = value;
    }

    public float getY() {
        return this.b.y;
    }

    public void setY(float value) {
        this.b.y = value;
    }

    public boolean contains(float x2, float y2) {
        return x2 >= this.getLeft() && x2 < this.getRight() && y2 >= this.getTop() && y2 < this.getBottom();
    }

    public boolean contains(PointF pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public boolean contains(RectangleF rect) {
        return this.getX() <= rect.getX() && rect.getRight() <= this.getRight() && this.getY() <= rect.getY() && rect.getBottom() <= this.getBottom();
    }

    public int hashCode() {
        return (int)(this.getX() + this.getY() + this.getWidth() + this.getHeight());
    }

    public boolean intersectsWith(RectangleF rect) {
        return !(this.getLeft() >= rect.getRight() || this.getRight() <= rect.getLeft() || this.getTop() >= rect.getBottom() || this.getBottom() <= rect.getTop());
    }

    public boolean intersectsWithInclusive(RectangleF r2) {
        return !(this.getLeft() > r2.getRight() || this.getRight() < r2.getLeft() || this.getTop() > r2.getBottom() || this.getBottom() < r2.getTop());
    }

    public void offset(float x2, float y2) {
        this.setX(this.getX() + x2);
        this.setY(this.getY() + y2);
    }

    public void offset(PointF pos) {
        this.offset(pos.getX(), pos.getY());
    }

    private static String a(float f2) {
        return SingleExtensions.toString(f2);
    }

    public String toString() {
        return "{X=" + RectangleF.a(this.getX()) + ",Y=" + RectangleF.a(this.getY()) + ",Width=" + RectangleF.a(this.getWidth()) + ",Height=" + RectangleF.a(this.getHeight()) + "}";
    }

    @Override
    public void CloneTo(RectangleF that) {
        that.setX(this.getX());
        that.setY(this.getY());
        that.setWidth(this.getWidth());
        that.setHeight(this.getHeight());
    }

    @Override
    public RectangleF Clone() {
        RectangleF rectangleF = new RectangleF();
        this.CloneTo(rectangleF);
        return rectangleF;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(RectangleF rectangleF) {
        return rectangleF.getX() == this.getX() && rectangleF.getY() == this.getY() && rectangleF.getWidth() == this.getWidth() && rectangleF.getHeight() == this.getHeight();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof RectangleF)) {
            return false;
        }
        return this.a((RectangleF)obj);
    }

    public static boolean equals(RectangleF obj1, RectangleF obj2) {
        return obj1.equals(obj2);
    }

    public static RectangleF fromJava(Rectangle2D.Float area) {
        if (area == null) {
            return new RectangleF();
        }
        return new RectangleF(area);
    }

    public static Rectangle2D.Float toJava(RectangleF rect) {
        if (rect == null) {
            return null;
        }
        return rect.a();
    }
}

