/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Printing;

import com.aspose.html.internal.ms.System.Drawing.Printing.PageSettings;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSize;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterResolution;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterSettings;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.CommonUtils;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Converters.MediaSizePaperSizeConverter;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public class DefaultPageSettingsBuilder {
    private PrinterSettings a;
    private PrintService b;
    private PageSettings c;

    private DefaultPageSettingsBuilder(PrinterSettings printerSettings, PrintService printService) {
        this.a = printerSettings;
        this.b = printService;
    }

    public static DefaultPageSettingsBuilder loadDefaultPageSettingsBuilder(PrinterSettings printerSettings, PrintService printService) {
        return new DefaultPageSettingsBuilder(printerSettings, printService);
    }

    public DefaultPageSettingsBuilder buildDefaultPageSettings() {
        this.c = new PageSettings(this.a);
        this.f();
        this.e();
        this.d();
        this.c();
        this.b();
        this.a();
        return this;
    }

    private void a() {
        PrinterSettings.PaperSourceCollection paperSourceCollection = this.a.getPaperSources();
        if (CommonUtils.isNotEmpty(paperSourceCollection)) {
            this.c.setPaperSource(paperSourceCollection.get_Item(0));
        }
    }

    public PageSettings getPageSettings() {
        return this.c;
    }

    private void b() {
        this.c.setColor(this.a.getSupportsColor());
    }

    private void c() {
        PrinterSettings.PrinterResolutionCollection printerResolutionCollection = this.a.getPrinterResolutions();
        PrinterResolution printerResolution = new PrinterResolution(200, 200, -3);
        if (printerResolutionCollection != null && printerResolutionCollection.size() > 0) {
            printerResolution = printerResolutionCollection.get_Item(0);
        }
        this.c.setPrinterResolution(printerResolution);
    }

    private void d() {
    }

    private void e() {
        OrientationRequested[] orientationRequestedArray = (OrientationRequested[])this.b.getSupportedAttributeValues(OrientationRequested.class, null, null);
        OrientationRequested orientationRequested = orientationRequestedArray[0];
        if (OrientationRequested.PORTRAIT.equals(orientationRequested)) {
            this.c.setLandscape(false);
        } else {
            this.c.setLandscape(true);
        }
    }

    private void f() {
        PrinterSettings.PaperSizeCollection paperSizeCollection = this.a.getPaperSizes();
        PaperSize paperSize = this.a(paperSizeCollection);
        this.c.setPaperSize(paperSize);
        this.c.a(this.a(paperSize));
    }

    private PaperSize a(PrinterSettings.PaperSizeCollection paperSizeCollection) {
        if (paperSizeCollection == null || paperSizeCollection.size() < 1) {
            return new PaperSize("A4", 827, 1167, 9, true);
        }
        PaperSize paperSize = paperSizeCollection.get_Item(0);
        for (Object e2 : paperSizeCollection) {
            PaperSize paperSize2 = (PaperSize)e2;
            if (paperSize2.isDefault()) {
                return paperSize2;
            }
            if (paperSize2.getWidth() * paperSize2.getHeight() >= paperSize.getWidth() * paperSize.getHeight()) continue;
            paperSize = paperSize2;
        }
        return paperSize;
    }

    private RectangleF a(PaperSize paperSize) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        String string = paperSize.getPaperName();
        MediaSize mediaSize = MediaSizePaperSizeConverter.convertToMediaSize(string);
        MediaSizeName mediaSizeName = mediaSize.getMediaSizeName();
        hashPrintRequestAttributeSet.add(mediaSizeName);
        MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])this.b.getSupportedAttributeValues(MediaPrintableArea.class, null, hashPrintRequestAttributeSet);
        float[] fArray = null;
        for (MediaPrintableArea mediaPrintableArea : mediaPrintableAreaArray) {
            if (mediaPrintableArea == null) continue;
            fArray = mediaPrintableArea.getPrintableArea(25400);
            break;
        }
        RectangleF rectangleF = new RectangleF((float)(fArray[0] * 100.0f), fArray[1] * 100.0f, fArray[2] * 100.0f, fArray[3] * 100.0f);
        return rectangleF;
    }
}

