/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ComponentModel.BrowsableAttribute;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.Size;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Struct;
import java.awt.geom.Point2D;

@SerializableAttribute
public class PointF
extends Struct<PointF> {
    private Point2D.Float b = new Point2D.Float(0.0f, 0.0f);
    public static PointF Empty = new PointF();

    public PointF() {
    }

    public PointF(Point2D.Float point) {
        this.b = point;
    }

    public static PointF op_Addition(PointF pt, Size sz) {
        return new PointF(pt.getX() + (float)sz.getWidth(), pt.getY() + (float)sz.getHeight());
    }

    public static boolean op_Equality(PointF left, PointF right) {
        return left.getX() == right.getX() && left.getY() == right.getY();
    }

    public static boolean op_Inequality(PointF left, PointF right) {
        return left.getX() != right.getX() || left.getY() != right.getY();
    }

    public static PointF op_Subtraction(PointF pt, Size sz) {
        return new PointF(pt.getX() - (float)sz.getWidth(), pt.getY() - (float)sz.getHeight());
    }

    public PointF(float x2, float y2) {
        this.b = new Point2D.Float(x2, y2);
    }

    @BrowsableAttribute(browsable=false)
    public boolean isEmpty() {
        return (double)this.getX() == 0.0 && (double)this.getY() == 0.0;
    }

    public float getX() {
        return this.b.x;
    }

    public void setX(float value) {
        this.b.x = value;
    }

    public float getY() {
        return this.b.y;
    }

    public void setY(float value) {
        this.b.y = value;
    }

    public int hashCode() {
        return (int)this.getX() ^ (int)this.getY();
    }

    public String toString() {
        return StringExtensions.format("{{X={0}, Y={1}}}", SingleExtensions.toString(this.getX(), CultureInfo.getCurrentCulture()), SingleExtensions.toString(this.getY(), CultureInfo.getCurrentCulture()));
    }

    public static PointF add(PointF pt, Size sz) {
        return new PointF(pt.getX() + (float)sz.getWidth(), pt.getY() + (float)sz.getHeight());
    }

    public static PointF add(PointF pt, SizeF sz) {
        return new PointF(pt.getX() + sz.getWidth(), pt.getY() + sz.getHeight());
    }

    public static PointF subtract(PointF pt, Size sz) {
        return new PointF(pt.getX() - (float)sz.getWidth(), pt.getY() - (float)sz.getHeight());
    }

    public static PointF subtract(PointF pt, SizeF sz) {
        return new PointF(pt.getX() - sz.getWidth(), pt.getY() - sz.getHeight());
    }

    @Override
    public void CloneTo(PointF that) {
        that.setX(this.getX());
        that.setY(this.getY());
    }

    @Override
    public PointF Clone() {
        PointF pointF = new PointF();
        this.CloneTo(pointF);
        return pointF;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(PointF pointF) {
        return pointF.getX() == this.getX() && pointF.getY() == this.getY();
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof PointF)) {
            return false;
        }
        return this.a((PointF)obj);
    }

    public static boolean equals(PointF obj1, PointF obj2) {
        return obj1.equals(obj2);
    }

    public static PointF fromJava(Point2D.Float point) {
        if (point == null) {
            return new PointF(0.0f, 0.0f);
        }
        return new PointF(point);
    }

    public static Point2D.Float toJava(PointF point) {
        if (point == null) {
            return null;
        }
        return point.b;
    }

    public Point toPoint() {
        return new Point((int)this.getX(), (int)this.getY());
    }

    public Point toPointRounded() {
        return new Point(Math.round(this.getX()), Math.round(this.getY()));
    }

    public static PointF fromPoint(Point p2) {
        return new PointF(p2.getX(), p2.getY());
    }

    public static PointF[] fromPoints(Point[] points) {
        if (points == null) {
            return null;
        }
        if (points.length == 0) {
            return new PointF[0];
        }
        PointF[] pointFArray = new PointF[points.length];
        for (int i2 = 0; i2 < points.length; ++i2) {
            pointFArray[i2] = PointF.fromPoint(points[i2]);
        }
        return pointFArray;
    }
}

