/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Imaging;

import com.aspose.html.internal.ms.System.Enum;

public final class PixelFormat {
    public static final int Alpha = 262144;
    public static final int Canonical = 0x200000;
    public static final int DontCare = 0;
    public static final int Extended = 0x100000;
    public static final int Format16bppArgb1555 = 397319;
    public static final int Format16bppGrayScale = 0x101004;
    public static final int Format16bppRgb555 = 135173;
    public static final int Format16bppRgb565 = 135174;
    public static final int Format1bppIndexed = 196865;
    public static final int Format24bppRgb = 137224;
    public static final int Format32bppArgb = 2498570;
    public static final int Format32bppPArgb = 925707;
    public static final int Format32bppRgb = 139273;
    public static final int Format48bppRgb = 1060876;
    public static final int Format4bppIndexed = 197634;
    public static final int Format64bppArgb = 3424269;
    public static final int Format64bppPArgb = 1851406;
    public static final int Format8bppIndexed = 198659;
    public static final int Gdi = 131072;
    public static final int Indexed = 65536;
    public static final int Max = 15;
    public static final int PAlpha = 524288;
    public static final int Undefined = 0;

    public static boolean containsFormat(int container, int contained) {
        return (container & contained) != 0;
    }

    public static int getPixelFormatDepth(int pixfmt) {
        switch (pixfmt) {
            case 135173: 
            case 135174: 
            case 137224: 
            case 139273: 
            case 397319: 
            case 925707: 
            case 0x101004: 
            case 2498570: {
                return 8;
            }
            case 1060876: 
            case 1851406: 
            case 3424269: {
                return 16;
            }
            case 198659: {
                return 8;
            }
            case 197634: {
                return 4;
            }
            case 196865: {
                return 1;
            }
        }
        return 0;
    }

    public static int getPixelFormatComponentsCount(int pixfmt) {
        switch (pixfmt) {
            case 137224: 
            case 139273: 
            case 397319: 
            case 925707: 
            case 1851406: 
            case 2498570: 
            case 3424269: {
                return 4;
            }
            case 135173: 
            case 135174: 
            case 1060876: {
                return 3;
            }
            case 196865: 
            case 197634: 
            case 198659: 
            case 0x101004: {
                return 1;
            }
        }
        return 0;
    }

    public static int[] getMaskByPixelFormat(int format) {
        switch (format) {
            case 397319: {
                return new int[]{31744, 992, 31, 32768};
            }
            case 0x101004: {
                return new int[]{65535};
            }
            case 135173: {
                return new int[]{31744, 992, 31};
            }
            case 135174: {
                return new int[]{63488, 2016, 31};
            }
            case 196865: {
                return new int[]{1};
            }
            case 137224: {
                return new int[]{0xFF0000, 65280, 255};
            }
            case 2498570: {
                return new int[]{0xFF0000, 65280, 255, -16777216};
            }
            case 925707: {
                return new int[]{0xFF0000, 65280, 255, -16777216};
            }
            case 139273: {
                return new int[]{0xFF0000, 65280, 255, -16777216};
            }
            case 197634: {
                return new int[]{15};
            }
            case 198659: {
                return new int[]{255};
            }
        }
        return new int[]{0xFF0000, 65280, 255, -16777216};
    }

    static {
        Enum.register(new Enum.SimpleEnum((Class)PixelFormat.class, Integer.class){
            {
                this.addConstant("Alpha", 262144L);
                this.addConstant("Canonical", 0x200000L);
                this.addConstant("DontCare", 0L);
                this.addConstant("Extended", 0x100000L);
                this.addConstant("Format16bppArgb1555", 397319L);
                this.addConstant("Format16bppGrayScale", 0x101004L);
                this.addConstant("Format16bppRgb555", 135173L);
                this.addConstant("Format16bppRgb565", 135174L);
                this.addConstant("Format1bppIndexed", 196865L);
                this.addConstant("Format24bppRgb", 137224L);
                this.addConstant("Format32bppArgb", 2498570L);
                this.addConstant("Format32bppPArgb", 925707L);
                this.addConstant("Format32bppRgb", 139273L);
                this.addConstant("Format48bppRgb", 1060876L);
                this.addConstant("Format4bppIndexed", 197634L);
                this.addConstant("Format64bppArgb", 3424269L);
                this.addConstant("Format64bppPArgb", 1851406L);
                this.addConstant("Format8bppIndexed", 198659L);
                this.addConstant("Gdi", 131072L);
                this.addConstant("Indexed", 65536L);
                this.addConstant("Max", 15L);
                this.addConstant("PAlpha", 524288L);
                this.addConstant("Undefined", 0L);
            }
        });
    }
}

