/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Imaging;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Imaging.EncoderParameters;
import com.aspose.html.internal.ms.System.Drawing.Imaging.FrameDimension;
import com.aspose.html.internal.ms.System.Drawing.Imaging.ImageFormat;
import com.aspose.html.internal.ms.System.Drawing.Imaging.MetafileHeader;
import com.aspose.html.internal.ms.System.Drawing.Imaging.PlainImage;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.ExternalException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.ImageCodec;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.Metafiles.IMetafileRecord;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.Metafiles.MetafilesException;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.Metafiles.bu;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.Metafiles.fx;
import com.aspose.html.internal.ms.core.System.Drawing.Imaging.Metafiles.hv;
import com.aspose.html.internal.ms.lang.Ref;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public final class Metafile
extends Image {
    private fx a;
    private String b;
    private Stream c;

    private Metafile(fx metafile) {
        this.a = metafile;
        this.a();
    }

    public Metafile(Stream stream) {
        if (stream == null) {
            throw new ArgumentException("stream");
        }
        if (stream.getLength() == 0L) {
            throw new ExternalException("stream");
        }
        try {
            this.a = fx.a(stream.toInputStream());
            this.a();
        }
        catch (MetafilesException metafilesException) {
            throw new ArgumentException(metafilesException.getMessage(), metafilesException);
        }
    }

    public Metafile(String filename) {
        if (filename == null) {
            throw new ArgumentException("filename");
        }
        try {
            this.a = fx.b(filename);
            this.a();
        }
        catch (MetafilesException metafilesException) {
            throw new ArgumentException(metafilesException.getMessage(), metafilesException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ExternalException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public Metafile(int width, int height, boolean isWmf, String saveToFile) {
        this.b = saveToFile;
        if (!isWmf) {
            throw new NotImplementedException();
        }
        this.a = hv.a(width, height);
        this.a();
    }

    public Metafile(Bitmap bitmap, boolean isWmf, Stream saveToStream) {
        this.c = saveToStream;
        if (isWmf) {
            this.a = hv.a(bitmap.getNativeObject_Bitmap_New());
            this.a();
        } else {
            this.a = bu.a(bitmap.getNativeObject_Bitmap_New());
        }
    }

    @Override
    public int getHeight() {
        return this.a.getHeight();
    }

    @Override
    public int getWidth() {
        return this.a.getWidth();
    }

    @Override
    public RectangleF getBounds(Ref<Integer> pageUnit) {
        return new RectangleF(this.a.i(), this.a.j(), this.getWidth(), this.getHeight());
    }

    @Override
    public float getHorizontalResolution() {
        return this.a.c();
    }

    @Override
    public float getVerticalResolution() {
        return this.a.d();
    }

    private void a() {
        FrameDimension frameDimension = FrameDimension.getResolution();
        ImageFormat imageFormat = this.a.a() ? ImageFormat.getWmf() : ImageFormat.getEmf();
        PlainImage plainImage = new PlainImage((java.awt.Image)((Object)this.a.m()), null, imageFormat, this.a.a() ? ((hv)this.a).y() : this.getHorizontalResolution(), this.a.a() ? ((hv)this.a).y() : this.getVerticalResolution(), frameDimension);
        super.initialize(plainImage, false);
    }

    public MetafileHeader getMetafileHeader() {
        return new MetafileHeader(this.a);
    }

    public static MetafileHeader getMetafileHeader(Stream stream) {
        if (stream == null) {
            throw new NullReferenceException();
        }
        try {
            fx fx2 = fx.a(stream.toInputStream());
            return new MetafileHeader(fx2);
        }
        catch (MetafilesException metafilesException) {
            throw new ArgumentException(metafilesException.getMessage());
        }
    }

    public static MetafileHeader getMetafileHeader(String fileName) {
        if (fileName == null) {
            throw new ArgumentNullException();
        }
        try {
            fx fx2 = fx.b(fileName);
            return new MetafileHeader(fx2);
        }
        catch (MetafilesException metafilesException) {
            throw new ArgumentException(metafilesException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ArgumentException(fileNotFoundException.getMessage());
        }
    }

    public void beforePlayRecord(Graphics2D graphics) {
        this.a.a(graphics);
    }

    public void afterPlayRecord(Graphics2D graphics) {
        this.a.b(graphics);
    }

    public void playRecord(int recordType, IMetafileRecord record, Graphics graphics) {
        if (recordType != record.getId()) {
            throw new ArgumentException("wrong record type");
        }
        this.a.a(recordType, record, graphics.getNativeObject());
    }

    public void playMetafile(Graphics2D graphics, AffineTransform transform) {
        try {
            this.a.a(graphics, transform);
        }
        catch (MetafilesException metafilesException) {
            throw new ArgumentException(metafilesException.getMessage());
        }
    }

    @Override
    public Object deepClone() {
        return new Metafile((fx)this.a.clone());
    }

    @Override
    protected void internalSave(ImageOutputStream output, ImageCodec ic2, EncoderParameters encoderParams, Stream originalStream) {
        ImageFormat imageFormat = ic2.getImageFormat();
        if (imageFormat.isMetafileType()) {
            throw new NotImplementedException();
        }
        try {
            RenderedImage renderedImage = this.a.m();
            ImageWriter imageWriter = ic2.getNativeWriter();
            if (ic2.getImageFormat().equals(ImageFormat.getGif()) || ic2.getImageFormat().equals(ImageFormat.getTiff()) || ic2.getImageFormat().equals(ImageFormat.getJpeg()) || ic2.getImageFormat().equals(ImageFormat.getPng())) {
                imageWriter.setOutput(originalStream);
            } else {
                imageWriter.setOutput(output);
            }
            imageWriter.write(renderedImage);
        }
        catch (IOException iOException) {
            throw new com.aspose.html.internal.ms.System.IO.IOException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public ImageFormat getRawFormat() {
        if (this.a.a()) {
            return ImageFormat.getWmf();
        }
        return ImageFormat.getEmf();
    }

    public void save() {
        if (this.b != null) {
            if (this.a.a()) {
                hv hv2 = (hv)this.a;
                try {
                    hv2.a(this.b);
                }
                catch (IOException iOException) {
                    throw new com.aspose.html.internal.ms.System.IO.IOException(iOException.getMessage(), iOException);
                }
            } else {
                bu bu2 = (bu)this.a;
                try {
                    bu2.a(this.b);
                }
                catch (IOException iOException) {
                    throw new com.aspose.html.internal.ms.System.IO.IOException(iOException.getMessage(), iOException);
                }
            }
        } else if (this.c != null) {
            if (this.a.a()) {
                hv hv3 = (hv)this.a;
                hv3.save(this.c);
            } else {
                bu bu3 = (bu)this.a;
                bu3.save(this.c);
            }
        } else {
            throw new ArgumentException("Unable to save memory metafile.");
        }
    }

    @Override
    protected java.awt.Image[] cloneNativeObjects(java.awt.Image[] src) {
        if (src == null) {
            return null;
        }
        java.awt.Image[] imageArray = new java.awt.Image[src.length];
        for (int i2 = 0; i2 < imageArray.length; ++i2) {
            BufferedImage bufferedImage;
            java.awt.Image image = src[i2];
            BufferedImage bufferedImage2 = bufferedImage = image instanceof BufferedImage ? (BufferedImage)image : null;
            if (bufferedImage == null) {
                throw new ArgumentNullException("src", StringExtensions.format("Unsupported image type '{0}'", image.toString()));
            }
            imageArray[i2] = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.copyData(null), bufferedImage.isAlphaPremultiplied(), null);
        }
        return imageArray;
    }

    @Override
    protected int getInternalPixelFormat() {
        BufferedImage bufferedImage = (BufferedImage)this.getCurrentImage().getNativeImage();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n2 = colorModel.getPixelSize();
        int n3 = Image.getInternalPixelFormat(((BufferedImage)this.getNativeObject().getCurrentImage().getNativeImage()).getType(), n2);
        if (n3 == 0 && this.getRawFormat().equals(ImageFormat.getPng())) {
            return 2498570;
        }
        return n3;
    }

    public IEnumerator<IMetafileRecord> getRecordEnumerator() {
        return new RecordEnumerator(this.a);
    }

    public void appendRecord(IMetafileRecord record) {
        this.a.a(record);
    }

    public fx getInternalMetafile() {
        return this.a;
    }

    private static class RecordEnumerator
    implements IEnumerator<IMetafileRecord> {
        private int a = 0;
        private int b;
        private int c;
        private boolean d;
        private fx e;

        public RecordEnumerator(fx metafile) {
            this.e = metafile;
            this.c = this.a + metafile.b() - 1;
            this.reset();
        }

        private void b() {
            if (this.b < this.a) {
                throw new InvalidOperationException("Enumeration has not started.");
            }
            if (this.d) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        private void c() {
            ++this.b;
            this.d = this.b > this.c;
        }

        public IMetafileRecord a() {
            this.b();
            return this.e.a(this.b);
        }

        @Override
        public boolean hasNext() {
            if (this.d) {
                return false;
            }
            this.c();
            return !this.d;
        }

        @Override
        public void reset() {
            this.b = this.a - 1;
            this.d = this.a > this.c;
        }

        @Override
        public void remove() {
            throw new NotSupportedException("");
        }

        @Override
        public /* synthetic */ Object next() {
            return this.a();
        }
    }
}

