/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.CLSCompliantAttribute;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.DivideByZeroException;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IConvertible;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IFormattable;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.MidpointRounding;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.ByteArrayUtil;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Struct;
import java.math.BigDecimal;
import java.math.BigInteger;

@SerializableAttribute
public class Decimal
extends Struct<Decimal>
implements IConvertible,
IFormattable,
Comparable<Decimal> {
    public static final Decimal MinValue = new Decimal("-79228162514264337593543950335");
    public static final Decimal MaxValue = new Decimal("79228162514264337593543950335");
    public static final Decimal MinusOne = Decimal.newDecimalFromInt(-1);
    public static final Decimal One = Decimal.newDecimalFromInt(1);
    public static final Decimal Zero = Decimal.newDecimalFromInt(0);
    private static Decimal a = Decimal.op_Division(MaxValue, Decimal.newDecimalFromInt(10));
    private static final int b = 28;
    private static final int c = 29;
    private static final int d = Integer.MIN_VALUE;
    private static final int e = 16;
    private static final long f = 0x7F00FFFFL;
    private static final int g = 7;
    private static final int h = 15;
    private static final int i = 3;
    private static final int j = 3;
    private static final int k = 5;
    private static final int l = 5;
    private static final int m = 10;
    private static final int n = 10;
    private static final int o = 19;
    private static final int p = 20;
    private BigDecimal q;

    public Decimal() {
        this.q = BigDecimal.ZERO;
    }

    public Decimal(BigDecimal value) {
        if (value.compareTo(Decimal.MaxValue.q) > 0 || value.compareTo(Decimal.MinValue.q) < 0) {
            throw new OverflowException();
        }
        this.q = value;
    }

    public Decimal(String value) {
        this.q = new BigDecimal(value);
    }

    public static Decimal newDecimalFromInt(int value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        if (bigDecimal.scale() > 10) {
            bigDecimal = bigDecimal.setScale(10, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromUInt(long value) {
        long l2 = value & 0xFFFFFFFFFFFFFFFFL;
        BigDecimal bigDecimal = new BigDecimal(l2);
        if (bigDecimal.scale() > 10) {
            bigDecimal = bigDecimal.setScale(10, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromLong(long value) {
        BigDecimal bigDecimal = new BigDecimal(value);
        if (bigDecimal.scale() > 19) {
            bigDecimal = bigDecimal.setScale(19, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromULong(long value) {
        long l2 = value & 0xFFFFFFFFFFFFFFFFL;
        BigDecimal bigDecimal = new BigDecimal(l2);
        if (bigDecimal.scale() > 20) {
            bigDecimal = bigDecimal.setScale(20, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static Decimal newDecimalFromFloat(float value) {
        if (value >= Float.MAX_VALUE || value < -3.4028235E38f || Float.isNaN(value) || SingleExtensions.isNegativeInfinity(value) || SingleExtensions.isPositiveInfinity(value)) {
            throw new OverflowException(StringExtensions.format("Value {0} is greater than Decimal.MaxValue or less than Decimal.MinValue", Float.valueOf(value)));
        }
        BigDecimal bigDecimal = new BigDecimal(value);
        if (bigDecimal.scale() > Decimal.a(bigDecimal)) {
            if (Decimal.a(bigDecimal) > 29 && (bigDecimal = bigDecimal.setScale(7 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4)).scale() > 28) {
                bigDecimal = bigDecimal.setScale(28, 4);
            }
        } else if (Decimal.a(bigDecimal) > 7) {
            bigDecimal = bigDecimal.setScale(7 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4);
        }
        return Decimal.adjustScale(new Decimal(bigDecimal));
    }

    public static Decimal newDecimalFromDouble(double value) {
        if (Double.isNaN(value) || DoubleExtensions.isNegativeInfinity(value) || DoubleExtensions.isPositiveInfinity(value) || value > Double.MAX_VALUE || value < -1.7976931348623157E308) {
            throw new OverflowException(StringExtensions.format("Value {0} is greater than Decimal.MaxValue or less than Decimal.MinValue", value));
        }
        BigDecimal bigDecimal = new BigDecimal(value);
        if (bigDecimal.scale() > Decimal.a(bigDecimal)) {
            if (Decimal.a(bigDecimal) > 29 && (bigDecimal = bigDecimal.setScale(15 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4)).scale() > 28) {
                bigDecimal = bigDecimal.setScale(28, 4);
            }
        } else if (Decimal.a(bigDecimal) > 15) {
            bigDecimal = bigDecimal.setScale(15 - (Decimal.a(bigDecimal) - bigDecimal.scale()), 4);
        }
        if (bigDecimal.compareTo(Decimal.MaxValue.q) > 0 || bigDecimal.compareTo(Decimal.MinValue.q) < 0) {
            throw new OverflowException();
        }
        return Decimal.adjustScale(new Decimal(bigDecimal));
    }

    private static int a(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        boolean bl2 = bigInteger.signum() == -1;
        int n2 = bigInteger.toString().length();
        if (bl2) {
            --n2;
        }
        return n2;
    }

    public Decimal(int[] bits) {
        BigDecimal bigDecimal;
        if (bits == null) {
            throw new ArgumentNullException("Bits is a null reference");
        }
        if (msArray.getLength(bits, 0) != 4) {
            throw new ArgumentException("bits does not contain four values");
        }
        byte[] byArray = new byte[12];
        byte[] byArray2 = BitConverter.getBytesInt32(bits[3]);
        int n2 = byArray2[3] >>> 31;
        byte by2 = byArray2[2];
        if (by2 > 28 || ((long)bits[3] & 0x7F00FFFFL) != 0L) {
            throw new ArgumentException("Invalid bits[3]");
        }
        byte[] byArray3 = BitConverter.getBytesInt32(bits[0]);
        byte[] byArray4 = BitConverter.getBytesInt32(bits[1]);
        byte[] byArray5 = BitConverter.getBytesInt32(bits[2]);
        byArray[11] = byArray3[0];
        byArray[10] = byArray3[1];
        byArray[9] = byArray3[2];
        byArray[8] = byArray3[3];
        byArray[7] = byArray4[0];
        byArray[6] = byArray4[1];
        byArray[5] = byArray4[2];
        byArray[4] = byArray4[3];
        byArray[3] = byArray5[0];
        byArray[2] = byArray5[1];
        byArray[1] = byArray5[2];
        byArray[0] = byArray5[3];
        BigInteger bigInteger = new BigInteger(n2 == 0 ? 1 : -1, byArray);
        this.q = bigDecimal = new BigDecimal(bigInteger, by2);
    }

    public static Decimal fromOACurrency(long cy2) {
        return Decimal.op_Division(Decimal.newDecimalFromLong(cy2), Decimal.newDecimalFromInt(10000));
    }

    public static int[] getBits(Decimal d2) {
        BigDecimal bigDecimal;
        int[] nArray = new int[4];
        int n2 = 0;
        Decimal decimal = d2;
        boolean bl2 = false;
        if (Decimal.op_LessThan(d2, Zero)) {
            decimal = Decimal.negate(d2);
            bl2 = true;
        }
        if ((n2 = (bigDecimal = decimal.q).scale()) < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n2 = 0;
        }
        byte[] byArray = bigDecimal.unscaledValue().toByteArray();
        byte[] byArray2 = new byte[12];
        int n3 = byArray.length - 1;
        for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
            byArray2[i2] = byArray[n3--];
            if (n3 < 0) break;
        }
        byte[] byArray3 = new byte[4];
        if (n2 > 0) {
            byArray3[1] = (byte)n2;
        }
        if (bl2) {
            byArray3[0] = -128;
        }
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        byArray4[3] = byArray2[11];
        byArray4[2] = byArray2[10];
        byArray4[1] = byArray2[9];
        byArray4[0] = byArray2[8];
        byArray5[3] = byArray2[7];
        byArray5[2] = byArray2[6];
        byArray5[1] = byArray2[5];
        byArray5[0] = byArray2[4];
        byArray6[3] = byArray2[3];
        byArray6[2] = byArray2[2];
        byArray6[1] = byArray2[1];
        byArray6[0] = byArray2[0];
        nArray[0] = ByteArrayUtil.getInt(byArray4, 0, false);
        nArray[1] = ByteArrayUtil.getInt(byArray5, 0, false);
        nArray[2] = ByteArrayUtil.getInt(byArray6, 0, false);
        nArray[3] = ByteArrayUtil.getInt(byArray3, 0, false);
        return nArray;
    }

    public static Decimal adjustScale(Decimal d2) {
        BigDecimal bigDecimal = d2.q;
        String string = bigDecimal.toPlainString();
        String string2 = CultureInfo.getCurrentCulture().getNumberFormat().getNumberDecimalSeparator();
        while (string.endsWith("0") && string.indexOf(string2) != -1) {
            bigDecimal = bigDecimal.setScale(bigDecimal.scale() - 1);
            string = bigDecimal.toPlainString();
        }
        return new Decimal(bigDecimal);
    }

    public boolean isZero() {
        return this.equals(Zero);
    }

    public static Decimal negate(Decimal d2) {
        return new Decimal(d2.q.negate());
    }

    public static Decimal add(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return Decimal.fromJava(d1.q.add(d2.q));
    }

    public static Decimal subtract(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return Decimal.fromJava(d1.q.subtract(d2.q));
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    public static Decimal op_Addition(Decimal d1, Decimal d2) {
        return Decimal.add(d1, d2);
    }

    public static Decimal op_Decrement(Decimal d2) {
        return Decimal.add(d2, MinusOne);
    }

    public static Decimal op_Increment(Decimal d2) {
        return Decimal.add(d2, One);
    }

    public static Decimal op_Subtraction(Decimal d1, Decimal d2) {
        return Decimal.subtract(d1, d2);
    }

    public static Decimal op_UnaryNegation(Decimal d2) {
        return Decimal.negate(d2);
    }

    public static Decimal op_UnaryPlus(Decimal d2) {
        return d2;
    }

    public static Decimal abs(Decimal d2) {
        return new Decimal(d2.q.abs());
    }

    public static Decimal op_Multiply(Decimal d1, Decimal d2) {
        return Decimal.multiply(d1, d2);
    }

    public static Decimal op_Division(Decimal d1, Decimal d2) {
        return Decimal.divide(d1, d2);
    }

    public static Decimal op_Modulus(Decimal d1, Decimal d2) {
        return Decimal.remainder(d1, d2);
    }

    private static long a(Decimal decimal) {
        return decimal.q.longValue();
    }

    private static long b(Decimal decimal) {
        return decimal.q.longValue();
    }

    public static short to_ByteFromDecimal(Decimal value) {
        long l2 = Decimal.a(value);
        return (short)(l2 & 0xFFL);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static byte to_SByteFromDecimal(Decimal value) {
        long l2 = Decimal.b(value);
        return (byte)l2;
    }

    public static char to_CharFromDecimal(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(65535)) || Decimal.op_LessThan(value, Decimal.newDecimalFromLong(0L))) {
            throw new OverflowException("Value was either too large or too small for an Char.");
        }
        long l2 = Decimal.a(value);
        return (char)l2;
    }

    public static short to_ShortFromDecimal(Decimal value) {
        long l2 = Decimal.b(value);
        return (short)l2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static int to_UShortFromDecimal(Decimal value) {
        long l2 = Decimal.a(value);
        return (int)(l2 & 0xFFFFL);
    }

    public static int to_IntFromDecimal(Decimal value) {
        long l2 = Decimal.b(value);
        return (int)l2;
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long to_UIntFromDecimal(Decimal value) {
        long l2 = Decimal.a(value);
        return l2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public static long to_LongFromDecimal(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromLong(Long.MAX_VALUE))) {
            throw new OverflowException("Value was either too large or too small for an Int64.");
        }
        if (Decimal.op_LessThan(value, Decimal.newDecimalFromLong(Long.MIN_VALUE))) {
            throw new OverflowException("Value was either too large or too small for an Int64.");
        }
        return Decimal.b(value);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static long to_ULongFromDecimal(Decimal value) {
        return Decimal.a(value) & 0xFFFFFFFFFFFFFFFFL;
    }

    public static float to_FloatFromDecimal(Decimal value) {
        return value.q.floatValue();
    }

    public static double to_DoubleFromDecimal(Decimal value) {
        return value.q.doubleValue();
    }

    public static Decimal to_DecimalFromByte(byte value) {
        return Decimal.newDecimalFromInt(value & 0xFF);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static Decimal to_DecimalFromSByte(byte value) {
        return Decimal.newDecimalFromInt(value);
    }

    public static Decimal to_DecimalFromShort(short value) {
        return Decimal.newDecimalFromInt(value);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static Decimal to_DecimalFromUShort(int value) {
        return Decimal.newDecimalFromInt(value & 0xFFFF);
    }

    public static Decimal to_DecimalFromChar(char value) {
        return Decimal.newDecimalFromInt(value);
    }

    public static Decimal to_DecimalFromInt(int value) {
        return Decimal.newDecimalFromInt(value);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static Decimal to_DecimalFromUInt(long value) {
        return Decimal.newDecimalFromUInt(value);
    }

    public static Decimal to_DecimalFromLong(long value) {
        return Decimal.newDecimalFromLong(value);
    }

    @CLSCompliantAttribute(isCompliant=false)
    public static Decimal to_DecimalFromULong(long value) {
        return Decimal.newDecimalFromULong(value);
    }

    public static Decimal to_DecimalFromFloat(float value) {
        return Decimal.newDecimalFromFloat(value);
    }

    public static Decimal to_DecimalFromDouble(double value) {
        return Decimal.newDecimalFromDouble(value);
    }

    public static boolean op_Inequality(Decimal d1, Decimal d2) {
        return !Decimal.op_Equality(d1, d2);
    }

    public static boolean op_Equality(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return Decimal.equals(d1, d2);
    }

    public static boolean op_GreaterThan(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return Decimal.compare(d1, d2) > 0;
    }

    public static boolean op_GreaterThanOrEqual(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return Decimal.compare(d1, d2) >= 0;
    }

    public static boolean op_LessThan(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return Decimal.compare(d1, d2) < 0;
    }

    public static boolean op_LessThanOrEqual(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return Decimal.compare(d1, d2) <= 0;
    }

    public static boolean equals(Decimal d1, Decimal d2) {
        return Decimal.compare(d1, d2) == 0 || Decimal.a(d1, d2);
    }

    private static boolean a(Decimal decimal, Decimal decimal2) {
        int[] nArray;
        int[] nArray2 = Decimal.getBits(decimal);
        return nArray2[0] == (nArray = Decimal.getBits(decimal2))[0] && nArray2[1] == nArray[1] && nArray2[2] == nArray[2] && nArray2[3] == nArray[3];
    }

    public boolean equals(Object value) {
        if (!(value instanceof Decimal)) {
            if (value instanceof Integer) {
                return this.equals(Decimal.newDecimalFromInt(Convert.toInt32(value)));
            }
            if (value instanceof Long) {
                return this.equals(Decimal.newDecimalFromLong(Convert.toInt64(value)));
            }
            if (value instanceof Double) {
                return this.equals(Decimal.newDecimalFromDouble(Convert.toDouble(value)));
            }
            return false;
        }
        return Decimal.equals((Decimal)value, this);
    }

    public static Decimal floor(Decimal d2) {
        return new Decimal(d2.q.divide(BigDecimal.valueOf(1L), 0, 3));
    }

    public static Decimal truncate(Decimal d2) {
        if (Decimal.op_GreaterThan(d2, Zero)) {
            return Decimal.floor(d2);
        }
        return Decimal.negate(Decimal.floor(Decimal.negate(d2)));
    }

    public static Decimal round(Decimal d2, int decimals, short mode) {
        boolean bl2;
        if (mode != 0 && mode != 1) {
            throw new ArgumentException(StringExtensions.concat("The value '", Enum.getName(MidpointRounding.class, mode), "' is not valid for this usage of the type MidpointRounding."), "mode");
        }
        if (decimals < 0 || decimals > 28) {
            throw new ArgumentOutOfRangeException("decimals", "[0,28]");
        }
        boolean bl3 = bl2 = d2.q.signum() < 0;
        if (bl2) {
            d2 = Decimal.negate(d2);
        }
        Decimal decimal = Decimal.newDecimalFromDouble(msMath.pow(10.0, decimals));
        Decimal decimal2 = Decimal.floor(d2);
        Decimal decimal3 = Decimal.op_Subtraction(d2, decimal2);
        decimal3 = Decimal.multiply(decimal3, new Decimal("10000000000000000000000000000"));
        decimal3 = Decimal.floor(decimal3);
        decimal3 = Decimal.divide(decimal3, Decimal.op_Division(new Decimal("10000000000000000000000000000"), decimal));
        decimal3 = msMath.round(decimal3, mode);
        decimal3 = Decimal.divide(decimal3, decimal);
        Decimal decimal4 = Decimal.op_Addition(decimal2, decimal3);
        int n2 = mode == 1 ? 4 : 6;
        decimal4.q = decimal4.q.setScale(decimals, n2);
        if (bl2) {
            decimal4 = Decimal.negate(decimal4);
        }
        return decimal4;
    }

    public static Decimal round(Decimal d2) {
        return msMath.round(d2);
    }

    public static Decimal roundWithMode(Decimal d2, short mode) {
        return msMath.round(d2, mode);
    }

    public static Decimal round(Decimal d2, int decimals) {
        if (decimals < 0) {
            throw new ArgumentOutOfRangeException("decimals");
        }
        if (decimals > 28) {
            throw new ArgumentOutOfRangeException("decimals");
        }
        return new Decimal(d2.q.divide(BigDecimal.valueOf(1L), decimals, 6));
    }

    public static Decimal multiply(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d1.isZero() || d2.isZero()) {
            return Zero;
        }
        BigDecimal bigDecimal = d1.q.multiply(d2.q);
        if ((bigDecimal = bigDecimal.stripTrailingZeros()).scale() < 0) {
            bigDecimal = bigDecimal.setScale(0, 4);
        }
        return Decimal.fromJava(bigDecimal);
    }

    public static Decimal divide(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d2.isZero()) {
            throw new DivideByZeroException();
        }
        if (d1.isZero()) {
            return Zero;
        }
        BigDecimal bigDecimal = d1.q.divide(d2.q, 28, 4);
        if ((bigDecimal = bigDecimal.stripTrailingZeros()).scale() < 0) {
            bigDecimal = bigDecimal.setScale(0, 4);
        }
        return Decimal.fromJava(bigDecimal);
    }

    public static Decimal remainder(Decimal d1, Decimal d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d2.isZero()) {
            throw new DivideByZeroException();
        }
        if (d1.isZero()) {
            return Zero;
        }
        return Decimal.fromJava(d1.q.remainder(d2.q));
    }

    public static int compare(Decimal d1, Decimal d2) {
        return d1.q.compareTo(d2.q);
    }

    @Override
    public int compareTo(Decimal value) {
        return Decimal.compare(this, value);
    }

    public boolean equals(Decimal value) {
        return Decimal.equals(value, this);
    }

    public static Decimal ceiling(Decimal d2) {
        return msMath.ceiling(d2);
    }

    public static Decimal parse(String s2) {
        return Decimal.parse(s2, 111, null);
    }

    public static Decimal parse(String s2, int style) {
        return Decimal.parse(s2, style, null);
    }

    public static Decimal parse(String s2, IFormatProvider provider) {
        return Decimal.parse(s2, 111, provider);
    }

    public static Decimal parse(String s2, int style, IFormatProvider provider) {
        if (s2 == null) {
            throw new ArgumentNullException("s");
        }
        if ((style & 0x200) != 0) {
            throw new ArgumentException("Decimal.TryParse does not accept AllowHexSpecifier", "style");
        }
        Decimal decimal = null;
        Decimal[] decimalArray = new Decimal[]{decimal};
        Decimal.a(s2, style, provider, decimalArray, true);
        decimal = decimalArray[0];
        return decimal;
    }

    public static boolean tryParse(String s2, Decimal[] result) {
        if (s2 == null) {
            result[0] = Zero;
            return false;
        }
        try {
            return Decimal.a(s2, 111, null, result, false);
        }
        catch (Exception exception) {
            result[0] = Zero;
            return false;
        }
    }

    public static boolean tryParse(String s2, int style, IFormatProvider provider, Decimal[] result) {
        if (s2 == null || (style & 0x200) != 0) {
            result[0] = Zero;
            return false;
        }
        try {
            return Decimal.a(s2, style, provider, result, false);
        }
        catch (Exception exception) {
            result[0] = Zero;
            return false;
        }
    }

    static boolean a(String string, int n2, IFormatProvider iFormatProvider, Decimal[] decimalArray, boolean bl2) {
        NumberFormatInfo numberFormatInfo = iFormatProvider == null ? NumberFormatInfo.getInvariantInfo() : NumberFormatInfo.getInstance(iFormatProvider);
        if (StringExtensions.contains(string, "\u0000")) {
            string = StringExtensions.replace(string, "\u0000", "");
        }
        string = StringExtensions.trim(string);
        switch (n2) {
            case 111: {
                if (string.startsWith("(") && string.endsWith(")")) {
                    string = StringExtensions.substring(string, 1, string.length() - 2);
                    string = StringExtensions.trim(string);
                    string = numberFormatInfo.getNegativeSign() + string;
                }
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1 || numberFormatInfo.getNumberGroupSeparator().equals(numberFormatInfo.getNumberDecimalSeparator())) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
            case 7: 
            case 167: {
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
            case 383: {
                if (StringExtensions.indexOf(string, numberFormatInfo.getCurrencySymbol()) != -1) {
                    string = StringExtensions.replace(string, numberFormatInfo.getCurrencySymbol(), "");
                    string = StringExtensions.trim(string);
                }
                if (string.startsWith("(") && string.endsWith(")")) {
                    string = StringExtensions.substring(string, 1, string.length() - 2);
                    string = StringExtensions.trim(string);
                    string = numberFormatInfo.getNegativeSign() + string;
                }
                if (StringExtensions.indexOf(string, numberFormatInfo.getNumberGroupSeparator()) == -1) break;
                string = StringExtensions.replace(string, numberFormatInfo.getNumberGroupSeparator(), "");
                break;
            }
        }
        try {
            BigDecimal bigDecimal;
            if ((n2 & 0x20) == 0) {
                String string2 = null;
                string2 = (n2 & 0x100) != 0 ? numberFormatInfo.getCurrencyDecimalSeparator() : numberFormatInfo.getNumberDecimalSeparator();
                if (StringExtensions.contains(string, string2)) {
                    throw new FormatException();
                }
            } else {
                String string3 = null;
                string3 = (n2 & 0x100) != 0 ? numberFormatInfo.getCurrencyDecimalSeparator() : numberFormatInfo.getNumberDecimalSeparator();
                if (StringExtensions.indexOf(string, string3) != -1) {
                    string = StringExtensions.replace(string, string3, ".");
                }
            }
            if ((bigDecimal = new BigDecimal(string)).compareTo(Decimal.MaxValue.q) > 0 || bigDecimal.compareTo(Decimal.MinValue.q) < 0) {
                throw new OverflowException();
            }
            decimalArray[0] = Decimal.fromJava(bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException(numberFormatException.getMessage());
        }
        return true;
    }

    @Override
    public int getTypeCode() {
        return 15;
    }

    public static byte toByte(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(255)) || Decimal.op_LessThan(value, Zero)) {
            throw new OverflowException("Value is greater than Byte.MaxValue or less than Byte.MinValue");
        }
        return (byte)(Decimal.truncate((Decimal)value).q.byteValue() & 0xFF);
    }

    public static byte toSByte(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(127)) || Decimal.op_LessThan(value, Decimal.newDecimalFromInt(-128))) {
            throw new OverflowException("Value is greater than Byte.MaxValue or less than Byte.MinValue");
        }
        return Decimal.truncate((Decimal)value).q.byteValue();
    }

    public static double toDouble(Decimal d2) {
        return d2.q.doubleValue();
    }

    public static short toInt16(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(Short.MAX_VALUE)) || Decimal.op_LessThan(value, Decimal.newDecimalFromInt(Short.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int16.MaxValue or less than Int16.MinValue");
        }
        return Decimal.truncate((Decimal)value).q.shortValue();
    }

    public static int toUInt16(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(65535)) || Decimal.op_LessThan(value, Decimal.newDecimalFromInt(0))) {
            throw new OverflowException("Value is greater than UInt16.MaxValue or less than UInt16.MinValue");
        }
        return Decimal.truncate((Decimal)value).q.shortValue() & 0xFFFF;
    }

    public static int toInt32(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromInt(Integer.MAX_VALUE)) || Decimal.op_LessThan(value, Decimal.newDecimalFromInt(Integer.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int32.MaxValue or less than Int32.MinValue");
        }
        return Decimal.truncate((Decimal)value).q.intValue();
    }

    public static long toUInt32(Decimal value) {
        if (Decimal.op_GreaterThan(value, Decimal.newDecimalFromUInt(0xFFFFFFFFL)) || Decimal.op_LessThan(value, Decimal.newDecimalFromUInt(0L))) {
            throw new OverflowException("Value is greater than Int32.MaxValue or less than Int32.MinValue");
        }
        return (long)Decimal.truncate((Decimal)value).q.intValue() & 0xFFFFFFFFL;
    }

    public static long toInt64(Decimal d2) {
        if (Decimal.op_GreaterThan(d2, Decimal.newDecimalFromLong(Long.MAX_VALUE)) || Decimal.op_LessThan(d2, Decimal.newDecimalFromLong(Long.MIN_VALUE))) {
            throw new OverflowException("Value is greater than Int64.MaxValue or less than Int64.MinValue");
        }
        return Decimal.truncate((Decimal)d2).q.longValue();
    }

    public static long toUInt64(Decimal d2) {
        if (Decimal.op_GreaterThan(d2, new Decimal("18446744073709551615")) || Decimal.op_LessThan(d2, Decimal.newDecimalFromULong(0L))) {
            throw new OverflowException("Value is greater than UInt64.MaxValue or less than UInt64.MinValue");
        }
        return Decimal.truncate((Decimal)d2).q.longValue();
    }

    public static long toOACurrency(Decimal value) {
        return Decimal.op_Multiply((Decimal)value, (Decimal)Decimal.newDecimalFromInt((int)10000)).q.longValue();
    }

    public static float toSingle(Decimal d2) {
        return Convert.toSingle(d2);
    }

    @Override
    public Object toType(Type targetType, IFormatProvider provider) {
        if (targetType == null) {
            throw new ArgumentNullException("targetType");
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean toBoolean(IFormatProvider provider) {
        return Convert.toBoolean(this);
    }

    @Override
    public byte toByte(IFormatProvider provider) {
        return Convert.toByte(this);
    }

    @Override
    public char toChar(IFormatProvider provider) {
        throw new InvalidCastException();
    }

    @Override
    public DateTime toDateTime(IFormatProvider provider) {
        throw new InvalidCastException();
    }

    @Override
    public Decimal toDecimal(IFormatProvider provider) {
        return this;
    }

    public BigDecimal toBigDecimal(IFormatProvider provider) {
        return this.q.multiply(BigDecimal.ONE);
    }

    @Override
    public double toDouble(IFormatProvider provider) {
        return Convert.toDouble(this);
    }

    @Override
    public short toInt16(IFormatProvider provider) {
        return Convert.toInt16(this);
    }

    @Override
    public int toInt32(IFormatProvider provider) {
        return Convert.toInt32(this);
    }

    @Override
    public long toInt64(IFormatProvider provider) {
        return Convert.toInt64(this);
    }

    @Override
    public byte toSByte(IFormatProvider provider) {
        return Convert.toSByte(this);
    }

    @Override
    public float toSingle(IFormatProvider provider) {
        return Convert.toSingle(this);
    }

    @Override
    public int toUInt16(IFormatProvider provider) {
        return Convert.toUInt16(this);
    }

    @Override
    public long toUInt32(IFormatProvider provider) {
        return Convert.toUInt32(this);
    }

    @Override
    public long toUInt64(IFormatProvider provider) {
        return Convert.toUInt64(this);
    }

    @Override
    public String toString(String format, IFormatProvider provider) {
        return com.aspose.html.internal.ms.core.System.k.a(format, this, provider);
    }

    public String toString() {
        return this.toString("G", null);
    }

    public String toString(String format) {
        return this.toString(format, null);
    }

    @Override
    public String toString(IFormatProvider provider) {
        return this.toString("G", provider);
    }

    @Override
    public void CloneTo(Decimal that) {
        that.q = this.q;
    }

    @Override
    public Decimal Clone() {
        Decimal decimal = new Decimal();
        this.CloneTo(decimal);
        return decimal;
    }

    public Object clone() {
        return this.Clone();
    }

    public static Decimal fromJava(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return new Decimal();
        }
        int n2 = Decimal.a(bigDecimal);
        int n3 = bigDecimal.scale();
        if (n2 > 0 && n2 != n3 && n2 > 29 && n3 >= n2 - 29) {
            bigDecimal = bigDecimal.setScale(29 - (n2 - n3), 4);
        } else if (n3 > 28) {
            bigDecimal = bigDecimal.setScale(28, 4);
        }
        return new Decimal(bigDecimal);
    }

    public static BigDecimal toJava(Decimal d2) {
        if (d2 == null) {
            return null;
        }
        return d2.q;
    }
}

