/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.msArray;
import java.util.Arrays;

@SerializableAttribute
public class Stack
implements ICollection,
IEnumerable,
ICloneable {
    private Object[] a;
    private int b = -1;
    private int c;
    private int d;
    private int e;
    private static final int f = 16;

    private void a(int n2) {
        n2 = Math.max(n2, 16);
        Object[] objectArray = new Object[n2];
        Array.copy(Array.boxing(this.a), 0, Array.boxing(objectArray), 0, this.c);
        this.d = n2;
        this.a = objectArray;
    }

    public Stack() {
        this.a = new Object[16];
        this.d = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e2 : col) {
            this.push(e2);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.d = initialCapacity;
        this.a = new Object[this.d];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.e;
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.a[i2] = null;
        }
        this.c = 0;
        this.b = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(Array.boxing(this.a));
        stack.b = this.b;
        stack.c = this.c;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.c == 0) {
            return false;
        }
        if (obj == null) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                if (this.a[i2] != null) continue;
                return true;
            }
        } else {
            for (int i3 = 0; i3 < this.c; ++i3) {
                if (!obj.equals(this.a[i3])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.getRank() > 1 || array.getLength() > 0 && index >= array.getLength() || this.c > array.getLength() - index) {
            throw new ArgumentException();
        }
        for (int i2 = this.b; i2 != -1; --i2) {
            array.setValue(this.a[i2], this.c - (i2 + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.b == -1) {
            throw new InvalidOperationException();
        }
        return this.a[this.b];
    }

    public Object pop() {
        if (this.b == -1) {
            throw new InvalidOperationException();
        }
        ++this.e;
        Object object = this.a[this.b];
        this.a[this.b] = null;
        --this.c;
        --this.b;
        if (this.c <= this.d / 4 && this.c > 16) {
            this.a(this.d / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.e;
        if (this.d == this.c) {
            this.a(this.d * 2);
        }
        ++this.c;
        ++this.b;
        this.a[this.b] = obj;
    }

    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.c) {
            a2 = Arrays.copyOf(this.a, this.c, a2.getClass());
            msArray.reverse(a2);
            return a2;
        }
        System.arraycopy(this.a, 0, a2, 0, this.c);
        if (a2.length > this.c) {
            a2[this.c] = null;
        }
        msArray.reverse(a2);
        return a2;
    }

    private static class Enumerator
    implements IEnumerator,
    ICloneable,
    Cloneable {
        private static final int a = -1;
        private static final int b = -2;
        private Stack c;
        private int d;
        private int e;

        Enumerator(Stack s2) {
            this.c = s2;
            this.d = s2.e;
            this.e = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        @Override
        public Object next() {
            if (this.d != this.c.e || this.e == -2 || this.e == -1 || this.e > this.c.c) {
                throw new InvalidOperationException();
            }
            return this.c.a[this.e];
        }

        @Override
        public boolean hasNext() {
            if (this.d != this.c.e) {
                throw new InvalidOperationException();
            }
            switch (this.e) {
                case -2: {
                    this.e = this.c.b;
                    return this.e != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.e;
            return this.e != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.d != this.c.e) {
                throw new InvalidOperationException();
            }
            this.e = -2;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.c = this.c;
            enumerator.d = this.d;
            enumerator.e = this.e;
            return enumerator;
        }
    }

    @SerializableAttribute
    private static class SyncStack
    extends Stack {
        private Stack a;

        SyncStack(Stack s2) {
            this.a = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.a;
            synchronized (stack) {
                return this.a.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.a;
            synchronized (stack) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.a;
            synchronized (stack) {
                return Stack.sync((Stack)this.a.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.a;
            synchronized (stack) {
                return this.a.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int index) {
            Stack stack = this.a;
            synchronized (stack) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.a;
            synchronized (stack) {
                return new Enumerator(this.a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.a;
            synchronized (stack) {
                return this.a.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.a;
            synchronized (stack) {
                return this.a.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.a;
            synchronized (stack) {
                this.a.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            Stack stack = this.a;
            synchronized (stack) {
                return this.a.toArray(a2);
            }
        }
    }
}

