/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import java.util.Arrays;

@SerializableAttribute
public class Queue
implements ICollection,
IEnumerable,
ICloneable {
    private Object[] a;
    private int b = 0;
    private int c = 0;
    private int d = 0;
    private int e;
    private int f = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e2 : col) {
            this.enqueue(e2);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.a = new Object[capacity];
        this.e = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.c;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.getRank() > 1 || index != 0 && index >= array.getLength() || this.c > array.getLength() - index) {
            throw new ArgumentException();
        }
        int n2 = this.a.length;
        int n3 = n2 - this.b;
        Array.copy(Array.boxing(this.a), this.b, array, index, Math.min(this.c, n3));
        if (this.c > n3) {
            Array.copy(Array.boxing(this.a), 0, array, index + n3, this.c - n3);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.a.length);
        queue.e = this.e;
        Array.copy(Array.boxing(this.a), 0, Array.boxing(queue.a), 0, this.a.length);
        queue.b = this.b;
        queue.c = this.c;
        queue.d = this.d;
        return queue;
    }

    public void clear() {
        ++this.f;
        this.b = 0;
        this.c = 0;
        this.d = 0;
        for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
            this.a[i2] = null;
        }
    }

    public boolean contains(Object obj) {
        int n2 = this.b + this.c;
        if (obj == null) {
            for (int i2 = this.b; i2 < n2; ++i2) {
                if (this.a[i2 % this.a.length] != null) continue;
                return true;
            }
        } else {
            for (int i3 = this.b; i3 < n2; ++i3) {
                if (!obj.equals(this.a[i3 % this.a.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.f;
        if (this.c < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.a[this.b];
        this.a[this.b] = null;
        this.b = (this.b + 1) % this.a.length;
        --this.c;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.f;
        if (this.c == this.a.length) {
            this.a();
        }
        this.a[this.d] = obj;
        this.d = (this.d + 1) % this.a.length;
        ++this.c;
    }

    public Object peek() {
        if (this.c < 1) {
            throw new InvalidOperationException();
        }
        return this.a[this.b];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.c) {
            return Arrays.copyOf(this.a, this.c, a2.getClass());
        }
        System.arraycopy(this.a, 0, a2, 0, this.c);
        if (a2.length > this.c) {
            a2[this.c] = null;
        }
        return a2;
    }

    public void trimToSize() {
        ++this.f;
        Object[] objectArray = new Object[this.c];
        this.copyTo(Array.boxing(objectArray), 0);
        this.a = objectArray;
        this.b = 0;
        this.d = 0;
    }

    private void a() {
        int n2 = this.a.length * this.e / 100;
        if (n2 < this.a.length + 1) {
            n2 = this.a.length + 1;
        }
        Object[] objectArray = new Object[n2];
        this.copyTo(Array.boxing(objectArray), 0);
        this.a = objectArray;
        this.b = 0;
        this.d = this.b + this.c;
    }

    @SerializableAttribute
    private static class QueueEnumerator
    implements IEnumerator,
    ICloneable {
        private Queue a;
        private int b;
        private int c;

        QueueEnumerator(Queue q2) {
            this.a = q2;
            this.b = q2.f;
            this.c = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.a);
            queueEnumerator.b = this.b;
            queueEnumerator.c = this.c;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.b != this.a.f || this.c < 0 || this.c >= this.a.c) {
                throw new InvalidOperationException();
            }
            return this.a.a[(this.a.b + this.c) % this.a.a.length];
        }

        @Override
        public boolean hasNext() {
            if (this.b != this.a.f) {
                throw new InvalidOperationException();
            }
            if (this.c >= this.a.c - 1) {
                this.c = Integer.MAX_VALUE;
                return false;
            }
            ++this.c;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.b != this.a.f) {
                throw new InvalidOperationException();
            }
            this.c = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private Queue a;

        SyncQueue(Queue queue) {
            this.a = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int index) {
            Queue queue = this.a;
            synchronized (queue) {
                this.a.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.a;
            synchronized (queue) {
                return new SyncQueue((Queue)this.a.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.a;
            synchronized (queue) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.a;
            synchronized (queue) {
                this.a.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.a;
            synchronized (queue) {
                this.a.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a2) {
            Queue queue = this.a;
            synchronized (queue) {
                return this.a.toArray(a2);
            }
        }
    }
}

