/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEqualityComparer;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IDictionary;
import com.aspose.html.internal.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IHashCodeProvider;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Runtime.Serialization.IDeserializationCallback;
import com.aspose.html.internal.ms.System.Runtime.Serialization.ISerializable;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationException;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationInfo;
import com.aspose.html.internal.ms.System.Runtime.Serialization.SerializationInfoEnumerator;
import com.aspose.html.internal.ms.System.Runtime.Serialization.StreamingContext;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Threading.Thread;
import com.aspose.html.internal.ms.core.mscorlib.a.a;
import com.aspose.html.internal.ms.core.mscorlib.a.b;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@SerializableAttribute
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
ICloneable,
IDeserializationCallback,
ISerializable,
Map {
    private IGenericEqualityComparer a;
    private Object b = new Object();
    private Bucket[] c;
    private int d;
    private volatile boolean e;
    private ICollection f;
    private float g;
    private int h;
    private SerializationInfo i;
    private int j;
    private ICollection k;
    private volatile int l;
    private static final StringSwitchMap m = new StringSwitchMap("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d2) {
        this(d2, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d2, IGenericEqualityComparer equalityComparer) {
        this(d2, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d2, float loadFactor) {
        this(d2, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", StringExtensions.format("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.g = 0.72f * loadFactor;
        double d2 = (float)capacity / this.g;
        if (d2 > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n2 = d2 > 11.0 ? com.aspose.html.internal.ms.core.mscorlib.a.a.a((int)d2) : 11;
        this.c = this.b(n2);
        this.h = (int)(this.g * (float)n2);
        this.e = false;
    }

    protected Hashtable(SerializationInfo info, StreamingContext context) {
        this.i = info;
    }

    @Deprecated
    public Hashtable(IDictionary d2, IHashCodeProvider hcp, Comparator comparer) {
        this(d2, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d2, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d2 != null ? d2.size() : 0, loadFactor, equalityComparer);
        if (d2 == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d2.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.a = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d2, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d2 != null ? d2.size() : 0, loadFactor, hcp, comparer);
        if (d2 == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d2.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.a = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.a(key, value, true);
    }

    @Override
    public void clear() {
        if (this.d != 0) {
            this.e = true;
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2].c = 0;
                this.c[i2].a = null;
                this.c[i2].b = null;
            }
            this.d = 0;
            this.j = 0;
            this.d();
            this.e = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.c;
        Hashtable hashtable = new Hashtable(this.d, this.a);
        hashtable.l = this.l;
        hashtable.g = this.g;
        hashtable.d = 0;
        int n2 = this.c.length;
        while (n2 > 0) {
            Object object = bucketArray[--n2].a;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n2].b);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l2 = 0L;
        long l3 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.c;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l4 = this.a(key, this.c.length, lArray, lArray2);
        l2 = lArray[0];
        l3 = lArray2[0];
        int n2 = 0;
        int n3 = (int)((l2 & 0xFFFFFFFFL) % (long)this.c.length);
        do {
            bucketArray[n3].a(bucket);
            if (bucket.a == null) {
                return false;
            }
            if ((long)(bucket.c & Integer.MAX_VALUE) == (l4 & 0xFFFFFFFFL) && this.keyEquals(bucket.a, key)) {
                return true;
            }
            n3 = (int)(((long)n3 + (l3 & 0xFFFFFFFFL)) % (long)this.c.length);
        } while (bucket.c < 0 && ++n2 < this.c.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n2 = this.c.length;
            while (--n2 >= 0) {
                if (this.c[n2].a == null || this.c[n2].a == this.c || this.c[n2].b != null) continue;
                return true;
            }
        } else {
            int n3 = this.c.length;
            while (--n3 >= 0) {
                Object object = this.c[n3].b;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void c(Array array, int n2) {
        Bucket[] bucketArray = this.c;
        int n3 = this.c.length;
        while (--n3 >= 0) {
            Object object = bucketArray[n3].a;
            if (object == null || object == this.c) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n3].b);
            array.setValue((Object)dictionaryEntry.Clone(), n2++);
        }
    }

    void a(Array array, int n2) {
        Bucket[] bucketArray = this.c;
        int n3 = this.c.length;
        while (--n3 >= 0) {
            Object object = bucketArray[n3].a;
            if (object == null || object == this.c) continue;
            array.setValue(object, n2++);
        }
    }

    @Override
    public void copyTo(Array array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.getRank() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.getLength() - arrayIndex < this.d) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.c(array, arrayIndex);
    }

    void b(Array array, int n2) {
        Bucket[] bucketArray = this.c;
        int n3 = this.c.length;
        while (--n3 >= 0) {
            Object object = bucketArray[n3].a;
            if (object == null || object == this.c) continue;
            array.setValue(bucketArray[n3].b, n2++);
        }
    }

    private void b() {
        int n2 = com.aspose.html.internal.ms.core.mscorlib.a.a.a(this.c.length * 2);
        this.a(n2);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.a != null) {
            return this.a.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(SerializationInfo info, StreamingContext context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.addValue("LoadFactor", this.g);
        info.addValue("Version", this.l);
        if (this.a == null) {
            info.addValue("Comparer", null, Operators.typeOf(Comparator.class));
            info.addValue("HashCodeProvider", null, Operators.typeOf(IHashCodeProvider.class));
        } else if (this.a instanceof CompatibleComparer) {
            objectArray = Operators.as(this.a, CompatibleComparer.class);
            info.addValue("Comparer", objectArray.a(), Operators.typeOf(Comparator.class));
            info.addValue("HashCodeProvider", objectArray.b(), Operators.typeOf(IHashCodeProvider.class));
        } else {
            info.addValue("KeyComparer", this.a, Operators.typeOf(IGenericEqualityComparer.class));
        }
        info.addValue("HashSize", this.c.length);
        objectArray = new Object[this.d];
        Object[] objectArray2 = new Object[this.d];
        this.a(Array.boxing(objectArray), 0);
        this.b(Array.boxing(objectArray2), 0);
        info.addValue("Keys", objectArray, Operators.typeOf(Object[].class));
        info.addValue("Values", objectArray2, Operators.typeOf(Object[].class));
    }

    private long a(Object object, int n2, long[] lArray, long[] lArray2) {
        long l2;
        lArray[0] = l2 = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n2 - 1);
        return l2;
    }

    private void a(Object object, Object object2, boolean bl2) {
        block12: {
            long l2 = 0L;
            long l3 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.d >= this.h) {
                this.b();
            } else if (this.j > this.h && this.d > 100) {
                this.c();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l4 = this.a(object, this.c.length, lArray, lArray2);
            l2 = lArray[0];
            l3 = lArray2[0];
            int n2 = 0;
            int n3 = -1;
            int n4 = (int)((l2 & 0xFFFFFFFFL) % (long)this.c.length);
            do {
                if (n3 == -1 && this.c[n4].a == this.c && this.c[n4].c < 0) {
                    n3 = n4;
                }
                if (this.c[n4].a == null || this.c[n4].a == this.c && ((long)this.c[n4].c & 0x80000000L) == 0L) {
                    if (n3 != -1) {
                        n4 = n3;
                    }
                    this.e = true;
                    this.c[n4].b = object2;
                    this.c[n4].a = object;
                    this.c[n4].c |= (int)(l4 & 0xFFFFFFFFL);
                    ++this.d;
                    this.d();
                    this.e = false;
                    break block12;
                }
                if ((long)(this.c[n4].c & Integer.MAX_VALUE) == (l4 & 0xFFFFFFFFL) && this.keyEquals(this.c[n4].a, object)) {
                    if (bl2) {
                        throw new ArgumentException(StringExtensions.format("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.c[n4].a, object));
                    }
                    this.e = true;
                    this.c[n4].b = object2;
                    this.d();
                    this.e = false;
                    break block12;
                }
                if (n3 == -1 && this.c[n4].c >= 0) {
                    this.c[n4].c = (int)((long)this.c[n4].c | Integer.MIN_VALUE);
                    ++this.j;
                }
                n4 = (int)(((long)n4 + (l3 & 0xFFFFFFFFL)) % (long)this.c.length);
            } while (++n2 < this.c.length);
            if (n3 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.e = true;
            this.c[n3].b = object2;
            this.c[n3].a = object;
            this.c[n3].c |= (int)(l4 & 0xFFFFFFFFL);
            ++this.d;
            this.d();
            this.e = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (ObjectExtensions.referenceEquals(this.c, item)) {
            return false;
        }
        if (this.a != null) {
            return this.a.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.c == null) {
            if (this.i == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n2 = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            SerializationInfoEnumerator serializationInfoEnumerator = this.i.iterator();
            while (serializationInfoEnumerator.hasNext()) {
                switch (m.of(serializationInfoEnumerator.getName())) {
                    case 0: {
                        this.g = this.i.getSingle("LoadFactor");
                        break;
                    }
                    case 1: {
                        n2 = this.i.getInt32("HashSize");
                        break;
                    }
                    case 2: {
                        this.a = (IGenericEqualityComparer)this.i.getValue("KeyComparer", Operators.typeOf(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.i.getValue("Comparer", Operators.typeOf(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.i.getValue("HashCodeProvider", Operators.typeOf(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.i.getValue("Keys", Operators.typeOf(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.i.getValue("Values", Operators.typeOf(Object[].class));
                    }
                }
            }
            this.h = (int)(this.g * (float)n2);
            if (this.a == null && (comparator != null || iHashCodeProvider != null)) {
                this.a = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.c = this.b(n2);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.a(objectArray[i2], objectArray2[i2], true);
            }
            this.l = this.i.getInt32("Version");
            this.i = null;
        }
    }

    private void a(Bucket[] bucketArray, Object object, Object object2, int n2) {
        long l2 = n2;
        long l3 = 1L + (((l2 & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n3 = (int)((l2 & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n3].a == null || bucketArray[n3].a == this.c) {
                bucketArray[n3].b = object2;
                bucketArray[n3].a = object;
                bucketArray[n3].c |= n2;
                break;
            }
            if (bucketArray[n3].c >= 0) {
                bucketArray[n3].c = (int)((long)bucketArray[n3].c | Integer.MIN_VALUE);
                ++this.j;
            }
            n3 = (int)(((long)n3 + (l3 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void c() {
        this.a(this.c.length);
    }

    private void a(int n2) {
        this.j = 0;
        Bucket[] bucketArray = this.b(n2);
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            Bucket bucket = this.c[i2].a();
            if (bucket.a == null || bucket.a == this.c) continue;
            this.a(bucketArray, bucket.a, bucket.b, bucket.c & Integer.MAX_VALUE);
        }
        this.e = true;
        this.c = bucketArray;
        this.h = (int)(this.g * (float)n2);
        this.d();
        this.e = false;
    }

    @Override
    public void removeItem(Object key) {
        long l2 = 0L;
        long l3 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l4 = this.a(key, this.c.length, lArray, lArray2);
        l2 = lArray[0];
        l3 = lArray2[0];
        int n2 = 0;
        int n3 = (int)((l2 & 0xFFFFFFFFL) % (long)this.c.length);
        do {
            this.c[n3].a(bucket);
            if ((long)(bucket.c & Integer.MAX_VALUE) == (l4 & 0xFFFFFFFFL) && this.keyEquals(bucket.a, key)) {
                this.e = true;
                this.c[n3].c = (int)((long)this.c[n3].c & Integer.MIN_VALUE);
                this.c[n3].a = this.c[n3].c != 0 ? this.c : null;
                this.c[n3].b = null;
                --this.d;
                this.d();
                this.e = false;
                break;
            }
            n3 = (int)(((long)n3 + (l3 & 0xFFFFFFFFL)) % (long)this.c.length);
        } while (bucket.c < 0 && ++n2 < this.c.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] a() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.d];
        int n2 = 0;
        Bucket[] bucketArray = this.c;
        int n3 = this.c.length;
        while (--n3 >= 0) {
            Object object = bucketArray[n3].a;
            if (object == null || object == this.c) continue;
            keyValuePairsArray[n2++] = new KeyValuePairs(object, bucketArray[n3].b);
        }
        return keyValuePairsArray;
    }

    private void d() {
        ++this.l;
    }

    private Bucket[] b(int n2) {
        Bucket[] bucketArray = new Bucket[n2];
        for (int i2 = 0; i2 < bucketArray.length; ++i2) {
            bucketArray[i2] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.d;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.a;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l2 = 0L;
        long l3 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.c;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l4 = this.a(key, this.c.length, lArray, lArray2);
        l2 = lArray[0];
        l3 = lArray2[0];
        int n2 = 0;
        int n3 = (int)((l2 & 0xFFFFFFFFL) % (long)this.c.length);
        do {
            int n4;
            int n5 = 0;
            do {
                n4 = this.l;
                bucketArray[n3].a(bucket);
                if (++n5 % 8 != 0) continue;
                Thread.sleep(1);
            } while (this.e || n4 != this.l);
            if (bucket.a == null) break;
            if ((long)(bucket.c & Integer.MAX_VALUE) == (l4 & 0xFFFFFFFFL) && this.keyEquals(bucket.a, key)) {
                return bucket.b;
            }
            n3 = (int)(((long)n3 + (l3 & 0xFFFFFFFFL)) % (long)this.c.length);
        } while (bucket.c < 0 && ++n2 < this.c.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.a(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.f == null) {
            this.f = new KeyCollection(this);
        }
        return this.f;
    }

    @Override
    public Object getSyncRoot() {
        return this.b;
    }

    @Override
    public ICollection getValues() {
        if (this.k == null) {
            this.k = new ValueCollection(this);
        }
        return this.k;
    }

    @Override
    public boolean isEmpty() {
        return this.d == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m2) {
        Set set = m2.keySet();
        for (Object k2 : set) {
            Object v2 = m2.get(k2);
            this.put(k2, v2);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        Array array = Array.boxing(objectArray);
        this.getKeys().copyTo(array, 0);
        return new ReadOnlyItemCollection(array);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        Array array = Array.boxing(objectArray);
        this.getValues().copyTo(array, 0);
        return new ReadOnlyItemCollection(array);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.a();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            entryArray[i2] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i2].a(), keyValuePairsArray[i2].b());
        }
        return new ReadOnlyItemCollection(Array.boxing(entryArray));
    }

    public int getVersion() {
        return this.l;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new b(map);
    }

    public static Map toJava(Hashtable h2) {
        return h2;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private Array b;

        ReadOnlyItemCollection(Array items) {
            this.b = items;
        }

        @Override
        public int size() {
            return this.b.size();
        }

        @Override
        public boolean isEmpty() {
            return this.b.size() == 0;
        }

        @Override
        public boolean contains(Object o2) {
            return this.b.contains(o2);
        }

        @Override
        public Iterator iterator() {
            return this.b.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            Array array = Array.boxing(objectArray);
            this.b.copyTo(array, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o2) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o2) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c2) {
            for (Object e2 : c2) {
                if (this.contains(e2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c2) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c2) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c2) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a2) {
            if (a2.length <= this.size()) {
                a2 = new Object[this.size()];
            }
            this.b.copyTo(Array.boxing(a2), 0);
            return a2;
        }
    }

    private static class HashtableDebugView {
        private Hashtable a;

        public HashtableDebugView(Hashtable hashtable) {
            if (hashtable == null) {
                throw new ArgumentNullException("hashtable");
            }
            this.a = hashtable;
        }

        public KeyValuePairs[] a() {
            return this.a.a();
        }
    }

    @SerializableAttribute
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable a;

        SyncHashtable(Hashtable table) {
            super(false);
            this.a = table;
        }

        SyncHashtable(SerializationInfo info, StreamingContext context) {
            super(info, context.Clone());
            this.a = (Hashtable)info.getValue("ParentTable", Operators.typeOf(Hashtable.class));
            if (this.a == null) {
                throw new SerializationException("Insufficient state to return the real object");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.a.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.a.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.a.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int arrayIndex) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public void getObjectData(SerializationInfo info, StreamingContext context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.addValue("ParentTable", this.a, Operators.typeOf(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] a() {
            return this.a.a();
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.a.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                this.a.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                return this.a.getValues();
            }
        }
    }

    @SerializableAttribute
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable a;

        ValueCollection(Hashtable hashtable) {
            this.a = hashtable;
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.getRank() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.getLength() - arrayIndex < this.a.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.a.b(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.a, 2);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }
    }

    @SerializableAttribute
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable a;

        KeyCollection(Hashtable hashtable) {
            this.a = hashtable;
        }

        @Override
        public void copyTo(Array array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.getRank() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.getLength() - arrayIndex < this.a.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.a.a(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.a, 1);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }
    }

    @SerializableAttribute
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int d;
        private boolean e;
        private Object f;
        private Object g;
        static final int a = 3;
        private int h;
        private Hashtable i;
        static final int b = 1;
        static final int c = 2;
        private int j;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.i = hashtable;
            this.d = hashtable.c.length;
            this.j = hashtable.l;
            this.e = false;
            this.h = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.j != this.i.l) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.d > 0) {
                --this.d;
                Object object = ((Hashtable)this.i).c[this.d].a;
                if (object == null || object == this.i.c) continue;
                this.f = object;
                this.g = ((Hashtable)this.i).c[this.d].b;
                this.e = true;
                return true;
            }
            this.e = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.j != this.i.l) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.e = false;
            this.d = this.i.c.length;
            this.f = null;
            this.g = null;
        }

        @Override
        public Object next() {
            if (!this.e) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.h == 1) {
                return this.f;
            }
            if (this.h == 2) {
                return this.g;
            }
            return new DictionaryEntry(this.f, this.g);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.e) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.f, this.g);
        }

        @Override
        public Object getKey() {
            if (!this.e) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.f;
        }

        @Override
        public Object getValue() {
            if (!this.e) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.g;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object a;
        private Object b;

        public KeyValuePairs(Object key, Object value) {
            this.b = value;
            this.a = key;
        }

        public Object a() {
            return this.a;
        }

        public Object b() {
            return this.b;
        }
    }

    private static class Bucket
    extends Struct<Bucket> {
        public Object a;
        public Object b;
        public int c;

        public void a(Bucket bucket) {
            bucket.a = this.a;
            bucket.b = this.b;
            bucket.c = this.c;
        }

        public Bucket a() {
            Bucket bucket = new Bucket();
            this.a(bucket);
            return bucket;
        }

        public Object clone() {
            return this.a();
        }

        private boolean b(Bucket bucket) {
            return ObjectExtensions.equals(bucket.a, this.a) && ObjectExtensions.equals(bucket.b, this.b) && bucket.c == this.c;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (ObjectExtensions.referenceEquals(null, obj)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.b((Bucket)obj);
        }

        public static boolean a(Bucket bucket, Bucket bucket2) {
            return bucket.equals(bucket2);
        }

        public int hashCode() {
            int n2 = this.a != null ? this.a.hashCode() : 0;
            n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
            n2 = 31 * n2 + this.c;
            return n2;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.a();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.a((Bucket)object);
        }
    }

    @SerializableAttribute
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator a;
        private IHashCodeProvider b;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.a = comparer;
            this.b = hashCodeProvider;
        }

        public int a(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.a != null) {
                return this.a.compare(object, object2);
            }
            Comparable comparable = Operators.as(object, Comparable.class);
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        public boolean equals(Object a2, Object b2) {
            return this.a(a2, b2) == 0;
        }

        public int hashCode(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.b != null) {
                return this.b.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator a() {
            return this.a;
        }

        IHashCodeProvider b() {
            return this.b;
        }
    }
}

