/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.StringExtensions;
import java.util.HashMap;
import java.util.Map;

public final class Char {
    public static final char MaxValue = '\uffff';
    public static final char MinValue = '\u0000';
    private static Map<Integer, Integer> a = new HashMap<Integer, Integer>();

    private static void a(int n2, int n3, int n4) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            a.put(i2, n4);
        }
    }

    public static int compareTo(char value, char compareToValue) {
        return value - compareToValue;
    }

    public static int compareTo(char value, Object compareToValue) {
        if (compareToValue == null) {
            return 1;
        }
        if (compareToValue.getClass() != Character.class) {
            throw new ArgumentException("Value is not a System.Char");
        }
        return value - Convert.toChar(compareToValue);
    }

    public static String convertFromUtf32(int utf32) {
        if (utf32 < 0 || utf32 > 0x10FFFF) {
            throw new ArgumentOutOfRangeException("utf32", "The argument must be from 0 to 0x10FFFF.");
        }
        if (55296 <= utf32 && utf32 <= 57343) {
            throw new ArgumentOutOfRangeException("utf32", "The argument must not be in surrogate pair range.");
        }
        if (utf32 < 65536) {
            return StringExtensions.newString((char)utf32, 1);
        }
        return StringExtensions.newString(new char[]{(char)(((utf32 -= 65536) >> 10) + 55296), (char)(utf32 % 1024 + 56320)});
    }

    public static int convertToUtf32(char highSurrogate, char lowSurrogate) {
        if (highSurrogate < '\ud800' || '\udbff' < highSurrogate) {
            throw new ArgumentOutOfRangeException("highSurrogate");
        }
        if (lowSurrogate < '\udc00' || '\udfff' < lowSurrogate) {
            throw new ArgumentOutOfRangeException("lowSurrogate");
        }
        return 65536 + (highSurrogate - 55296 << 10) + (lowSurrogate - 56320);
    }

    public static int convertToUtf32(String s2, int index) {
        Char.a(s2, index);
        if (!Char.isSurrogate(s2.charAt(index))) {
            return s2.charAt(index);
        }
        if (!Char.isHighSurrogate(s2.charAt(index)) || index == s2.length() - 1 || !Char.isLowSurrogate(s2.charAt(index + 1))) {
            throw new ArgumentException(StringExtensions.format("The string contains invalid surrogate pair character at {0}", index));
        }
        return Char.convertToUtf32(s2.charAt(index), s2.charAt(index + 1));
    }

    public static boolean equals(char value, char obj) {
        return value == obj;
    }

    public static boolean equals(char value, Object obj) {
        return obj.getClass() == Character.class && value == Convert.toChar(obj);
    }

    public static int getHashCode(char value) {
        return value | value << 16;
    }

    public static double getNumericValue(char c2) {
        return Character.getNumericValue(c2);
    }

    public static double getNumericValue(String s2, int index) {
        Char.a(s2, index);
        return Character.getNumericValue(s2.charAt(index));
    }

    public int getTypeCode() {
        return 4;
    }

    public static int getUnicodeCategory(char c2) {
        if (a.containsKey(c2)) {
            return a.get(c2);
        }
        int n2 = Character.getType(c2);
        return Char.a(n2);
    }

    private static int a(int n2) {
        int n3;
        switch (n2) {
            case 8: {
                n3 = 6;
                break;
            }
            case 23: {
                n3 = 18;
                break;
            }
            case 15: {
                n3 = 14;
                break;
            }
            case 26: {
                n3 = 26;
                break;
            }
            case 20: {
                n3 = 19;
                break;
            }
            case 9: {
                n3 = 8;
                break;
            }
            case 7: {
                n3 = 7;
                break;
            }
            case 22: {
                n3 = 21;
                break;
            }
            case 30: {
                n3 = 23;
                break;
            }
            case 16: {
                n3 = 15;
                break;
            }
            case 29: {
                n3 = 22;
                break;
            }
            case 10: {
                n3 = 9;
                break;
            }
            case 13: {
                n3 = 12;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 25: {
                n3 = 25;
                break;
            }
            case 4: {
                n3 = 3;
                break;
            }
            case 27: {
                n3 = 27;
                break;
            }
            case 6: {
                n3 = 5;
                break;
            }
            case 5: {
                n3 = 4;
                break;
            }
            case 11: {
                n3 = 10;
                break;
            }
            case 24: {
                n3 = 24;
                break;
            }
            case 28: {
                n3 = 28;
                break;
            }
            case 14: {
                n3 = 13;
                break;
            }
            case 18: {
                n3 = 17;
                break;
            }
            case 12: {
                n3 = 11;
                break;
            }
            case 21: {
                n3 = 20;
                break;
            }
            case 19: {
                n3 = 16;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            default: {
                n3 = 29;
                break;
            }
            case 1: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static int getUnicodeCategory(String s2, int index) {
        Char.a(s2, index);
        if (Char.a(s2.charAt(index))) {
            return Char.getUnicodeCategory(s2.charAt(index));
        }
        return Char.a(Character.getType(Character.codePointAt(s2, index)));
    }

    public static boolean isControl(char ch2) {
        return Char.getUnicodeCategory(ch2) == 14;
    }

    public static boolean isControl(String s2, int index) {
        return Char.getUnicodeCategory(s2, index) == 14;
    }

    public static boolean isDigit(char ch2) {
        return Char.getUnicodeCategory(ch2) == 8;
    }

    public static boolean isDigit(String s2, int index) {
        return Char.getUnicodeCategory(s2, index) == 8;
    }

    public static boolean isHighSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udbff';
    }

    public static boolean isHighSurrogate(String s2, int index) {
        Char.a(s2, index);
        return Char.isHighSurrogate(s2.charAt(index));
    }

    private static boolean a(char c2) {
        return c2 <= '\u00ff';
    }

    public static boolean isLetter(char c2) {
        return Char.getUnicodeCategory(c2) <= 4;
    }

    public static boolean isLetter(String s2, int index) {
        Char.a(s2, index);
        return Char.isLetter(s2.charAt(index));
    }

    public static boolean isLetterOrDigit(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 <= 4 || n2 == 8;
    }

    public static boolean isLetterOrDigit(String s2, int index) {
        Char.a(s2, index);
        return Char.isLetterOrDigit(s2.charAt(index));
    }

    public static boolean isLower(char c2) {
        return Char.getUnicodeCategory(c2) == 1;
    }

    public static boolean isLower(String s2, int index) {
        Char.a(s2, index);
        return Char.isLower(s2.charAt(index));
    }

    public static boolean isLowSurrogate(char c2) {
        return c2 >= '\udc00' && c2 <= '\udfff';
    }

    public static boolean isLowSurrogate(String s2, int index) {
        Char.a(s2, index);
        return Char.isLowSurrogate(s2.charAt(index));
    }

    public static boolean isNumber(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 8 && n2 <= 10;
    }

    public static boolean isNumber(String s2, int index) {
        Char.a(s2, index);
        return Char.isNumber(s2.charAt(index));
    }

    public static boolean isPunctuation(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 18 && n2 <= 24;
    }

    public static boolean isPunctuation(String s2, int index) {
        Char.a(s2, index);
        return Char.isPunctuation(s2.charAt(index));
    }

    public static boolean isSeparator(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 11 && n2 <= 13;
    }

    public static boolean isSeparator(String s2, int index) {
        Char.a(s2, index);
        return Char.isSeparator(s2.charAt(index));
    }

    public static boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    public static boolean isSurrogate(String s2, int index) {
        Char.a(s2, index);
        return Char.isSurrogate(s2.charAt(index));
    }

    public static boolean isSurrogatePair(char highSurrogate, char lowSurrogate) {
        if (highSurrogate < '\ud800' || highSurrogate > '\udbff') {
            return false;
        }
        return lowSurrogate >= '\udc00' && lowSurrogate <= '\udfff';
    }

    public static boolean isSurrogatePair(String s2, int index) {
        Char.a(s2, index);
        return index + 1 < s2.length() && Char.isSurrogatePair(s2.charAt(index), s2.charAt(index + 1));
    }

    public static boolean isSymbol(char c2) {
        int n2 = Char.getUnicodeCategory(c2);
        return n2 >= 25 && n2 <= 28;
    }

    public static boolean isSymbol(String s2, int index) {
        Char.a(s2, index);
        return Char.isSymbol(s2.charAt(index));
    }

    public static boolean isUpper(char c2) {
        return Char.getUnicodeCategory(c2) == 0;
    }

    public static boolean isUpper(String s2, int index) {
        Char.a(s2, index);
        return Char.isUpper(s2.charAt(index));
    }

    public static boolean isWhiteSpace(char c2) {
        if (c2 < '\u1680') {
            return c2 == ' ' || c2 >= '\t' && c2 <= '\r' || c2 == '\u0085' || c2 == '\u00a0';
        }
        int n2 = Char.a(Character.getType(c2));
        return n2 > 10 && n2 <= 13 && c2 != '\u200b';
    }

    public static boolean isWhiteSpace(String s2, int index) {
        Char.a(s2, index);
        return Char.isWhiteSpace(s2.charAt(index));
    }

    public static char parse(String s2) {
        if (s2 == null) {
            throw new ArgumentNullException("s");
        }
        if (s2.length() != 1) {
            throw new FormatException("s contains more than one character.");
        }
        return s2.charAt(0);
    }

    public static char toLower(char c2) {
        return Char.toLower(c2, CultureInfo.getCurrentCulture());
    }

    public static char toLower(char c2, CultureInfo culture) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return culture.getTextInfo().toLower(c2);
    }

    public static char toLowerInvariant(char c2) {
        return Character.toLowerCase(c2);
    }

    public static String toString(char value) {
        return StringExtensions.newString(value, 1);
    }

    public static String toString(char value, IFormatProvider provider) {
        return Char.toString(value);
    }

    public static char toUpper(char c2) {
        return Char.toUpper(c2, CultureInfo.getCurrentCulture());
    }

    public static char toUpper(char c2, CultureInfo culture) {
        if (culture == null) {
            throw new ArgumentNullException("culture");
        }
        return culture.getTextInfo().toUpper(c2);
    }

    public static char toUpperInvariant(char c2) {
        return Character.toUpperCase(c2);
    }

    public static boolean tryParse(String s2, char[] result) {
        if (s2 == null || s2.length() != 1) {
            result[0] = '\u0000';
            return false;
        }
        result[0] = s2.charAt(0);
        return true;
    }

    private static void a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("s");
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("The value of index is less than zero, or greater than or equal to the length of s.");
        }
    }

    static {
        Char.a(2209, 2228, 4);
        Char.a(3558, 3567, 8);
        Char.a(5024, 5109, 0);
        Char.a(5112, 5117, 1);
        Char.a(5873, 5880, 4);
        Char.a(6576, 6592, 4);
        Char.a(6832, 6845, 5);
        Char.a(7084, 7085, 5);
        Char.a(7655, 7669, 5);
        Char.a(8294, 8297, 15);
        Char.a(8379, 8382, 26);
        Char.a(8586, 8587, 28);
        Char.a(9204, 9210, 28);
        Char.a(11085, 11087, 28);
        Char.a(11098, 11123, 28);
        Char.a(11126, 11157, 28);
        Char.a(11160, 11193, 28);
        Char.a(11197, 11208, 28);
        Char.a(11210, 11217, 28);
        Char.a(11244, 11247, 28);
        Char.a(11836, 11839, 24);
        Char.a(40909, 40917, 4);
        Char.a(42900, 42901, 1);
        Char.a(42923, 42925, 0);
        Char.a(42928, 42935, 0);
        Char.a(43488, 43492, 4);
        Char.a(43495, 43503, 4);
        Char.a(43504, 43513, 8);
        Char.a(43514, 43518, 4);
        Char.a(43646, 43647, 4);
        Char.a(43824, 43866, 1);
        Char.a(43868, 43871, 3);
        Char.a(43872, 43877, 1);
        Char.a(43888, 43967, 1);
        Char.a(65063, 65071, 5);
        a.put(167, 28);
        a.put(170, 1);
        a.put(173, 19);
        a.put(182, 28);
        a.put(186, 1);
        a.put(895, 0);
        a.put(1320, 0);
        a.put(1321, 1);
        a.put(1322, 0);
        a.put(1323, 1);
        a.put(1324, 0);
        a.put(1325, 1);
        a.put(1326, 0);
        a.put(1327, 1);
        a.put(1421, 28);
        a.put(1422, 28);
        a.put(1541, 15);
        a.put(1564, 15);
        a.put(2275, 5);
        a.put(2303, 5);
        a.put(2424, 4);
        a.put(2432, 4);
        a.put(2809, 4);
        a.put(3072, 5);
        a.put(3124, 4);
        a.put(3162, 4);
        a.put(3201, 5);
        a.put(3329, 5);
        a.put(3423, 4);
        a.put(6158, 15);
        a.put(6429, 4);
        a.put(6430, 4);
        a.put(6430, 4);
        a.put(6600, 4);
        a.put(6601, 4);
        a.put(6683, 5);
        a.put(6846, 7);
        a.put(7416, 5);
        a.put(7417, 5);
        a.put(8968, 20);
        a.put(8969, 21);
        a.put(8970, 20);
        a.put(8971, 21);
        a.put(9984, 28);
        a.put(11840, 19);
        a.put(11841, 24);
        a.put(11842, 20);
        a.put(42648, 0);
        a.put(42649, 1);
        a.put(42650, 0);
        a.put(42651, 1);
        a.put(42652, 3);
        a.put(42653, 3);
        a.put(42654, 5);
        a.put(42895, 4);
        a.put(42902, 0);
        a.put(42903, 1);
        a.put(42904, 0);
        a.put(42905, 1);
        a.put(42906, 0);
        a.put(42907, 1);
        a.put(42908, 0);
        a.put(42909, 1);
        a.put(42910, 0);
        a.put(42911, 1);
        a.put(42933, 1);
        a.put(42935, 1);
        a.put(42999, 4);
        a.put(43260, 24);
        a.put(43261, 4);
        a.put(43493, 5);
        a.put(43494, 3);
        a.put(43644, 5);
        a.put(43645, 6);
        a.put(43867, 27);
        a.put(64830, 21);
        a.put(64831, 20);
    }
}

