/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.core.System.ByteArrayUtil;

public class BitConverter {
    public static final boolean IsLittleEndian = true;

    public static int toUInt16(byte[] value, int startIndex) {
        return ByteArrayUtil.getShort(value, startIndex << 3, true) & 0xFFFF;
    }

    public static long toUInt32(byte[] value, int startIndex) {
        return (long)ByteArrayUtil.getInt(value, startIndex << 3, true) & 0xFFFFFFFFL;
    }

    public static long toUInt64(byte[] value, int startIndex) {
        return ByteArrayUtil.getLong(value, startIndex << 3, true);
    }

    public static int toInt16(byte[] value, int startIndex) {
        return ByteArrayUtil.getShort(value, startIndex << 3, true);
    }

    public static int toInt32(byte[] value, int startIndex) {
        return ByteArrayUtil.getInt(value, startIndex << 3, true);
    }

    public static long toInt64(byte[] value, int startIndex) {
        return ByteArrayUtil.getLong(value, startIndex << 3, true);
    }

    public static boolean toBoolean(byte[] value, int startIndex) {
        return value[startIndex] != 0;
    }

    public static char toChar(byte[] value, int startIndex) {
        return (char)ByteArrayUtil.getShort(value, startIndex << 3, true);
    }

    public static float toSingle(byte[] value, int startIndex) {
        return ByteArrayUtil.getFloat(value, startIndex << 3, true);
    }

    public static double toDouble(byte[] value, int startIndex) {
        return ByteArrayUtil.getDouble(value, startIndex << 3, true);
    }

    public static byte[] getBytes(byte value) {
        return new byte[]{value};
    }

    public static byte[] getBytesBoolean(Boolean value) {
        byte[] byArray = new byte[]{(byte)(value != false ? 1 : 0)};
        return byArray;
    }

    public static byte[] getBytesChar(char value) {
        return BitConverter.getBytesInt16((short)value);
    }

    public static byte[] getBytesDouble(double value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static byte[] getBytesSingle(float value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static byte[] getBytesInt16(short value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static byte[] getBytesUInt16(int value) {
        return ByteArrayUtil.toArray((short)(value & 0xFFFF), true);
    }

    public static byte[] getBytesInt32(int value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static byte[] getBytesUInt32(long value) {
        return ByteArrayUtil.toArray((int)(value & 0xFFFFFFFFL), true);
    }

    public static byte[] getBytesInt64(long value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static byte[] getBytesUInt64(long value) {
        return ByteArrayUtil.toArray(value, true);
    }

    public static String toString(byte[] value) {
        return BitConverter.toString(value, 0);
    }

    public static String toString(byte[] value, int startIndex) {
        int n2 = value.length - startIndex;
        return BitConverter.toString(value, startIndex, n2);
    }

    public static String toString(byte[] value, int startIndex, int length) {
        byte[] byArray = new byte[length];
        System.arraycopy(value, startIndex, byArray, 0, length);
        return ByteArrayUtil.toString(byArray, ByteArrayUtil.Format.HEX, ByteArrayUtil.Separator.HYPHEN, false, ByteArrayUtil.Declaration.NONE);
    }

    public static double int64BitsToDouble(long value) {
        return BitConverter.toDouble(BitConverter.getBytesInt64(value), 0);
    }

    public static long doubleToInt64Bits(double value) {
        return BitConverter.toInt64(BitConverter.getBytesDouble(value), 0);
    }
}

