/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.collections;

import com.aspose.html.HTMLDocument;
import com.aspose.html.collections.IDOMCollectionIndexer;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.attributes.DOMAccessorAttribute;
import com.aspose.html.dom.attributes.DOMIndexerAttribute;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.z2;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p4.z27;
import com.aspose.html.internal.p4.z28;
import com.aspose.html.internal.p4.z36;
import com.aspose.html.internal.p68.z1;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="NamedNodeMap")
@DOMIndexerAttribute(indexerType="Attr")
public class NamedNodeMap
extends DOMObject
implements IDOMCollectionIndexer<Attr>,
IGenericEnumerable<Attr>,
IDisposable,
z27<Attr> {
    private final Element owner;
    private z36<Attr> attributeObservers = new z36();
    private List<Attr> nodes;

    public NamedNodeMap(Element element) {
        this.owner = element;
        this.nodes = new List();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(Element element, Attr attr) {
        IGenericEnumerator iGenericEnumerator = element.getAttributes().nodes.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Attr attr2 = (Attr)iGenericEnumerator.next();
                if (attr2 != attr) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attr getAttribute(String qualifiedName, Element element) {
        if (StringExtensions.equals(element.getNamespaceURI(), z2.z8.m3811) && Operators.is(element.nodeDocument, HTMLDocument.class)) {
            qualifiedName = StringExtensions.toLowerInvariant(qualifiedName);
        }
        IGenericEnumerator iGenericEnumerator = element.getAttributes().nodes.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Attr attr = (Attr)iGenericEnumerator.next();
                if (!StringExtensions.equals(qualifiedName, attr.getName())) continue;
                Attr attr2 = attr;
                return attr2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attr getAttribute(String namespace, String localName, Element element) {
        if (StringExtensions.isNullOrEmpty(namespace)) {
            namespace = null;
        }
        IGenericEnumerator iGenericEnumerator = element.getAttributes().nodes.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Attr attr = (Attr)iGenericEnumerator.next();
                if (!StringExtensions.equals(namespace, attr.getNamespaceURI()) || !StringExtensions.equals(localName, attr.getLocalName())) continue;
                Attr attr2 = attr;
                return attr2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return null;
    }

    public static Attr setAttribute(Attr attr, Element element) {
        if (attr.getOwnerElement() != null && attr.getOwnerElement() != element) {
            throw z1.m1215();
        }
        Attr attr2 = NamedNodeMap.getAttribute(attr.getNamespaceURI(), attr.getLocalName(), element);
        if (ObjectExtensions.referenceEquals(attr, attr2)) {
            return attr;
        }
        if (attr2 != null) {
            NamedNodeMap.replace(attr2, attr, element);
        } else {
            NamedNodeMap.append(attr, element);
        }
        return attr2;
    }

    public static Attr removeAttribute(String qualifiedName, Element element) {
        Attr attr = NamedNodeMap.getAttribute(qualifiedName, element);
        if (attr != null) {
            NamedNodeMap.remove(attr, element);
        }
        return attr;
    }

    public static Attr removeAttribute(String namespace, String localName, Element element) {
        Attr attr = NamedNodeMap.getAttribute(namespace, localName, element);
        if (attr != null) {
            NamedNodeMap.remove(attr, element);
        }
        return attr;
    }

    public static String getAttributeValue(Element element, String namespace, String localName) {
        Attr attr = NamedNodeMap.getAttribute(namespace, localName, element);
        if (attr == null) {
            return StringExtensions.Empty;
        }
        return attr.getValue();
    }

    public static void setAttribute(Element element, String localName, String value, String prefix, String namespace) {
        Attr attr;
        if (StringExtensions.isNullOrEmpty(prefix)) {
            prefix = null;
        }
        if (StringExtensions.isNullOrEmpty(namespace)) {
            namespace = null;
        }
        if ((attr = NamedNodeMap.getAttribute(namespace, localName, element)) == null) {
            attr = new Attr(z8.m1(localName, prefix, namespace, element.nodeDocument), element.getOwnerDocument());
            Attr.setValue(element, attr, value);
            NamedNodeMap.append(attr, element);
            return;
        }
        Attr.change(attr, element, value);
    }

    public static void replace(Attr oldAttr, Attr newAttr, Element element) {
        ((z3)element.getOwnerDocument().getContext()).m1(element, oldAttr.getLocalName(), oldAttr.getNamespaceURI(), oldAttr.getValue());
        z3.m2().m1(element, oldAttr.getLocalName(), oldAttr.getValue(), newAttr.getValue(), oldAttr.getNamespaceURI());
        List<Attr> list = element.getAttributes().nodes;
        list.set_Item(list.indexOf(oldAttr), newAttr);
        oldAttr.setOwnerElement(null);
        newAttr.setOwnerElement(element);
        element.getAttributes().notifyAttributeChanged(newAttr);
        if (element.EventMap.m247(newAttr.getName())) {
            com.aspose.html.dom.events.z1 z1100 = element.EventMap.m245(newAttr.getName());
            z1100.m244(newAttr.getValue());
        }
    }

    public static void append(Attr attr, Element element) {
        ((z3)element.getOwnerDocument().getContext()).m1(element, attr.getLocalName(), attr.getNamespaceURI(), null);
        element.getAttributes().nodes.addItem(attr);
        attr.setOwnerElement(element);
        z3.m2().m1(element, attr.getLocalName(), null, attr.getValue(), attr.getNamespaceURI());
        element.getAttributes().notifyAttributeChanged(attr);
        if (element.EventMap.m247(attr.getName())) {
            com.aspose.html.dom.events.z1 z1100 = element.EventMap.m245(attr.getName());
            z1100.m244(attr.getValue());
        }
    }

    public static void remove(Attr attr, Element element) {
        ((z3)element.getOwnerDocument().getContext()).m1(element, attr.getLocalName(), attr.getNamespaceURI(), attr.getValue());
        z3.m2().m1(element, attr.getLocalName(), attr.getValue(), null, attr.getNamespaceURI());
        element.getAttributes().nodes.removeItem(attr);
        attr.setOwnerElement(null);
        element.getAttributes().notifyAttributeChanged(attr);
        if (element.EventMap.m247(attr.getName())) {
            com.aspose.html.dom.events.z1 z1100 = element.EventMap.m245(attr.getName());
            z1100.m244(null);
        }
    }

    @DOMNameAttribute(name="length")
    public int getLength() {
        return this.nodes.size();
    }

    @Override
    @DOMNameAttribute(name="item")
    public Attr get_Item(int index) {
        return index >= 0 && index < this.nodes.size() ? this.nodes.get_Item(index) : null;
    }

    @DOMAccessorAttribute(type=1)
    public Attr get_Item(String name) {
        return this.getNamedItem(name);
    }

    @DOMNameAttribute(name="getNamedItem")
    public Attr getNamedItem(String name) {
        return NamedNodeMap.getAttribute(name, this.owner);
    }

    @DOMNameAttribute(name="getNamedItemNS")
    public Attr getNamedItemNS(String namespaceURI, String localName) {
        return NamedNodeMap.getAttribute(namespaceURI, localName, this.owner);
    }

    @DOMNameAttribute(name="setNamedItem")
    public Attr setNamedItem(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this.owner);
    }

    @DOMNameAttribute(name="setNamedItemNS")
    public Attr setNamedItemNS(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this.owner);
    }

    @DOMNameAttribute(name="removeNamedItem")
    public Attr removeNamedItem(String name) {
        Attr attr = NamedNodeMap.removeAttribute(name, this.owner);
        if (attr == null) {
            throw z1.m1213();
        }
        return attr;
    }

    @DOMNameAttribute(name="removeNamedItemNS")
    public Attr removeNamedItemNS(String namespaceURI, String localName) {
        Attr attr = NamedNodeMap.removeAttribute(namespaceURI, localName, this.owner);
        if (attr == null) {
            throw z1.m1213();
        }
        return attr;
    }

    @Override
    public IGenericEnumerator<Attr> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public IDisposable subscribe(z28<Attr> observer) {
        return this.attributeObservers.subscribe(observer);
    }

    public void notifyAttributeChanged(Attr attr) {
        this.attributeObservers.m1(attr);
    }

    @Override
    public void dispose() {
        if (this.attributeObservers != null) {
            this.attributeObservers.dispose();
        }
    }
}

