/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.IHTMLOptionsCollection;
import com.aspose.html.collections.z2;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLSelectElement")
public class HTMLSelectElement
extends HTMLElement {
    private HTMLFormElement form;
    private int selectedIndex = -1;

    public HTMLSelectElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    @DOMNameAttribute(name="selectedIndex")
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @DOMNameAttribute(name="selectedIndex")
    public void setSelectedIndex(int value) {
        if (value < 0 || value > this.getLength() - 1) {
            this.selectedIndex = -1;
        }
        this.selectedIndex = value;
    }

    @DOMNameAttribute(name="value")
    public String getValue() {
        IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                if (!((HTMLOptionElement)iGenericEnumerator.next()).getSelected()) continue;
                String string = ((HTMLOptionElement)iGenericEnumerator.next()).getTextContent();
                return string;
            }
        }
        finally {
            if (iGenericEnumerator != null) {
                iGenericEnumerator.dispose();
            }
        }
        return StringExtensions.Empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="value")
    public void setValue(String value) {
        IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ((HTMLOptionElement)iGenericEnumerator.next()).setSelected(false);
            }
            iGenericEnumerator.reset();
            int n2 = 0;
            int n3 = -1;
            while (iGenericEnumerator.hasNext()) {
                if (StringExtensions.equals(((Element)iGenericEnumerator.next()).getTextContent(), value)) {
                    n3 = n2;
                    ((HTMLOptionElement)iGenericEnumerator.next()).setSelected(true);
                    break;
                }
                ++n2;
            }
            this.selectedIndex = n3;
        }
        finally {
            if (iGenericEnumerator != null) {
                iGenericEnumerator.dispose();
            }
        }
    }

    @DOMNameAttribute(name="length")
    public int getLength() {
        return this.getOptions().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="length")
    public void setLength(int value) {
        if (value == this.getOptions().getLength()) {
            return;
        }
        if (value < 0) {
            value = 0;
        }
        if (value < this.getOptions().getLength()) {
            IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
            List<Element> list = new List<Element>();
            while (iGenericEnumerator.hasNext()) {
                if (value == 0) {
                    list.addItem((Element)iGenericEnumerator.next());
                    continue;
                }
                --value;
            }
            IGenericEnumerator iGenericEnumerator2 = list.iterator();
            try {
                while (iGenericEnumerator2.hasNext()) {
                    Node node = (Node)iGenericEnumerator2.next();
                    this.removeChild(node);
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator2, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return;
        }
        for (int i2 = value - this.getOptions().getLength(); i2 != 0; --i2) {
            this.appendChild(this.getOwnerDocument().createElement("OPTION"));
        }
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    @DOMNameAttribute(name="options")
    public IHTMLOptionsCollection getOptions() {
        return new z2((Node)this, "OPTION");
    }

    @DOMNameAttribute(name="disabled")
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @DOMNameAttribute(name="disabled")
    public void setDisabled(boolean value) {
        this.toggleAttribute("disabled", value);
    }

    @DOMNameAttribute(name="multiple")
    public boolean getMultiple() {
        return this.hasAttribute("multiple");
    }

    @DOMNameAttribute(name="multiple")
    public void setMultiple(boolean value) {
        this.toggleAttribute("multiple", value);
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.getAttributeOrDefault("name", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="name")
    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @DOMNameAttribute(name="size")
    public int getSize() {
        return this.getAttributeOrDefault("size", 0);
    }

    @DOMNameAttribute(name="size")
    public void setSize(int value) {
        this.setAttribute("size", value);
    }

    @DOMNameAttribute(name="tabIndex")
    public int getTabIndex() {
        return this.getAttributeOrDefault("tabindex", 0);
    }

    @DOMNameAttribute(name="tabIndex")
    public void setTabIndex(int value) {
        this.setAttribute("tabindex", value);
    }

    @DOMNameAttribute(name="add")
    public void add(HTMLElement element, HTMLElement before) {
    }

    @DOMNameAttribute(name="remove")
    public void remove(int index) {
    }

    @DOMNameAttribute(name="blur")
    public void blur() {
    }

    @DOMNameAttribute(name="focus")
    public void focus() {
    }
}

