/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.ResponseMessage;
import com.aspose.html.services.INetworkService;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLFrameElement")
public class HTMLFrameElement
extends HTMLElement {
    private HTMLDocument document;

    public HTMLFrameElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="frameBorder")
    public String getFrameBorder() {
        return this.getAttributeOrDefault("frameborder", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="frameBorder")
    public void setFrameBorder(String value) {
        this.setAttribute("frameborder", value);
    }

    @DOMNameAttribute(name="longDesc")
    public String getLongDesc() {
        return this.getAttributeOrDefault("longdesc", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="longDesc")
    public void setLongDesc(String value) {
        this.setAttribute("longdesc", value);
    }

    @DOMNameAttribute(name="marginHeight")
    public String getMarginHeight() {
        return this.getAttributeOrDefault("marginheight", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="marginHeight")
    public void setMarginHeight(String value) {
        this.setAttribute("marginheight", value);
    }

    @DOMNameAttribute(name="marginWidth")
    public String getMarginWidth() {
        return this.getAttributeOrDefault("marginwidth", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="marginWidth")
    public void setMarginWidth(String value) {
        this.setAttribute("marginwidth", value);
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.getAttributeOrDefault("name", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="name")
    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @DOMNameAttribute(name="noResize")
    public boolean getNoResize() {
        return this.hasAttribute("noresize");
    }

    @DOMNameAttribute(name="noResize")
    public void setNoResize(boolean value) {
        this.toggleAttribute("noresize", value);
    }

    @DOMNameAttribute(name="scrolling")
    public String getScrolling() {
        return this.getAttributeOrDefault("scrolling", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="scrolling")
    public void setScrolling(String value) {
        this.setAttribute("scrolling", value);
    }

    @DOMNameAttribute(name="src")
    public String getSrc() {
        return this.getAttributeOrDefault("src", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="src")
    public void setSrc(String value) {
        this.setAttribute("src", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="contentDocument")
    public HTMLDocument getContentDocument() {
        if (this.document == null) {
            if (StringExtensions.isNullOrEmpty(this.getSrc())) {
                return null;
            }
            Url url = this.getOwnerDocument().getContext().getService(INetworkService.class).getUrlResolver().resolve(this.getOwnerDocument().getBaseURI(), this.getSrc());
            RequestMessage requestMessage = new RequestMessage(url);
            try {
                ResponseMessage responseMessage = this.getOwnerDocument().getContext().getNetwork().send(requestMessage);
                try {
                    if (responseMessage.isSuccess()) {
                        z3 z3100 = this.getOwnerDocument().getBrowsingContext().m3();
                        this.document = Operators.as(z3100.m1(responseMessage), HTMLDocument.class);
                    }
                }
                finally {
                    if (responseMessage != null) {
                        responseMessage.dispose();
                    }
                }
            }
            finally {
                if (requestMessage != null) {
                    requestMessage.dispose();
                }
            }
        }
        return this.document;
    }
}

