/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l34I;

import com.aspose.font.internal.l334.I27;
import com.aspose.font.internal.l334.I2I;
import com.aspose.font.internal.l334.I2l;
import com.aspose.font.internal.l34I.I127;
import com.aspose.font.internal.l34I.I34;
import com.aspose.font.internal.l34I.I41;
import com.aspose.font.internal.l34I.I5l;
import com.aspose.font.internal.l34I.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class I114
extends CertPathBuilderSpi {
    private final I34 lif;
    private II ll;

    I114(I34 i34) {
        this.lif = i34;
    }

    public CertPathBuilderResult engineBuild(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        I2I i2I = null;
        if (certPathParameters instanceof I2I) {
            i2I = (I2I)certPathParameters;
        } else if (certPathParameters instanceof PKIXBuilderParameters) {
            i2I = new I2I.I7((PKIXBuilderParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + I2I.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        I2l i2l = i2I.lif().lIf();
        try {
            collection = I41.lif(i2l, i2I.lif().lif());
            collection.addAll(I41.lif(i2l, i2I.lif().l0iF()));
        }
        catch (II iI) {
            throw new CertPathBuilderException("Error finding target certificate.", iI);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.lif(x509Certificate, i2I, arrayList);
        }
        if (certPathBuilderResult == null && this.ll != null) {
            throw new CertPathBuilderException(this.ll.getMessage(), this.ll.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    protected CertPathBuilderResult lif(X509Certificate x509Certificate, I2I i2I, List list) throws CertPathBuilderException {
        I127 i127;
        I5l i5l;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (i2I.ll().contains(x509Certificate)) {
            return null;
        }
        if (i2I.lI() != -1 && list.size() - 1 > i2I.lI()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            i5l = new I5l(this.lif);
            i127 = new I127(this.lif);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (I41.lif(x509Certificate, i2I.lif().lf(), i2I.lif().l0l()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
                try {
                    certPath = i5l.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)i127.engineValidate(certPath, i2I);
                }
                catch (Exception exception) {
                    throw new II("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<I27> arrayList = new ArrayList<I27>();
            arrayList.addAll(i2I.lif().lif());
            try {
                arrayList.addAll(I41.lif(x509Certificate.getExtensionValue(com.aspose.font.internal.l29I.I34.llf.ll()), i2I.lif().ll()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new II("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(I41.lif(x509Certificate, i2I.lif().l0iF(), arrayList));
            }
            catch (II iI) {
                throw new II("Cannot find issuer certificate for certificate in certification path.", iI);
            }
            if (hashSet.isEmpty()) {
                throw new II("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.lif(x509Certificate2, i2I, list);
            }
        }
        catch (II iI) {
            this.ll = iI;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

