/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.internal.lI.I0l;
import com.aspose.font.internal.lI.I7l;

public class TransformationMatrix {
    private double[] lif;

    public double getA() {
        return this.lif[0];
    }

    public void setA(double value) {
        this.lif[0] = value;
    }

    public double getB() {
        return this.lif[1];
    }

    public void setB(double value) {
        this.lif[1] = value;
    }

    public double getC() {
        return this.lif[2];
    }

    public void setC(double value) {
        this.lif[2] = value;
    }

    public double getD() {
        return this.lif[3];
    }

    public void setD(double value) {
        this.lif[3] = value;
    }

    public double getTX() {
        return this.lif[4];
    }

    public void setTX(double value) {
        this.lif[4] = value;
    }

    public double getTY() {
        return this.lif[5];
    }

    public void setTY(double value) {
        this.lif[5] = value;
    }

    public TransformationMatrix() {
        this.lif = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    }

    public TransformationMatrix(double[] matrixArray) {
        if (matrixArray.length != 6) {
            throw new I0l();
        }
        this.lif = matrixArray;
    }

    public void transform(double x, double y, double[] x1, double[] y1) {
        x1[0] = this.getA() * x + this.getC() * y + this.getTX();
        y1[0] = this.getB() * x + this.getD() * y + this.getTY();
    }

    public void unTransform(double x1, double y1, double[] x, double[] y) {
        x[0] = (this.getD() * x1 - this.getC() * y1 + this.getC() * this.getTY()) / (this.getA() * this.getD() - this.getC() * this.getB());
        y[0] = (this.getA() * y1 - this.getB() * x1 + this.getB() * this.getTX()) / (this.getA() * this.getD() - this.getC() * this.getB());
    }

    public void unScale(double x1, double y1, double[] x, double[] y) {
        x[0] = (this.getD() * x1 - this.getC() * y1) / (this.getA() * this.getD() - this.getC() * this.getB());
        y[0] = (this.getA() * y1 - this.getB() * x1) / (this.getA() * this.getD() - this.getC() * this.getB());
    }

    public void scale(double x, double y, double[] x1, double[] y1) {
        x1[0] = this.getA() * x + this.getC() * y;
        y1[0] = this.getB() * x + this.getD() * y;
    }

    public TransformationMatrix multiply(TransformationMatrix matrix) {
        TransformationMatrix transformationMatrix = new TransformationMatrix();
        transformationMatrix.setA(this.getA() * matrix.getA() + this.getB() * matrix.getC());
        transformationMatrix.setB(this.getA() * matrix.getB() + this.getB() * matrix.getD());
        transformationMatrix.setC(this.getC() * matrix.getA() + this.getD() * matrix.getC());
        transformationMatrix.setD(this.getC() * matrix.getB() + this.getD() * matrix.getD());
        transformationMatrix.setTX(this.getTX() * matrix.getA() + this.getTY() * matrix.getC() + matrix.getTX());
        transformationMatrix.setTY(this.getTX() * matrix.getB() + this.getTY() * matrix.getD() + matrix.getTY());
        return transformationMatrix;
    }

    public double[] toArray() {
        return (double[])this.lif.clone();
    }

    public double get(int index) {
        return this.lif[index];
    }

    @com.aspose.font.internal.l67l.I0l
    Object lif() {
        return new TransformationMatrix((double[])this.lif.clone());
    }

    boolean lif(TransformationMatrix transformationMatrix) {
        return I7l.ll(this.getA(), transformationMatrix.getA()) && I7l.ll(this.getB(), transformationMatrix.getB()) && I7l.ll(this.getC(), transformationMatrix.getC()) && I7l.ll(this.getD(), transformationMatrix.getD()) && I7l.ll(this.getTX(), transformationMatrix.getTX()) && I7l.ll(this.getTY(), transformationMatrix.getTY());
    }
}

