/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.ByteContentStreamSource;
import com.aspose.font.FontDefinition;
import com.aspose.font.FontException;
import com.aspose.font.FontFileDefinition;
import com.aspose.font.FontNotSupportedOperationException;
import com.aspose.font.FontSavingFormats;
import com.aspose.font.FontType;
import com.aspose.font.Glyph;
import com.aspose.font.GlyphId;
import com.aspose.font.GlyphIdType;
import com.aspose.font.GlyphStringId;
import com.aspose.font.GlyphUInt32Id;
import com.aspose.font.I164;
import com.aspose.font.I197;
import com.aspose.font.I26I;
import com.aspose.font.I287;
import com.aspose.font.I28I;
import com.aspose.font.I28l;
import com.aspose.font.I34I;
import com.aspose.font.I367;
import com.aspose.font.I36I;
import com.aspose.font.I36l;
import com.aspose.font.I657;
import com.aspose.font.IFont;
import com.aspose.font.IFontEncoding;
import com.aspose.font.IFontMetrics;
import com.aspose.font.IFontSaver;
import com.aspose.font.IGlyphAccessor;
import com.aspose.font.MultiLanguageString;
import com.aspose.font.StreamSource;
import com.aspose.font.TtfFont;
import com.aspose.font.internal.l21.I04;
import com.aspose.font.internal.l21.I1I;
import com.aspose.font.internal.l21.I2l;
import com.aspose.font.internal.l21.I31;
import com.aspose.font.internal.l21.I37;
import com.aspose.font.internal.l5I.I07;
import com.aspose.font.internal.l5I.I17;
import com.aspose.font.internal.l677.II;
import com.aspose.font.internal.l677.Il;
import com.aspose.font.internal.l67l.I1;
import com.aspose.font.internal.lI.I181;
import com.aspose.font.internal.lI.I7I;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Font
implements IFont,
IFontSaver,
IGlyphAccessor {
    private static I34I lif;
    private I28l ll = new I28l();
    private static final int lI = 1;
    private static final int l1 = 2;
    private static I17 lIF;
    private static ThreadLocal<Boolean> llf;

    Font() {
    }

    public static Font open(FontDefinition fontDefinition) {
        try {
            I287 i287 = I287.lif(fontDefinition.getFontType());
            return i287.lif(fontDefinition);
        }
        catch (RuntimeException runtimeException) {
            lif.lif(I181.lif("Could not create font. \r\nFont definition: \r\n{0}", new Object[]{I197.lif(fontDefinition)}), runtimeException);
            throw runtimeException;
        }
    }

    static Font lif(I36l i36l, I367 i367) {
        try {
            FontDefinition fontDefinition = i367.lif(i36l);
            if (fontDefinition != null) {
                return Font.open(fontDefinition);
            }
        }
        catch (RuntimeException runtimeException) {
            lif.lif(I181.lif("Could not find font. The IFontSearcher throwed exception {0}", new Object[]{runtimeException.toString()}));
        }
        return null;
    }

    public static Font open(FontType fontType, StreamSource fontStreamSource) {
        FontFileDefinition fontFileDefinition = new FontFileDefinition(fontStreamSource);
        FontDefinition fontDefinition = new FontDefinition(fontType, fontFileDefinition);
        return Font.open(fontDefinition);
    }

    public static Font open(FontType fontType, String fileName) {
        FontFileDefinition fontFileDefinition = new FontFileDefinition(new I1I(fileName));
        FontDefinition fontDefinition = new FontDefinition(fontType, fontFileDefinition);
        return Font.open(fontDefinition);
    }

    public static Font open(FontType fontType, byte[] fontData) {
        FontDefinition fontDefinition = new FontDefinition(fontType, new ByteContentStreamSource(fontData));
        return Font.open(fontDefinition);
    }

    static Font lif(FontType fontType) {
        if (fontType == FontType.TTF) {
            return TtfFont.llf();
        }
        throw new FontNotSupportedOperationException();
    }

    static Font lif(FontType fontType, Font font, I26I i26I) {
        if (fontType == FontType.TTF) {
            return TtfFont.lif(font, i26I);
        }
        throw new FontNotSupportedOperationException();
    }

    void lif(I31 i31) {
        I28I i28I = I28I.lif(this, i31, 0);
        i28I.lif();
    }

    @Override
    public void save(OutputStream stream) {
        II.lif(new Il(stream){

            @Override
            public void lif(I31 i31) {
                Font.this.lif(i31);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String fileName) {
        I2l i2l = I04.ll(fileName);
        try {
            I28I i28I = I28I.lif(this, i2l, 0);
            i28I.lif();
        }
        finally {
            if (i2l != null) {
                i2l.dispose();
            }
        }
    }

    @Override
    public void saveToFormat(OutputStream stream, FontSavingFormats outFormat) throws IOException {
        int n;
        I37 i37 = new I37();
        TtfFont ttfFont = I1.ll((Object)this, TtfFont.class) ? (TtfFont)((Object)I1.lif(this, TtfFont.class)) : I164.lif().l1().lif(this).lif();
        I657 i657 = (I657)((Object)I1.lif(I28I.lif(ttfFont, i37, 0), I657.class));
        if (i657 == null) {
            throw new FontException("Incorrect font saver passed when saving TTF font to format specified");
        }
        switch (outFormat) {
            case TTF: {
                i657.lif();
                break;
            }
            case WOFF: {
                i657.ll();
                break;
            }
            case WOFF2: {
                i657.lI();
            }
        }
        i37.lif(0L);
        byte[] byArray = new byte[4096];
        while ((n = i37.lif(byArray, 0, byArray.length)) > 0) {
            stream.write(byArray, 0, n);
        }
    }

    void lif(I31 i31, int n) {
        I28I i28I = I28I.lif(this, i31, n);
        i28I.lif();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lif(String string, int n) {
        I2l i2l = I04.ll(string);
        try {
            I28I i28I = I28I.lif(this, i2l, n);
            i28I.lif();
        }
        finally {
            if (i2l != null) {
                i2l.dispose();
            }
        }
    }

    @Override
    public abstract Font convert(FontType var1);

    abstract I36I lIF();

    static void lif(String string, String[] stringArray, String[] stringArray2) {
        stringArray[0] = string;
        stringArray2[0] = I181.lif;
        I07 i07 = lIF.ll(stringArray[0]);
        if (i07.lIF()) {
            stringArray[0] = i07.lIf().lif(2).lI();
            stringArray2[0] = i07.lIf().lif(1).lI();
        }
    }

    @Override
    public GlyphId[] getGlyphsForText(String text) {
        GlyphId[] glyphIdArray = new GlyphId[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            GlyphId glyphId = this.getEncoding().unicodeToGid(text.charAt(i));
            if (glyphId == null) {
                glyphId = this.getGlyphIdType() == GlyphIdType.Int32Index ? GlyphUInt32Id.getNotDefId() : GlyphStringId.getNotDefId();
            }
            glyphIdArray[i] = glyphId;
        }
        return glyphIdArray;
    }

    @Override
    public abstract FontType getFontType();

    @Override
    public abstract String getStyle();

    @Override
    public abstract void setStyle(String var1);

    @Override
    public abstract int getFontStyle();

    @Override
    public abstract String getFontFamily();

    @Override
    public abstract void setFontFamily(String var1);

    @Override
    public abstract String getFontName();

    @Override
    public abstract void setFontName(String var1);

    @Override
    public abstract MultiLanguageString getFontNames();

    abstract void lif(MultiLanguageString var1);

    @Override
    public abstract MultiLanguageString getPostscriptNames();

    abstract void ll(MultiLanguageString var1);

    @Override
    public abstract int getNumGlyphs();

    @Override
    public abstract IFontMetrics getMetrics();

    @Override
    public abstract IFontEncoding getEncoding();

    @Override
    public IGlyphAccessor getGlyphAccessor() {
        return this;
    }

    @Override
    public abstract Glyph getGlyphById(GlyphId var1);

    @Override
    public abstract GlyphId[] getAllGlyphIds();

    @Override
    public abstract GlyphIdType getGlyphIdType();

    @Override
    public abstract FontDefinition getFontDefinition();

    @Override
    public IFontSaver getFontSaver() {
        return this;
    }

    I28l l0if() {
        return this.ll;
    }

    static int lIF(String string) {
        int n = 0;
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.indexOf("italic") != -1) {
                n |= 4;
            }
            if (string2.indexOf("bold") != -1) {
                n |= 2;
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    static {
        lIF = new I17("([A-Z]{6})\\+(.*)?");
        llf = new ThreadLocal();
        llf.set(false);
        lif = I164.lif().ll().lif();
    }

    static final class I7
    extends I7I {
        public static final byte lif = 0;
        public static final byte ll = 1;

        private I7() {
        }

        static {
            I7I.register(new I7I.I4((Class)I7.class, Byte.class){
                {
                    this.lif("SaveAllTables", 0L);
                    this.lif("SavePdfTables", 1L);
                }
            });
        }
    }
}

