/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.BorderCornerStyle;
import com.aspose.asposecloudpdf.model.BorderInfo;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.ColumnAdjustment;
import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.LinkElement;
import com.aspose.asposecloudpdf.model.MarginInfo;
import com.aspose.asposecloudpdf.model.Row;
import com.aspose.asposecloudpdf.model.TableBroken;
import com.aspose.asposecloudpdf.model.TextRect;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a table that can be added to the page.")
public class Table
extends LinkElement {
    @SerializedName(value="Alignment")
    private HorizontalAlignment alignment = null;
    @SerializedName(value="HorizontalAlignment")
    private HorizontalAlignment horizontalAlignment = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="Top")
    private Double top = null;
    @SerializedName(value="Left")
    private Double left = null;
    @SerializedName(value="DefaultCellTextState")
    private TextState defaultCellTextState = null;
    @SerializedName(value="DefaultCellPadding")
    private MarginInfo defaultCellPadding = null;
    @SerializedName(value="Border")
    private BorderInfo border = null;
    @SerializedName(value="Margin")
    private MarginInfo margin = null;
    @SerializedName(value="Rows")
    private List<Row> rows = new ArrayList<Row>();
    @SerializedName(value="DefaultColumnWidth")
    private String defaultColumnWidth = null;
    @SerializedName(value="DefaultCellBorder")
    private BorderInfo defaultCellBorder = null;
    @SerializedName(value="Broken")
    private TableBroken broken = null;
    @SerializedName(value="ColumnWidths")
    private String columnWidths = null;
    @SerializedName(value="RepeatingRowsCount")
    private Integer repeatingRowsCount = null;
    @SerializedName(value="RepeatingColumnsCount")
    private Integer repeatingColumnsCount = null;
    @SerializedName(value="RepeatingRowsStyle")
    private TextState repeatingRowsStyle = null;
    @SerializedName(value="CornerStyle")
    private BorderCornerStyle cornerStyle = null;
    @SerializedName(value="BreakText")
    private TextRect breakText = null;
    @SerializedName(value="BackgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="IsBordersIncluded")
    private Boolean isBordersIncluded = null;
    @SerializedName(value="ColumnAdjustment")
    private ColumnAdjustment columnAdjustment = null;
    @SerializedName(value="ZIndex")
    private Integer zindex = null;

    public Table alignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @ApiModelProperty(value="Gets HorizontalAlignment of the table alignment.")
    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public Table horizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets HorizontalAlignment of the table alignment.")
    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public Table verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets VerticalAlignment of the annotation.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public Table top(Double top) {
        this.top = top;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table top coordinate.")
    public Double getTop() {
        return this.top;
    }

    public void setTop(Double top) {
        this.top = top;
    }

    public Table left(Double left) {
        this.left = left;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table left coordinate.")
    public Double getLeft() {
        return this.left;
    }

    public void setLeft(Double left) {
        this.left = left;
    }

    public Table defaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the default cell text state.")
    public TextState getDefaultCellTextState() {
        return this.defaultCellTextState;
    }

    public void setDefaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
    }

    public Table defaultCellPadding(MarginInfo defaultCellPadding) {
        this.defaultCellPadding = defaultCellPadding;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the default cell padding.")
    public MarginInfo getDefaultCellPadding() {
        return this.defaultCellPadding;
    }

    public void setDefaultCellPadding(MarginInfo defaultCellPadding) {
        this.defaultCellPadding = defaultCellPadding;
    }

    public Table border(BorderInfo border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the border.")
    public BorderInfo getBorder() {
        return this.border;
    }

    public void setBorder(BorderInfo border) {
        this.border = border;
    }

    public Table margin(MarginInfo margin) {
        this.margin = margin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets a outer margin for paragraph (for pdf generation)")
    public MarginInfo getMargin() {
        return this.margin;
    }

    public void setMargin(MarginInfo margin) {
        this.margin = margin;
    }

    public Table rows(List<Row> rows) {
        this.rows = rows;
        return this;
    }

    public Table addRowsItem(Row rowsItem) {
        this.rows.add(rowsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Sets the rows of the table.")
    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public Table defaultColumnWidth(String defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
        return this;
    }

    @ApiModelProperty(value="Gets default cell border;")
    public String getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(String defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public Table defaultCellBorder(BorderInfo defaultCellBorder) {
        this.defaultCellBorder = defaultCellBorder;
        return this;
    }

    @ApiModelProperty(value="Gets default cell border;")
    public BorderInfo getDefaultCellBorder() {
        return this.defaultCellBorder;
    }

    public void setDefaultCellBorder(BorderInfo defaultCellBorder) {
        this.defaultCellBorder = defaultCellBorder;
    }

    public Table broken(TableBroken broken) {
        this.broken = broken;
        return this;
    }

    @ApiModelProperty(value="Gets or sets table vertial broken;")
    public TableBroken getBroken() {
        return this.broken;
    }

    public void setBroken(TableBroken broken) {
        this.broken = broken;
    }

    public Table columnWidths(String columnWidths) {
        this.columnWidths = columnWidths;
        return this;
    }

    @ApiModelProperty(value="Gets the column widths of the table.")
    public String getColumnWidths() {
        return this.columnWidths;
    }

    public void setColumnWidths(String columnWidths) {
        this.columnWidths = columnWidths;
    }

    public Table repeatingRowsCount(Integer repeatingRowsCount) {
        this.repeatingRowsCount = repeatingRowsCount;
        return this;
    }

    @ApiModelProperty(value="Gets the first rows count repeated for several pages")
    public Integer getRepeatingRowsCount() {
        return this.repeatingRowsCount;
    }

    public void setRepeatingRowsCount(Integer repeatingRowsCount) {
        this.repeatingRowsCount = repeatingRowsCount;
    }

    public Table repeatingColumnsCount(Integer repeatingColumnsCount) {
        this.repeatingColumnsCount = repeatingColumnsCount;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the maximum columns count for table")
    public Integer getRepeatingColumnsCount() {
        return this.repeatingColumnsCount;
    }

    public void setRepeatingColumnsCount(Integer repeatingColumnsCount) {
        this.repeatingColumnsCount = repeatingColumnsCount;
    }

    public Table repeatingRowsStyle(TextState repeatingRowsStyle) {
        this.repeatingRowsStyle = repeatingRowsStyle;
        return this;
    }

    @ApiModelProperty(value="Gets the style for repeating rows")
    public TextState getRepeatingRowsStyle() {
        return this.repeatingRowsStyle;
    }

    public void setRepeatingRowsStyle(TextState repeatingRowsStyle) {
        this.repeatingRowsStyle = repeatingRowsStyle;
    }

    public Table cornerStyle(BorderCornerStyle cornerStyle) {
        this.cornerStyle = cornerStyle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the styles of the border corners")
    public BorderCornerStyle getCornerStyle() {
        return this.cornerStyle;
    }

    public void setCornerStyle(BorderCornerStyle cornerStyle) {
        this.cornerStyle = cornerStyle;
    }

    public Table breakText(TextRect breakText) {
        this.breakText = breakText;
        return this;
    }

    @ApiModelProperty(value="Gets or sets break text for table")
    public TextRect getBreakText() {
        return this.breakText;
    }

    public void setBreakText(TextRect breakText) {
        this.breakText = breakText;
    }

    public Table backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets table background color")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Table isBordersIncluded(Boolean isBordersIncluded) {
        this.isBordersIncluded = isBordersIncluded;
        return this;
    }

    @ApiModelProperty(value="Gets or sets border included in column widhts.")
    public Boolean isIsBordersIncluded() {
        return this.isBordersIncluded;
    }

    public void setIsBordersIncluded(Boolean isBordersIncluded) {
        this.isBordersIncluded = isBordersIncluded;
    }

    public Table columnAdjustment(ColumnAdjustment columnAdjustment) {
        this.columnAdjustment = columnAdjustment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the table column adjustment.")
    public ColumnAdjustment getColumnAdjustment() {
        return this.columnAdjustment;
    }

    public void setColumnAdjustment(ColumnAdjustment columnAdjustment) {
        this.columnAdjustment = columnAdjustment;
    }

    public Table zindex(Integer zindex) {
        this.zindex = zindex;
        return this;
    }

    @ApiModelProperty(value="Gets ZIndex of the annotation.")
    public Integer getZindex() {
        return this.zindex;
    }

    public void setZindex(Integer zindex) {
        this.zindex = zindex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals((Object)this.alignment, (Object)table.alignment) && Objects.equals((Object)this.horizontalAlignment, (Object)table.horizontalAlignment) && Objects.equals((Object)this.verticalAlignment, (Object)table.verticalAlignment) && Objects.equals(this.top, table.top) && Objects.equals(this.left, table.left) && Objects.equals(this.defaultCellTextState, table.defaultCellTextState) && Objects.equals(this.defaultCellPadding, table.defaultCellPadding) && Objects.equals(this.border, table.border) && Objects.equals(this.margin, table.margin) && Objects.equals(this.rows, table.rows) && Objects.equals(this.defaultColumnWidth, table.defaultColumnWidth) && Objects.equals(this.defaultCellBorder, table.defaultCellBorder) && Objects.equals((Object)this.broken, (Object)table.broken) && Objects.equals(this.columnWidths, table.columnWidths) && Objects.equals(this.repeatingRowsCount, table.repeatingRowsCount) && Objects.equals(this.repeatingColumnsCount, table.repeatingColumnsCount) && Objects.equals(this.repeatingRowsStyle, table.repeatingRowsStyle) && Objects.equals((Object)this.cornerStyle, (Object)table.cornerStyle) && Objects.equals(this.breakText, table.breakText) && Objects.equals(this.backgroundColor, table.backgroundColor) && Objects.equals(this.isBordersIncluded, table.isBordersIncluded) && Objects.equals((Object)this.columnAdjustment, (Object)table.columnAdjustment) && Objects.equals(this.zindex, table.zindex) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.alignment, this.horizontalAlignment, this.verticalAlignment, this.top, this.left, this.defaultCellTextState, this.defaultCellPadding, this.border, this.margin, this.rows, this.defaultColumnWidth, this.defaultCellBorder, this.broken, this.columnWidths, this.repeatingRowsCount, this.repeatingColumnsCount, this.repeatingRowsStyle, this.cornerStyle, this.breakText, this.backgroundColor, this.isBordersIncluded, this.columnAdjustment, this.zindex, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Table {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString((Object)this.horizontalAlignment)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    defaultCellTextState: ").append(this.toIndentedString(this.defaultCellTextState)).append("\n");
        sb.append("    defaultCellPadding: ").append(this.toIndentedString(this.defaultCellPadding)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("    defaultColumnWidth: ").append(this.toIndentedString(this.defaultColumnWidth)).append("\n");
        sb.append("    defaultCellBorder: ").append(this.toIndentedString(this.defaultCellBorder)).append("\n");
        sb.append("    broken: ").append(this.toIndentedString((Object)this.broken)).append("\n");
        sb.append("    columnWidths: ").append(this.toIndentedString(this.columnWidths)).append("\n");
        sb.append("    repeatingRowsCount: ").append(this.toIndentedString(this.repeatingRowsCount)).append("\n");
        sb.append("    repeatingColumnsCount: ").append(this.toIndentedString(this.repeatingColumnsCount)).append("\n");
        sb.append("    repeatingRowsStyle: ").append(this.toIndentedString(this.repeatingRowsStyle)).append("\n");
        sb.append("    cornerStyle: ").append(this.toIndentedString((Object)this.cornerStyle)).append("\n");
        sb.append("    breakText: ").append(this.toIndentedString(this.breakText)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    isBordersIncluded: ").append(this.toIndentedString(this.isBordersIncluded)).append("\n");
        sb.append("    columnAdjustment: ").append(this.toIndentedString((Object)this.columnAdjustment)).append("\n");
        sb.append("    zindex: ").append(this.toIndentedString(this.zindex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

