/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.MarkupAnnotation;
import com.aspose.asposecloudpdf.model.SoundEncoding;
import com.aspose.asposecloudpdf.model.SoundIcon;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides SoundAnnotation.")
public class SoundAnnotation
extends MarkupAnnotation {
    @SerializedName(value="FilePath")
    private String filePath = null;
    @SerializedName(value="Icon")
    private SoundIcon icon = null;
    @SerializedName(value="Rate")
    private Integer rate = null;
    @SerializedName(value="Channels")
    private Integer channels = null;
    @SerializedName(value="Bits")
    private Integer bits = null;
    @SerializedName(value="Encoding")
    private SoundEncoding encoding = null;

    public SoundAnnotation filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    @ApiModelProperty(required=true, value="A sound file path defining the sound to be played when the annotation is activated.")
    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public SoundAnnotation icon(SoundIcon icon) {
        this.icon = icon;
        return this;
    }

    @ApiModelProperty(value="Gets or sets an icon to be used in displaying the annotation.")
    public SoundIcon getIcon() {
        return this.icon;
    }

    public void setIcon(SoundIcon icon) {
        this.icon = icon;
    }

    public SoundAnnotation rate(Integer rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the sampling rate, in samples per second.")
    public Integer getRate() {
        return this.rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public SoundAnnotation channels(Integer channels) {
        this.channels = channels;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the number of sound channels.")
    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }

    public SoundAnnotation bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the number of bits per sample value per channel.")
    public Integer getBits() {
        return this.bits;
    }

    public void setBits(Integer bits) {
        this.bits = bits;
    }

    public SoundAnnotation encoding(SoundEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the encoding format for the sample data.")
    public SoundEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(SoundEncoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoundAnnotation soundAnnotation = (SoundAnnotation)o;
        return Objects.equals(this.filePath, soundAnnotation.filePath) && Objects.equals((Object)this.icon, (Object)soundAnnotation.icon) && Objects.equals(this.rate, soundAnnotation.rate) && Objects.equals(this.channels, soundAnnotation.channels) && Objects.equals(this.bits, soundAnnotation.bits) && Objects.equals((Object)this.encoding, (Object)soundAnnotation.encoding) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.filePath, this.icon, this.rate, this.channels, this.bits, this.encoding, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SoundAnnotation {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString((Object)this.icon)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("    bits: ").append(this.toIndentedString(this.bits)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString((Object)this.encoding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

