/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents Pdf optimize options.")
public class OptimizeOptions {
    @SerializedName(value="AllowReusePageContent")
    private Boolean allowReusePageContent = null;
    @SerializedName(value="CompressImages")
    private Boolean compressImages = null;
    @SerializedName(value="ImageQuality")
    private Integer imageQuality = null;
    @SerializedName(value="LinkDuplcateStreams")
    private Boolean linkDuplcateStreams = null;
    @SerializedName(value="RemoveUnusedObjects")
    private Boolean removeUnusedObjects = null;
    @SerializedName(value="RemoveUnusedStreams")
    private Boolean removeUnusedStreams = null;
    @SerializedName(value="UnembedFonts")
    private Boolean unembedFonts = null;

    public OptimizeOptions allowReusePageContent(Boolean allowReusePageContent) {
        this.allowReusePageContent = allowReusePageContent;
        return this;
    }

    @ApiModelProperty(required=true, value="If true page contents will be reused when document is optimized for equal pages.")
    public Boolean isAllowReusePageContent() {
        return this.allowReusePageContent;
    }

    public void setAllowReusePageContent(Boolean allowReusePageContent) {
        this.allowReusePageContent = allowReusePageContent;
    }

    public OptimizeOptions compressImages(Boolean compressImages) {
        this.compressImages = compressImages;
        return this;
    }

    @ApiModelProperty(required=true, value="If this flag is set to true images will be compressed in the document. compression level is specfied with ImageQuality property.")
    public Boolean isCompressImages() {
        return this.compressImages;
    }

    public void setCompressImages(Boolean compressImages) {
        this.compressImages = compressImages;
    }

    public OptimizeOptions imageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifie slevel of image compression when CompressIamges flag is used.")
    public Integer getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(Integer imageQuality) {
        this.imageQuality = imageQuality;
    }

    public OptimizeOptions linkDuplcateStreams(Boolean linkDuplcateStreams) {
        this.linkDuplcateStreams = linkDuplcateStreams;
        return this;
    }

    @ApiModelProperty(required=true, value="If this flag is set to true, Resource streams will be analyzed. If duplicate streams are found (i.e. if stream contents is equal), then thes streams will be stored as one object.  This allows to decrease document size in some cases (for example, when same document was concatenedted multiple times).")
    public Boolean isLinkDuplcateStreams() {
        return this.linkDuplcateStreams;
    }

    public void setLinkDuplcateStreams(Boolean linkDuplcateStreams) {
        this.linkDuplcateStreams = linkDuplcateStreams;
    }

    public OptimizeOptions removeUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
        return this;
    }

    @ApiModelProperty(required=true, value="If this flag is set to true, all document objects will be checked and unused objects (i.e. objects which does not have any reference) are removed from document.")
    public Boolean isRemoveUnusedObjects() {
        return this.removeUnusedObjects;
    }

    public void setRemoveUnusedObjects(Boolean removeUnusedObjects) {
        this.removeUnusedObjects = removeUnusedObjects;
    }

    public OptimizeOptions removeUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
        return this;
    }

    @ApiModelProperty(required=true, value="If this flag set to true, every resource is checked on it's usage. If resource is never used, then resources is removed. This may decrease document size for example when pages were extracted from document. ")
    public Boolean isRemoveUnusedStreams() {
        return this.removeUnusedStreams;
    }

    public void setRemoveUnusedStreams(Boolean removeUnusedStreams) {
        this.removeUnusedStreams = removeUnusedStreams;
    }

    public OptimizeOptions unembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
        return this;
    }

    @ApiModelProperty(required=true, value="Make fonts not embedded if set to true. ")
    public Boolean isUnembedFonts() {
        return this.unembedFonts;
    }

    public void setUnembedFonts(Boolean unembedFonts) {
        this.unembedFonts = unembedFonts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptimizeOptions optimizeOptions = (OptimizeOptions)o;
        return Objects.equals(this.allowReusePageContent, optimizeOptions.allowReusePageContent) && Objects.equals(this.compressImages, optimizeOptions.compressImages) && Objects.equals(this.imageQuality, optimizeOptions.imageQuality) && Objects.equals(this.linkDuplcateStreams, optimizeOptions.linkDuplcateStreams) && Objects.equals(this.removeUnusedObjects, optimizeOptions.removeUnusedObjects) && Objects.equals(this.removeUnusedStreams, optimizeOptions.removeUnusedStreams) && Objects.equals(this.unembedFonts, optimizeOptions.unembedFonts);
    }

    public int hashCode() {
        return Objects.hash(this.allowReusePageContent, this.compressImages, this.imageQuality, this.linkDuplcateStreams, this.removeUnusedObjects, this.removeUnusedStreams, this.unembedFonts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptimizeOptions {\n");
        sb.append("    allowReusePageContent: ").append(this.toIndentedString(this.allowReusePageContent)).append("\n");
        sb.append("    compressImages: ").append(this.toIndentedString(this.compressImages)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString(this.imageQuality)).append("\n");
        sb.append("    linkDuplcateStreams: ").append(this.toIndentedString(this.linkDuplcateStreams)).append("\n");
        sb.append("    removeUnusedObjects: ").append(this.toIndentedString(this.removeUnusedObjects)).append("\n");
        sb.append("    removeUnusedStreams: ").append(this.toIndentedString(this.removeUnusedStreams)).append("\n");
        sb.append("    unembedFonts: ").append(this.toIndentedString(this.unembedFonts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

