/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.Direction;
import com.aspose.asposecloudpdf.model.LinkElement;
import com.aspose.asposecloudpdf.model.PageLayout;
import com.aspose.asposecloudpdf.model.PageMode;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Provides link to DisplayProperties.")
public class DisplayProperties
extends LinkElement {
    @SerializedName(value="CenterWindow")
    private Boolean centerWindow = null;
    @SerializedName(value="Direction")
    private Direction direction = null;
    @SerializedName(value="DisplayDocTitle")
    private Boolean displayDocTitle = null;
    @SerializedName(value="HideMenuBar")
    private Boolean hideMenuBar = null;
    @SerializedName(value="HideToolBar")
    private Boolean hideToolBar = null;
    @SerializedName(value="HideWindowUI")
    private Boolean hideWindowUI = null;
    @SerializedName(value="NonFullScreenPageMode")
    private PageMode nonFullScreenPageMode = null;
    @SerializedName(value="PageLayout")
    private PageLayout pageLayout = null;
    @SerializedName(value="PageMode")
    private PageMode pageMode = null;

    public DisplayProperties centerWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
        return this;
    }

    @ApiModelProperty(value="Gets or sets flag specifying whether position of the document's window will be centerd on the screen.")
    public Boolean isCenterWindow() {
        return this.centerWindow;
    }

    public void setCenterWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
    }

    public DisplayProperties direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="Gets or sets reading order of text: L2R (left to right) or R2L (right to left).")
    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public DisplayProperties displayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
        return this;
    }

    @ApiModelProperty(value="Gets or sets flag specifying whether document's window title bar should display document title.")
    public Boolean isDisplayDocTitle() {
        return this.displayDocTitle;
    }

    public void setDisplayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
    }

    public DisplayProperties hideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
        return this;
    }

    @ApiModelProperty(value="Gets or sets flag specifying whether menu bar should be hidden when document is active.")
    public Boolean isHideMenuBar() {
        return this.hideMenuBar;
    }

    public void setHideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
    }

    public DisplayProperties hideToolBar(Boolean hideToolBar) {
        this.hideToolBar = hideToolBar;
        return this;
    }

    @ApiModelProperty(value="Gets or sets flag specifying whether toolbar should be hidden when document is active.")
    public Boolean isHideToolBar() {
        return this.hideToolBar;
    }

    public void setHideToolBar(Boolean hideToolBar) {
        this.hideToolBar = hideToolBar;
    }

    public DisplayProperties hideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
        return this;
    }

    @ApiModelProperty(value="Gets or sets flag specifying whether user interface elements should be hidden when document is active.")
    public Boolean isHideWindowUI() {
        return this.hideWindowUI;
    }

    public void setHideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
    }

    public DisplayProperties nonFullScreenPageMode(PageMode nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
        return this;
    }

    @ApiModelProperty(value="Gets or sets page mode, specifying how to display the document on exiting full-screen mode.")
    public PageMode getNonFullScreenPageMode() {
        return this.nonFullScreenPageMode;
    }

    public void setNonFullScreenPageMode(PageMode nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
    }

    public DisplayProperties pageLayout(PageLayout pageLayout) {
        this.pageLayout = pageLayout;
        return this;
    }

    @ApiModelProperty(value="Gets or sets page layout which shall be used when the document is opened.")
    public PageLayout getPageLayout() {
        return this.pageLayout;
    }

    public void setPageLayout(PageLayout pageLayout) {
        this.pageLayout = pageLayout;
    }

    public DisplayProperties pageMode(PageMode pageMode) {
        this.pageMode = pageMode;
        return this;
    }

    @ApiModelProperty(value="Gets or sets page mode, specifying how document should be displayed when opened.")
    public PageMode getPageMode() {
        return this.pageMode;
    }

    public void setPageMode(PageMode pageMode) {
        this.pageMode = pageMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayProperties displayProperties = (DisplayProperties)o;
        return Objects.equals(this.centerWindow, displayProperties.centerWindow) && Objects.equals((Object)this.direction, (Object)displayProperties.direction) && Objects.equals(this.displayDocTitle, displayProperties.displayDocTitle) && Objects.equals(this.hideMenuBar, displayProperties.hideMenuBar) && Objects.equals(this.hideToolBar, displayProperties.hideToolBar) && Objects.equals(this.hideWindowUI, displayProperties.hideWindowUI) && Objects.equals((Object)this.nonFullScreenPageMode, (Object)displayProperties.nonFullScreenPageMode) && Objects.equals((Object)this.pageLayout, (Object)displayProperties.pageLayout) && Objects.equals((Object)this.pageMode, (Object)displayProperties.pageMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.centerWindow, this.direction, this.displayDocTitle, this.hideMenuBar, this.hideToolBar, this.hideWindowUI, this.nonFullScreenPageMode, this.pageLayout, this.pageMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DisplayProperties {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    centerWindow: ").append(this.toIndentedString(this.centerWindow)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    displayDocTitle: ").append(this.toIndentedString(this.displayDocTitle)).append("\n");
        sb.append("    hideMenuBar: ").append(this.toIndentedString(this.hideMenuBar)).append("\n");
        sb.append("    hideToolBar: ").append(this.toIndentedString(this.hideToolBar)).append("\n");
        sb.append("    hideWindowUI: ").append(this.toIndentedString(this.hideWindowUI)).append("\n");
        sb.append("    nonFullScreenPageMode: ").append(this.toIndentedString((Object)this.nonFullScreenPageMode)).append("\n");
        sb.append("    pageLayout: ").append(this.toIndentedString((Object)this.pageLayout)).append("\n");
        sb.append("    pageMode: ").append(this.toIndentedString((Object)this.pageMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

