/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.asposecloudpdf.model;

import com.aspose.asposecloudpdf.model.BorderInfo;
import com.aspose.asposecloudpdf.model.Color;
import com.aspose.asposecloudpdf.model.HorizontalAlignment;
import com.aspose.asposecloudpdf.model.ImageFragment;
import com.aspose.asposecloudpdf.model.MarginInfo;
import com.aspose.asposecloudpdf.model.TextRect;
import com.aspose.asposecloudpdf.model.TextState;
import com.aspose.asposecloudpdf.model.VerticalAlignment;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a cell of the table's row.")
public class Cell {
    @SerializedName(value="IsNoBorder")
    private Boolean isNoBorder = null;
    @SerializedName(value="Margin")
    private MarginInfo margin = null;
    @SerializedName(value="Border")
    private BorderInfo border = null;
    @SerializedName(value="BackgroundColor")
    private Color backgroundColor = null;
    @SerializedName(value="BackgroundImageFile")
    private String backgroundImageFile = null;
    @SerializedName(value="BackgroundImageStorageFile")
    private String backgroundImageStorageFile = null;
    @SerializedName(value="Alignment")
    private HorizontalAlignment alignment = null;
    @SerializedName(value="DefaultCellTextState")
    private TextState defaultCellTextState = null;
    @SerializedName(value="Paragraphs")
    private List<TextRect> paragraphs = null;
    @SerializedName(value="IsWordWrapped")
    private Boolean isWordWrapped = null;
    @SerializedName(value="VerticalAlignment")
    private VerticalAlignment verticalAlignment = null;
    @SerializedName(value="ColSpan")
    private Integer colSpan = null;
    @SerializedName(value="RowSpan")
    private Integer rowSpan = null;
    @SerializedName(value="Width")
    private Double width = null;
    @SerializedName(value="HtmlFragment")
    private String htmlFragment = null;
    @SerializedName(value="Images")
    private List<ImageFragment> images = null;

    public Cell isNoBorder(Boolean isNoBorder) {
        this.isNoBorder = isNoBorder;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the cell have border.")
    public Boolean isIsNoBorder() {
        return this.isNoBorder;
    }

    public void setIsNoBorder(Boolean isNoBorder) {
        this.isNoBorder = isNoBorder;
    }

    public Cell margin(MarginInfo margin) {
        this.margin = margin;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the padding.")
    public MarginInfo getMargin() {
        return this.margin;
    }

    public void setMargin(MarginInfo margin) {
        this.margin = margin;
    }

    public Cell border(BorderInfo border) {
        this.border = border;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the border.")
    public BorderInfo getBorder() {
        return this.border;
    }

    public void setBorder(BorderInfo border) {
        this.border = border;
    }

    public Cell backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background color.")
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Cell backgroundImageFile(String backgroundImageFile) {
        this.backgroundImageFile = backgroundImageFile;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the background image file.")
    public String getBackgroundImageFile() {
        return this.backgroundImageFile;
    }

    public void setBackgroundImageFile(String backgroundImageFile) {
        this.backgroundImageFile = backgroundImageFile;
    }

    public Cell backgroundImageStorageFile(String backgroundImageStorageFile) {
        this.backgroundImageStorageFile = backgroundImageStorageFile;
        return this;
    }

    @ApiModelProperty(value="Gets or sets path of the background image file from storage.")
    public String getBackgroundImageStorageFile() {
        return this.backgroundImageStorageFile;
    }

    public void setBackgroundImageStorageFile(String backgroundImageStorageFile) {
        this.backgroundImageStorageFile = backgroundImageStorageFile;
    }

    public Cell alignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the alignment.")
    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public Cell defaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the default cell text state.")
    public TextState getDefaultCellTextState() {
        return this.defaultCellTextState;
    }

    public void setDefaultCellTextState(TextState defaultCellTextState) {
        this.defaultCellTextState = defaultCellTextState;
    }

    public Cell paragraphs(List<TextRect> paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public Cell addParagraphsItem(TextRect paragraphsItem) {
        if (this.paragraphs == null) {
            this.paragraphs = new ArrayList<TextRect>();
        }
        this.paragraphs.add(paragraphsItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets the cell's formatted text.")
    public List<TextRect> getParagraphs() {
        return this.paragraphs;
    }

    public void setParagraphs(List<TextRect> paragraphs) {
        this.paragraphs = paragraphs;
    }

    public Cell isWordWrapped(Boolean isWordWrapped) {
        this.isWordWrapped = isWordWrapped;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the cell's text word wrapped.")
    public Boolean isIsWordWrapped() {
        return this.isWordWrapped;
    }

    public void setIsWordWrapped(Boolean isWordWrapped) {
        this.isWordWrapped = isWordWrapped;
    }

    public Cell verticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the vertical alignment.")
    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public Cell colSpan(Integer colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the column span.")
    public Integer getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(Integer colSpan) {
        this.colSpan = colSpan;
    }

    public Cell rowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the row span.")
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
    }

    public Cell width(Double width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="Gets or sets the column width.")
    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Cell htmlFragment(String htmlFragment) {
        this.htmlFragment = htmlFragment;
        return this;
    }

    @ApiModelProperty(value="Gets or sets Html fragment.")
    public String getHtmlFragment() {
        return this.htmlFragment;
    }

    public void setHtmlFragment(String htmlFragment) {
        this.htmlFragment = htmlFragment;
    }

    public Cell images(List<ImageFragment> images) {
        this.images = images;
        return this;
    }

    public Cell addImagesItem(ImageFragment imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<ImageFragment>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @ApiModelProperty(value="Gets or sets ImageFragment list.")
    public List<ImageFragment> getImages() {
        return this.images;
    }

    public void setImages(List<ImageFragment> images) {
        this.images = images;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return Objects.equals(this.isNoBorder, cell.isNoBorder) && Objects.equals(this.margin, cell.margin) && Objects.equals(this.border, cell.border) && Objects.equals(this.backgroundColor, cell.backgroundColor) && Objects.equals(this.backgroundImageFile, cell.backgroundImageFile) && Objects.equals(this.backgroundImageStorageFile, cell.backgroundImageStorageFile) && Objects.equals((Object)this.alignment, (Object)cell.alignment) && Objects.equals(this.defaultCellTextState, cell.defaultCellTextState) && Objects.equals(this.paragraphs, cell.paragraphs) && Objects.equals(this.isWordWrapped, cell.isWordWrapped) && Objects.equals((Object)this.verticalAlignment, (Object)cell.verticalAlignment) && Objects.equals(this.colSpan, cell.colSpan) && Objects.equals(this.rowSpan, cell.rowSpan) && Objects.equals(this.width, cell.width) && Objects.equals(this.htmlFragment, cell.htmlFragment) && Objects.equals(this.images, cell.images);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isNoBorder, this.margin, this.border, this.backgroundColor, this.backgroundImageFile, this.backgroundImageStorageFile, this.alignment, this.defaultCellTextState, this.paragraphs, this.isWordWrapped, this.verticalAlignment, this.colSpan, this.rowSpan, this.width, this.htmlFragment, this.images});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Cell {\n");
        sb.append("    isNoBorder: ").append(this.toIndentedString(this.isNoBorder)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    backgroundImageFile: ").append(this.toIndentedString(this.backgroundImageFile)).append("\n");
        sb.append("    backgroundImageStorageFile: ").append(this.toIndentedString(this.backgroundImageStorageFile)).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    defaultCellTextState: ").append(this.toIndentedString(this.defaultCellTextState)).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.paragraphs)).append("\n");
        sb.append("    isWordWrapped: ").append(this.toIndentedString(this.isWordWrapped)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.verticalAlignment)).append("\n");
        sb.append("    colSpan: ").append(this.toIndentedString(this.colSpan)).append("\n");
        sb.append("    rowSpan: ").append(this.toIndentedString(this.rowSpan)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    htmlFragment: ").append(this.toIndentedString(this.htmlFragment)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

