/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class VdcExtent
extends Command {
    private CgmPoint a;
    private CgmPoint b;

    public final CgmPoint getLowerLeftCorner() {
        return this.a;
    }

    public final void setLowerLeftCorner(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final CgmPoint getUpperRightCorner() {
        return this.b;
    }

    public final void setUpperRightCorner(CgmPoint cgmPoint) {
        this.b = cgmPoint;
    }

    public VdcExtent(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 6, cgmFile));
    }

    public VdcExtent(CgmFile cgmFile, CgmPoint cgmPoint, CgmPoint cgmPoint2) {
        this(cgmFile);
        this.setLowerLeftCorner(cgmPoint);
        this.setUpperRightCorner(cgmPoint2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setLowerLeftCorner(iBinaryReader.readPoint());
        this.setUpperRightCorner(iBinaryReader.readPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getLowerLeftCorner());
        iBinaryWriter.writePoint(this.getUpperRightCorner());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  vdcext %s %s;", this.writePoint(this.getLowerLeftCorner()), this.writePoint(this.getUpperRightCorner())));
    }

    @Override
    public String toString() {
        return String.format("VDCExtent [%s,%s] [%s,%s]", VdcExtent.writeDouble(this.getLowerLeftCorner().getX()), VdcExtent.writeDouble(this.getLowerLeftCorner().getY()), VdcExtent.writeDouble(this.getUpperRightCorner().getX()), VdcExtent.writeDouble(this.getUpperRightCorner().getY()));
    }
}

