/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmColor;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.TextPrecisionType;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class TextRepresentation
extends Command {
    private int a;
    private int b;
    private TextPrecisionType c;
    private double d;
    private double e;
    private CgmColor f;

    public final int getBundleIndex() {
        return this.a;
    }

    public final void setBundleIndex(int n2) {
        this.a = n2;
    }

    public final int getFontIndex() {
        return this.b;
    }

    public final void setFontIndex(int n2) {
        this.b = n2;
    }

    public final TextPrecisionType getPrecision() {
        return this.c;
    }

    public final void setPrecision(TextPrecisionType textPrecisionType) {
        this.c = textPrecisionType;
    }

    public final double getSpacing() {
        return this.d;
    }

    public final void setSpacing(double d2) {
        this.d = d2;
    }

    public final double getExpansion() {
        return this.e;
    }

    public final void setExpansion(double d2) {
        this.e = d2;
    }

    public final CgmColor getColor() {
        return this.f;
    }

    public final void setColor(CgmColor cgmColor) {
        this.f = cgmColor;
    }

    public TextRepresentation(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 13, cgmFile));
    }

    public TextRepresentation(CgmFile cgmFile, int n2, int n3, TextPrecisionType textPrecisionType, double d2, double d3, CgmColor cgmColor) {
        this(cgmFile);
        this.setBundleIndex(n2);
        this.setFontIndex(n3);
        this.setPrecision(textPrecisionType);
        this.setSpacing(d2);
        this.setExpansion(d3);
        this.setColor(cgmColor);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setBundleIndex(iBinaryReader.readIndex());
        this.setFontIndex(iBinaryReader.readIndex());
        this.setPrecision(TextPrecisionType.values()[iBinaryReader.readEnum()]);
        this.setSpacing(iBinaryReader.readReal());
        this.setExpansion(iBinaryReader.readReal());
        this.setColor(iBinaryReader.readColor());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getBundleIndex());
        iBinaryWriter.writeIndex(this.getFontIndex());
        iBinaryWriter.writeEnum(this.getPrecision().ordinal());
        iBinaryWriter.writeReal(this.getSpacing());
        iBinaryWriter.writeReal(this.getExpansion());
        iBinaryWriter.writeColor(this.getColor());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" TEXTREP %s %s %s %s %s %s;", this.writeIndex(this.getBundleIndex()), this.writeIndex(this.getFontIndex()), TextRepresentation.a(this.getPrecision().toString()), this.writeReal(this.getSpacing()), this.writeReal(this.getExpansion()), this.writeColor(this.getColor())));
    }
}

