/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.TextPrecisionType;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class TextPrecision
extends Command {
    private TextPrecisionType a;

    public final TextPrecisionType getValue() {
        return this.a;
    }

    public final void setValue(TextPrecisionType textPrecisionType) {
        this.a = textPrecisionType;
    }

    public TextPrecision(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 11, cgmFile));
    }

    public TextPrecision(CgmFile cgmFile, TextPrecisionType textPrecisionType) {
        this(cgmFile);
        this.setValue(textPrecisionType);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        switch (n2) {
            case 0: {
                this.setValue(TextPrecisionType.STRING);
                break;
            }
            case 1: {
                this.setValue(TextPrecisionType.CHAR);
                break;
            }
            case 2: {
                this.setValue(TextPrecisionType.STROKE);
                break;
            }
            default: {
                this.setValue(TextPrecisionType.STRING);
                iBinaryReader.unsupported(aX.a(new String[]{"unsupported text precision ", av.b(n2)}));
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getValue().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" TEXTPREC %s;", TextPrecision.a(this.getValue().toString())));
    }

    @Override
    public String toString() {
        return String.format("TextPrecision %d", new Object[]{this.getValue()});
    }
}

