/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.Tuple;
import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aq;
import com.aspose.cad.internal.eT.d;
import com.aspose.cad.system.collections.Generic.IGenericEnumerable;
import com.aspose.cad.system.collections.Generic.IGenericEnumerator;
import com.aspose.cad.system.collections.Generic.List;

public class PolygonSet
extends Command {
    private List<Tuple<EdgeFlag, CgmPoint>> a = new List();

    public final java.util.List<Tuple<EdgeFlag, CgmPoint>> getSet() {
        return List.toJava(this.a());
    }

    public final List<Tuple<EdgeFlag, CgmPoint>> a() {
        return this.a;
    }

    public final void setSet(java.util.List<Tuple<EdgeFlag, CgmPoint>> list) {
        this.a(List.fromJava(list));
    }

    public final void a(List<Tuple<EdgeFlag, CgmPoint>> list) {
        this.a = list;
    }

    public PolygonSet(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 8, cgmFile));
    }

    public PolygonSet(CgmFile cgmFile, IGenericEnumerable<Tuple<EdgeFlag, CgmPoint>> iGenericEnumerable) {
        this(cgmFile);
        this.a().addRange(iGenericEnumerable);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        PolygonSet.assert_(iBinaryReader.getArguments().length % (iBinaryReader.sizeOfPoint() + iBinaryReader.sizeOfEnum()) == 0, "Invalid amount of arguments");
        int n2 = iBinaryReader.getArguments().length / (iBinaryReader.sizeOfPoint() + iBinaryReader.sizeOfEnum());
        for (int i2 = 0; i2 < n2; ++i2) {
            CgmPoint cgmPoint = iBinaryReader.readPoint();
            EdgeFlag edgeFlag = EdgeFlag.values()[iBinaryReader.readEnum()];
            this.a().addItem(new Tuple<EdgeFlag, CgmPoint>(edgeFlag, cgmPoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Tuple tuple = (Tuple)iGenericEnumerator.next();
                iBinaryWriter.writePoint((CgmPoint)tuple.getItem2());
                iBinaryWriter.writeEnum(((EdgeFlag)((Object)tuple.getItem1())).ordinal());
            }
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(" POLYGONSET");
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Tuple tuple = (Tuple)iGenericEnumerator.next();
                iClearTextWriter.write(String.format(" %s %s", this.writePoint((CgmPoint)tuple.getItem2()), PolygonSet.a(((EdgeFlag)((Object)tuple.getItem1())).toString())));
            }
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    public String toString() {
        return "PolygonSet";
    }

    public static enum EdgeFlag {
        INVIS,
        VIS,
        CLOSEINVIS,
        CLOSEVIS;

    }
}

